/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.repository.ArtifactDoesNotExistException;
import org.apache.maven.repository.ArtifactTransferFailedException;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalArtifactRepository;
import org.apache.maven.repository.MetadataResolutionRequest;
import org.apache.maven.repository.MetadataResolutionResult;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.legacy.TransferListenerAdapter;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RepositorySystem.class, hint="default")
public class LegacyRepositorySystem
implements RepositorySystem {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> layouts;
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private MirrorSelector mirrorSelector;

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.artifactFactory.createArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.artifactFactory.createBuildArtifact(groupId, artifactId, version, packaging);
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.artifactFactory.createProjectArtifact(groupId, artifactId, metaVersionId);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : d.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ':' + exclusion.getArtifactId());
            }
            artifact.setDependencyFilter((ArtifactFilter)new ExcludesArtifactFilter(exclusions));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.artifactFactory.createExtensionArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.artifactFactory.createParentArtifact(groupId, artifactId, version);
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)plugin.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.artifactFactory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    public ArtifactRepository createDefaultLocalRepository() throws InvalidRepositoryException {
        return this.createLocalRepository(RepositorySystem.defaultUserLocalRepository);
    }

    public ArtifactRepository createLocalRepository(File localRepository) throws InvalidRepositoryException {
        return this.createRepository("file://" + localRepository.toURI().getRawPath(), "local", true, "always", true, "always", "ignore");
    }

    public ArtifactRepository createDefaultRemoteRepository() throws InvalidRepositoryException {
        return this.createRepository("http://repo1.maven.org/maven2", "central", true, "daily", false, "daily", "warn");
    }

    public ArtifactRepository createLocalRepository(String url, String repositoryId) throws IOException {
        return this.createRepository(this.canonicalFileUrl(url), repositoryId, true, "always", true, "always", "ignore");
    }

    private String canonicalFileUrl(String url) throws IOException {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        } else if (url.startsWith("file:") && !url.startsWith("file://")) {
            url = "file://" + url.substring("file:".length());
        }
        File localRepository = new File(url.substring("file://".length()));
        if (!localRepository.isAbsolute()) {
            url = "file://" + localRepository.getCanonicalPath();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        try {
            LocalArtifactRepository ideWorkspace = (LocalArtifactRepository)this.plexus.lookup(LocalArtifactRepository.class, "ide-workspace");
            if (request.getLocalRepository() instanceof DelegatingLocalArtifactRepository) {
                DelegatingLocalArtifactRepository delegatingLocalRepository = (DelegatingLocalArtifactRepository)request.getLocalRepository();
                LocalArtifactRepository orig = delegatingLocalRepository.getIdeWorspace();
                delegatingLocalRepository.setIdeWorkspace(ideWorkspace);
                try {
                    ArtifactResolutionResult artifactResolutionResult = this.artifactResolver.resolve(request);
                    return artifactResolutionResult;
                }
                finally {
                    delegatingLocalRepository.setIdeWorkspace(orig);
                }
            }
            ArtifactRepository localRepository = request.getLocalRepository();
            DelegatingLocalArtifactRepository delegatingLocalRepository = new DelegatingLocalArtifactRepository(localRepository);
            delegatingLocalRepository.setIdeWorkspace(ideWorkspace);
            request.setLocalRepository((ArtifactRepository)delegatingLocalRepository);
            try {
                ArtifactResolutionResult artifactResolutionResult = this.artifactResolver.resolve(request);
                return artifactResolutionResult;
            }
            finally {
                request.setLocalRepository(localRepository);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            return this.artifactResolver.resolve(request);
        }
    }

    public List<ArtifactRepository> getEffectiveRepositories(List<ArtifactRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        LinkedHashMap<String, ArrayList<ArtifactRepository>> reposByKey = new LinkedHashMap<String, ArrayList<ArtifactRepository>>();
        for (ArtifactRepository repository : repositories) {
            String key = repository.getId();
            ArrayList<ArtifactRepository> aliasedRepos = (ArrayList<ArtifactRepository>)reposByKey.get(key);
            if (aliasedRepos == null) {
                aliasedRepos = new ArrayList<ArtifactRepository>();
                reposByKey.put(key, aliasedRepos);
            }
            aliasedRepos.add(repository);
        }
        ArrayList<ArtifactRepository> effectiveRepositories = new ArrayList<ArtifactRepository>();
        for (List aliasedRepos : reposByKey.values()) {
            ArtifactRepository aliasedRepo3;
            ArrayList<ArtifactRepositoryPolicy> releasePolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo2 : aliasedRepos) {
                releasePolicies.add(aliasedRepo2.getReleases());
            }
            ArtifactRepositoryPolicy releasePolicy = this.getEffectivePolicy(releasePolicies);
            ArrayList<ArtifactRepositoryPolicy> snapshotPolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo3 : aliasedRepos) {
                snapshotPolicies.add(aliasedRepo3.getSnapshots());
            }
            ArtifactRepositoryPolicy snapshotPolicy = this.getEffectivePolicy(snapshotPolicies);
            aliasedRepo3 = (ArtifactRepository)aliasedRepos.get(0);
            ArtifactRepository effectiveRepository = this.createArtifactRepository(aliasedRepo3.getId(), aliasedRepo3.getUrl(), aliasedRepo3.getLayout(), snapshotPolicy, releasePolicy);
            effectiveRepository.setAuthentication(aliasedRepo3.getAuthentication());
            effectiveRepository.setProxy(aliasedRepo3.getProxy());
            effectiveRepositories.add(effectiveRepository);
        }
        return effectiveRepositories;
    }

    private ArtifactRepositoryPolicy getEffectivePolicy(Collection<ArtifactRepositoryPolicy> policies) {
        ArtifactRepositoryPolicy effectivePolicy = null;
        for (ArtifactRepositoryPolicy policy : policies) {
            if (effectivePolicy == null) {
                effectivePolicy = new ArtifactRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
                continue;
            }
            if (!policy.isEnabled()) continue;
            effectivePolicy.setEnabled(true);
            if (this.ordinalOfChecksumPolicy(policy.getChecksumPolicy()) < this.ordinalOfChecksumPolicy(effectivePolicy.getChecksumPolicy())) {
                effectivePolicy.setChecksumPolicy(policy.getChecksumPolicy());
            }
            if (this.ordinalOfUpdatePolicy(policy.getUpdatePolicy()) >= this.ordinalOfUpdatePolicy(effectivePolicy.getUpdatePolicy())) continue;
            effectivePolicy.setUpdatePolicy(policy.getUpdatePolicy());
        }
        return effectivePolicy;
    }

    private int ordinalOfChecksumPolicy(String policy) {
        if ("fail".equals(policy)) {
            return 2;
        }
        if ("ignore".equals(policy)) {
            return 0;
        }
        return 1;
    }

    private int ordinalOfUpdatePolicy(String policy) {
        if ("daily".equals(policy)) {
            return 1440;
        }
        if ("always".equals(policy)) {
            return 0;
        }
        if (policy != null && policy.startsWith("interval")) {
            return 60;
        }
        return Integer.MAX_VALUE;
    }

    public Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        return this.mirrorSelector.getMirror(repository, mirrors);
    }

    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(repository, mirrors);
                if (mirror == null) continue;
                repository.setId(mirror.getId());
                repository.setUrl(mirror.getUrl());
                ArtifactRepositoryLayout layout = this.layouts.get(mirror.getLayout());
                if (layout == null) continue;
                repository.setLayout(layout);
            }
        }
    }

    public void injectAuthentication(List<ArtifactRepository> repositories, List<Server> servers) {
        if (repositories != null) {
            HashMap<String, Server> serversById = new HashMap<String, Server>();
            if (servers != null) {
                for (Server server : servers) {
                    if (serversById.containsKey(server.getId())) continue;
                    serversById.put(server.getId(), server);
                }
            }
            for (ArtifactRepository repository : repositories) {
                Server server = (Server)serversById.get(repository.getId());
                if (server != null) {
                    Authentication authentication = new Authentication(server.getUsername(), server.getPassword());
                    repository.setAuthentication(authentication);
                    continue;
                }
                repository.setAuthentication(null);
            }
        }
    }

    private org.apache.maven.settings.Proxy getProxy(ArtifactRepository repository, List<org.apache.maven.settings.Proxy> proxies) {
        if (proxies != null && repository.getProtocol() != null) {
            for (org.apache.maven.settings.Proxy proxy : proxies) {
                if (!proxy.isActive() || !repository.getProtocol().equalsIgnoreCase(proxy.getProtocol())) continue;
                return proxy;
            }
        }
        return null;
    }

    public void injectProxy(List<ArtifactRepository> repositories, List<org.apache.maven.settings.Proxy> proxies) {
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                org.apache.maven.settings.Proxy proxy = this.getProxy(repository, proxies);
                if (proxy != null) {
                    Proxy p = new Proxy();
                    p.setHost(proxy.getHost());
                    p.setProtocol(proxy.getProtocol());
                    p.setPort(proxy.getPort());
                    p.setNonProxyHosts(proxy.getNonProxyHosts());
                    p.setUserName(proxy.getUsername());
                    p.setPassword(proxy.getPassword());
                    repository.setProxy(p);
                    continue;
                }
                repository.setProxy(null);
            }
        }
    }

    public MetadataResolutionResult resolveMetadata(MetadataResolutionRequest request) {
        return null;
    }

    public void retrieve(ArtifactRepository repository, File destination, String remotePath, ArtifactTransferListener transferListener) throws ArtifactTransferFailedException, ArtifactDoesNotExistException {
        try {
            this.wagonManager.getRemoteFile(repository, destination, remotePath, TransferListenerAdapter.newAdapter(transferListener), "warn", true);
        }
        catch (TransferFailedException e) {
            throw new ArtifactTransferFailedException("Error transferring artifact.", (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new ArtifactDoesNotExistException("Requested artifact does not exist.", (Throwable)e);
        }
    }

    public void publish(ArtifactRepository repository, File source, String remotePath, ArtifactTransferListener transferListener) throws ArtifactTransferFailedException {
        try {
            this.wagonManager.putRemoteFile(repository, source, remotePath, TransferListenerAdapter.newAdapter(transferListener));
        }
        catch (TransferFailedException e) {
            throw new ArtifactTransferFailedException("Error transferring artifact.", (Throwable)e);
        }
    }

    public ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (StringUtils.isEmpty((String)id)) {
                throw new InvalidRepositoryException("Repository identifier missing", "");
            }
            String url = repo.getUrl();
            if (StringUtils.isEmpty((String)url)) {
                throw new InvalidRepositoryException("URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = this.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = this.buildArtifactRepositoryPolicy(repo.getReleases());
            return this.createArtifactRepository(id, url, this.layouts.get(repo.getLayout()), snapshots, releases);
        }
        return null;
    }

    private ArtifactRepository createRepository(String url, String repositoryId, boolean releases, String releaseUpdates, boolean snapshots, String snapshotUpdates, String checksumPolicy) {
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(snapshots, snapshotUpdates, checksumPolicy);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(releases, releaseUpdates, checksumPolicy);
        return this.createArtifactRepository(repositoryId, url, null, snapshotsPolicy, releasesPolicy);
    }

    public ArtifactRepository createArtifactRepository(String repositoryId, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (repositoryLayout == null) {
            repositoryLayout = this.layouts.get("default");
        }
        ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, repositoryLayout, snapshots, releases);
        return artifactRepository;
    }
}

