/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.event;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.logwrapper.LogLevelRecorder;
import org.apache.maven.logwrapper.MavenSlf4jWrapperFactory;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private static final int MAX_LOG_PREFIX_SIZE = 8;
    private static final int PROJECT_STATUS_SUFFIX_SIZE = 20;
    private static final int MIN_TERMINAL_WIDTH = 60;
    private static final int DEFAULT_TERMINAL_WIDTH = 80;
    private static final int MAX_TERMINAL_WIDTH = 130;
    private static final int MAX_PADDED_BUILD_TIME_DURATION_LENGTH = 9;
    private final MessageBuilderFactory messageBuilderFactory;
    private final Logger logger;
    private final int terminalWidth;
    private final int lineLength;
    private final int maxProjectNameLength;
    private int totalProjects;
    private volatile int currentVisitedProjectCount;

    public ExecutionEventLogger(MessageBuilderFactory messageBuilderFactory) {
        this(messageBuilderFactory, LoggerFactory.getLogger(ExecutionEventLogger.class));
    }

    public ExecutionEventLogger(MessageBuilderFactory messageBuilderFactory, Logger logger) {
        this(messageBuilderFactory, logger, messageBuilderFactory.getTerminalWidth());
    }

    public ExecutionEventLogger(MessageBuilderFactory messageBuilderFactory, Logger logger, int terminalWidth) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.messageBuilderFactory = messageBuilderFactory;
        this.terminalWidth = Math.min(130, Math.max(terminalWidth < 0 ? 80 : terminalWidth, 60));
        this.lineLength = this.terminalWidth - 8;
        this.maxProjectNameLength = this.lineLength - 20;
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void infoLine(char c) {
        this.infoMain(ExecutionEventLogger.chars(c, this.lineLength));
    }

    private void infoMain(String msg) {
        this.logger.info(this.builder().strong((Object)msg).toString());
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning for projects...");
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            int projectsSkipped;
            this.infoLine('-');
            this.infoMain("Reactor Build Order:");
            this.logger.info("");
            List projects = event.getSession().getProjects();
            for (MavenProject project : projects) {
                int len = this.lineLength - project.getName().length() - project.getPackaging().length() - 2;
                this.logger.info("{}{}[{}]", new Object[]{project.getName(), ExecutionEventLogger.chars(' ', len > 0 ? len : 1), project.getPackaging()});
            }
            List allProjects = event.getSession().getAllProjects();
            this.currentVisitedProjectCount = projectsSkipped = allProjects.size() - projects.size();
            this.totalProjects = allProjects.size();
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            ILoggerFactory iLoggerFactory;
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            if ((iLoggerFactory = LoggerFactory.getILoggerFactory()) instanceof MavenSlf4jWrapperFactory) {
                MavenSlf4jWrapperFactory loggerFactory = (MavenSlf4jWrapperFactory)iLoggerFactory;
                loggerFactory.getLogLevelRecorder().filter(LogLevelRecorder::metThreshold).ifPresent(recorder -> event.getSession().getResult().addException((Throwable)new Exception("Build failed due to log statements with a higher severity than allowed. Fix the logged issues or remove flag --fail-on-severity (-fos).")));
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.infoLine('-');
        }
    }

    private boolean isSingleVersionedReactor(MavenSession session) {
        boolean result = true;
        MavenProject topProject = session.getTopLevelProject();
        List sortedProjects = session.getProjectDependencyGraph().getSortedProjects();
        for (MavenProject mavenProject : sortedProjects) {
            if (topProject.getVersion().equals(mavenProject.getVersion())) continue;
            result = false;
            break;
        }
        return result;
    }

    private void logReactorSummary(MavenSession session) {
        boolean isSingleVersion = this.isSingleVersionedReactor(session);
        this.infoLine('-');
        StringBuilder summary = new StringBuilder("Reactor Summary");
        if (isSingleVersion) {
            summary.append(" for ");
            summary.append(session.getTopLevelProject().getName());
            summary.append(" ");
            summary.append(session.getTopLevelProject().getVersion());
        }
        summary.append(":");
        this.infoMain(summary.toString());
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        List projects = session.getProjects();
        StringBuilder buffer = new StringBuilder(128);
        for (MavenProject project : projects) {
            int padSize;
            String buildTimeDuration;
            BuildSummary buildSummary;
            buffer.append(project.getName());
            buffer.append(' ');
            if (!isSingleVersion) {
                buffer.append(project.getVersion());
                buffer.append(' ');
            }
            if (buffer.length() <= this.maxProjectNameLength) {
                while (buffer.length() < this.maxProjectNameLength) {
                    buffer.append('.');
                }
                buffer.append(' ');
            }
            if ((buildSummary = result.getBuildSummary(project)) == null) {
                buffer.append(this.builder().warning((Object)"SKIPPED"));
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append(this.builder().success((Object)"SUCCESS"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append(this.builder().failure((Object)"FAILURE"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            }
            this.logger.info(buffer.toString());
            buffer.setLength(0);
        }
    }

    private void logResult(MavenSession session) {
        this.infoLine('-');
        MessageBuilder buffer = this.builder();
        if (session.getResult().hasExceptions()) {
            buffer.failure((Object)"BUILD FAILURE");
        } else {
            buffer.success((Object)"BUILD SUCCESS");
        }
        this.logger.info(buffer.toString());
    }

    private MessageBuilder builder() {
        return this.messageBuilderFactory.builder();
    }

    private void logStats(MavenSession session) {
        this.infoLine('-');
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().getDegreeOfConcurrency() > 1 ? " (Wall Clock)" : "";
        this.logger.info("Total time:  {}{}", (Object)CLIReportingUtils.formatDuration(time), (Object)wallClock);
        this.logger.info("Finished at: {}", (Object)CLIReportingUtils.formatTimestamp(finish));
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            this.infoLine('-');
            this.infoMain("Skipping " + event.getProject().getName());
            this.logger.info("This project has been banned from the build due to previous failures.");
            this.infoLine('-');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            MavenProject project = event.getProject();
            this.logger.info("");
            String projectKey = project.getGroupId() + ':' + project.getArtifactId();
            String preHeader = "--< ";
            String postHeader = " >--";
            int headerLen = "--< ".length() + projectKey.length() + " >--".length();
            String prefix = ExecutionEventLogger.chars('-', Math.max(0, (this.lineLength - headerLen) / 2)) + "--< ";
            String suffix = " >--" + ExecutionEventLogger.chars('-', Math.max(0, this.lineLength - headerLen - prefix.length() + "--< ".length()));
            this.logger.info(this.builder().strong((Object)prefix).project((Object)projectKey).strong((Object)suffix).toString());
            String building = "Building " + event.getProject().getName() + " " + event.getProject().getVersion();
            if (this.totalProjects <= 1) {
                this.infoMain(building);
            } else {
                int number;
                ExecutionEventLogger executionEventLogger = this;
                synchronized (executionEventLogger) {
                    number = ++this.currentVisitedProjectCount;
                }
                String progress = " [" + number + '/' + this.totalProjects + ']';
                int pad = this.lineLength - building.length() - progress.length();
                this.infoMain(building + (pad > 0 ? ExecutionEventLogger.chars(' ', pad) : "") + progress);
            }
            File currentPom = project.getFile();
            if (currentPom != null) {
                MavenSession session = event.getSession();
                Path current = currentPom.toPath().toAbsolutePath().normalize();
                Path topDirectory = session.getTopDirectory();
                if (topDirectory != null && current.startsWith(topDirectory)) {
                    current = topDirectory.relativize(current);
                }
                this.logger.info("  from " + current);
            }
            prefix = ExecutionEventLogger.chars('-', Math.max(0, (this.lineLength - project.getPackaging().length() - 4) / 2));
            suffix = ExecutionEventLogger.chars('-', Math.max(0, this.lineLength - project.getPackaging().length() - 4 - prefix.length()));
            this.infoMain(prefix + "[ " + project.getPackaging() + " ]" + suffix);
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Goal '{}' requires online mode for execution but Maven is currently offline, skipping", (Object)event.getMojoExecution().getGoal());
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = this.builder().strong((Object)"--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" ---");
            this.logger.info(buffer.toString());
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = this.builder().strong((Object)">>> ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong((Object)" > ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" >>>");
            this.logger.info(buffer.toString());
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = this.builder().strong((Object)"<<< ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong((Object)" < ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" <<<");
            this.logger.info(buffer.toString());
            this.logger.info("");
        }
    }

    private void append(MessageBuilder buffer, MojoExecution me) {
        String prefix = me.getMojoDescriptor().getPluginDescriptor().getGoalPrefix();
        if (prefix == null || prefix.isEmpty()) {
            prefix = me.getGroupId() + ":" + me.getArtifactId();
        }
        buffer.mojo((Object)(prefix + ':' + me.getVersion() + ':' + me.getGoal()));
        if (me.getExecutionId() != null) {
            buffer.a((Object)Character.valueOf(' ')).strong((Object)('(' + me.getExecutionId() + ')'));
        }
    }

    private void appendForkInfo(MessageBuilder buffer, MojoDescriptor md) {
        StringBuilder buff = new StringBuilder();
        if (md.getExecutePhase() != null && !md.getExecutePhase().isEmpty()) {
            if (md.getExecuteLifecycle() != null && !md.getExecuteLifecycle().isEmpty()) {
                buff.append('[');
                buff.append(md.getExecuteLifecycle());
                buff.append(']');
            }
            buff.append(md.getExecutePhase());
        } else {
            buff.append(':');
            buff.append(md.getExecuteGoal());
        }
        buffer.strong((Object)buff.toString());
    }

    private void append(MessageBuilder buffer, MavenProject project) {
        buffer.a((CharSequence)" @ ").project((Object)project.getArtifactId());
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info("");
            this.infoLine('>');
            this.infoMain("Forking " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.infoLine('>');
        }
    }
}

