/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    private Map<TransferResource, Long> transfers = new LinkedHashMap<TransferResource, Long>();
    private AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
    private StringBuilder buffer = new StringBuilder(128);
    private boolean printResourceNames;
    private int lastLength;

    public ConsoleMavenTransferListener(PrintStream out, boolean printResourceNames) {
        super(out);
        this.printResourceNames = printResourceNames;
    }

    @Override
    public synchronized void transferInitiated(TransferEvent event) {
        this.overridePreviousTransfer(event);
        super.transferInitiated(event);
    }

    @Override
    public synchronized void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.overridePreviousTransfer(event);
        super.transferCorrupted(event);
    }

    public synchronized void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.transfers.put(resource, event.getTransferredBytes());
        this.buffer.append("Progress (").append(this.transfers.size()).append("): ");
        Iterator<Map.Entry<TransferResource, Long>> entries = this.transfers.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<TransferResource, Long> entry = entries.next();
            long total = entry.getKey().getContentLength();
            Long complete = entry.getValue();
            String resourceName = entry.getKey().getResourceName();
            if (this.printResourceNames) {
                int idx = resourceName.lastIndexOf(47);
                if (idx < 0) {
                    this.buffer.append(resourceName);
                } else {
                    this.buffer.append(resourceName, idx + 1, resourceName.length());
                }
                this.buffer.append(" (");
            }
            this.buffer.append(this.format.formatProgress(complete, total));
            if (this.printResourceNames) {
                this.buffer.append(")");
            }
            if (!entries.hasNext()) continue;
            this.buffer.append(" | ");
        }
        int pad = this.lastLength - this.buffer.length();
        this.lastLength = this.buffer.length();
        this.pad(this.buffer, pad);
        this.buffer.append('\r');
        this.out.print(this.buffer);
        this.out.flush();
        this.buffer.setLength(0);
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    @Override
    public synchronized void transferSucceeded(TransferEvent event) {
        this.transfers.remove(event.getResource());
        this.overridePreviousTransfer(event);
        super.transferSucceeded(event);
    }

    public synchronized void transferFailed(TransferEvent event) {
        this.transfers.remove(event.getResource());
        this.overridePreviousTransfer(event);
        super.transferFailed(event);
    }

    private void overridePreviousTransfer(TransferEvent event) {
        if (this.lastLength > 0) {
            this.pad(this.buffer, this.lastLength);
            this.buffer.append('\r');
            this.out.print(this.buffer);
            this.out.flush();
            this.lastLength = 0;
            this.buffer.setLength(0);
        }
    }
}

