/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * Represents a set of reports and configuration to be used to
 * generate them.
 * 
 * @version $Revision$ $Date$
 */
public class ReportSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id = "default";

    /**
     * Field configuration
     */
    private Object configuration;

    /**
     * Field inherited
     */
    private String inherited;

    /**
     * Field reports
     */
    private java.util.List reports;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReport
     * 
     * @param string
     */
    public void addReport(String string)
    {
        getReports().add( string );
    } //-- void addReport(String) 

    /**
     * Get Configuration of the report to be used when generating
     * this set.
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get The unique id for this report set, to be used during POM
     * inheritance.
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             Whether any configuration should be propagated
     * to child POMs.
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited() 

    /**
     * Method getReports
     */
    public java.util.List getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList();
        }
        
        return this.reports;
    } //-- java.util.List getReports() 

    /**
     * Method removeReport
     * 
     * @param string
     */
    public void removeReport(String string)
    {
        getReports().remove( string );
    } //-- void removeReport(String) 

    /**
     * Set Configuration of the report to be used when generating
     * this set.
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Set The unique id for this report set, to be used during POM
     * inheritance.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             Whether any configuration should be propagated
     * to child POMs.
     * 
     * @param inherited
     */
    public void setInherited(String inherited)
    {
        this.inherited = inherited;
    } //-- void setInherited(String) 

    /**
     * Set 
     *             The list of reports from this plugin which
     * should be generated from this set.
     *           
     * 
     * @param reports
     */
    public void setReports(java.util.List reports)
    {
        this.reports = reports;
    } //-- void setReports(java.util.List) 


    private boolean inheritanceApplied = true;
    
    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }
    
    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
