/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;

/**
 * Class Extension.
 * 
 * @version $Revision$ $Date$
 */
public class Extension implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }

        if ( !( o instanceof Extension ) )
        {
            return false;
        }

        Extension e = (Extension) o;

        if ( !e.getArtifactId().equals( getArtifactId() ) )
        {
            return false;
        }
        else if ( !e.getGroupId().equals( getGroupId() ) )
        {
            return false;
        }
        else if ( e.getVersion() != null ? !e.getVersion().equals( getVersion() ) : getVersion() != null )
        {
            return false;
        }
        return true;
    }

    public int hashCode()
    {
        int result = 17;
        result = 37 * result + getArtifactId().hashCode();
        result = 37 * result + getGroupId().hashCode();
        result = 37 * result + getVersion() != null ? getVersion().hashCode() : 0;
        return result;
    }
          }
