/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;
import java.util.Properties;

/**
 * Class ModelBase.
 * 
 * @version $Revision$ $Date$
 */
public class ModelBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field modules
     */
    private java.util.List modules;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * This may be removed or relocated in the near future. It is
     * undecided whether plugins really need a
     *             remote repository set of their own.
     */
    private java.util.List pluginRepositories;

    /**
     * These should ultimately only be compile time dependencies
     * when transitive dependencies come into
     *             play.
     */
    private java.util.List dependencies;

    /**
     * Field reports
     */
    private Object reports;

    /**
     * Field reporting
     */
    private Reporting reporting;

    /**
     * Field dependencyManagement
     */
    private DependencyManagement dependencyManagement;

    /**
     * Field distributionManagement
     */
    private DistributionManagement distributionManagement;

    /**
     * Field properties
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method addModule
     * 
     * @param string
     */
    public void addModule(String string)
    {
        getModules().add( string );
    } //-- void addModule(String) 

    /**
     * Method addPluginRepository
     * 
     * @param repository
     */
    public void addPluginRepository(Repository repository)
    {
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository(Repository) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method getDependencyManagement
     */
    public DependencyManagement getDependencyManagement()
    {
        return this.dependencyManagement;
    } //-- DependencyManagement getDependencyManagement() 

    /**
     * Method getDistributionManagement
     */
    public DistributionManagement getDistributionManagement()
    {
        return this.distributionManagement;
    } //-- DistributionManagement getDistributionManagement() 

    /**
     * Method getModules
     */
    public java.util.List getModules()
    {
        if ( this.modules == null )
        {
            this.modules = new java.util.ArrayList();
        }
        
        return this.modules;
    } //-- java.util.List getModules() 

    /**
     * Method getPluginRepositories
     */
    public java.util.List getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList();
        }
        
        return this.pluginRepositories;
    } //-- java.util.List getPluginRepositories() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Method getReporting
     */
    public Reporting getReporting()
    {
        return this.reporting;
    } //-- Reporting getReporting() 

    /**
     * Method getReports
     */
    public Object getReports()
    {
        return this.reports;
    } //-- Object getReports() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Method removeModule
     * 
     * @param string
     */
    public void removeModule(String string)
    {
        getModules().remove( string );
    } //-- void removeModule(String) 

    /**
     * Method removePluginRepository
     * 
     * @param repository
     */
    public void removePluginRepository(Repository repository)
    {
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository(Repository) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Method setDependencies
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Method setDependencyManagement
     * 
     * @param dependencyManagement
     */
    public void setDependencyManagement(DependencyManagement dependencyManagement)
    {
        this.dependencyManagement = dependencyManagement;
    } //-- void setDependencyManagement(DependencyManagement) 

    /**
     * Method setDistributionManagement
     * 
     * @param distributionManagement
     */
    public void setDistributionManagement(DistributionManagement distributionManagement)
    {
        this.distributionManagement = distributionManagement;
    } //-- void setDistributionManagement(DistributionManagement) 

    /**
     * Method setModules
     * 
     * @param modules
     */
    public void setModules(java.util.List modules)
    {
        this.modules = modules;
    } //-- void setModules(java.util.List) 

    /**
     * Method setPluginRepositories
     * 
     * @param pluginRepositories
     */
    public void setPluginRepositories(java.util.List pluginRepositories)
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories(java.util.List) 

    /**
     * Method setProperties
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Method setReporting
     * 
     * @param reporting
     */
    public void setReporting(Reporting reporting)
    {
        this.reporting = reporting;
    } //-- void setReporting(Reporting) 

    /**
     * Method setReports
     * 
     * @param reports
     */
    public void setReports(Object reports)
    {
        this.reports = reports;
    } //-- void setReports(Object) 

    /**
     * Method setRepositories
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 

}
