/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.validation;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.StringUtils;

public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    public ModelValidationResult validate(Model model) {
        Reporting reporting;
        Build build;
        Parent parent;
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, model.getModelVersion());
        this.validateId("groupId", result, model.getGroupId());
        this.validateId("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, model.getPackaging());
        if (!model.getModules().isEmpty() && !"pom".equals(model.getPackaging())) {
            result.addMessage("Packaging '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
        }
        if ((parent = model.getParent()) != null && parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
            result.addMessage("The parent element cannot have the same ID as the project.");
        }
        this.validateStringNotEmpty("version", result, model.getVersion());
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            this.validateId("dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateId("dependencies.dependency.groupId", result, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", result, d.getType(), this.dependencySourceHint(d));
            this.validateStringNotEmpty("dependencies.dependency.version", result, d.getVersion(), this.dependencySourceHint(d));
            if ("system".equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty((String)systemPath)) {
                    result.addMessage("For dependency " + d + ": system-scoped dependency must specify systemPath.");
                    continue;
                }
                if (new File(systemPath).isAbsolute()) continue;
                result.addMessage("For dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                continue;
            }
            if (!StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
            result.addMessage("For dependency " + d + ": only dependency with system scope can specify systemPath.");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            Iterator it2 = mgmt.getDependencies().iterator();
            while (it2.hasNext()) {
                Dependency d = (Dependency)it2.next();
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", result, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", result, d.getGroupId());
                if ("system".equals(d.getScope())) {
                    String systemPath = d.getSystemPath();
                    if (StringUtils.isEmpty((String)systemPath)) {
                        result.addMessage("For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                        continue;
                    }
                    if (new File(systemPath).isAbsolute()) continue;
                    result.addMessage("For managed dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
                result.addMessage("For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
        }
        if ((build = model.getBuild()) != null) {
            Resource r;
            Iterator it3 = build.getPlugins().iterator();
            while (it3.hasNext()) {
                Plugin p = (Plugin)it3.next();
                this.validateStringNotEmpty("build.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("build.plugins.plugin.groupId", result, p.getGroupId());
            }
            it3 = build.getResources().iterator();
            while (it3.hasNext()) {
                r = (Resource)it3.next();
                this.validateStringNotEmpty("build.resources.resource.directory", result, r.getDirectory());
            }
            it3 = build.getTestResources().iterator();
            while (it3.hasNext()) {
                r = (Resource)it3.next();
                this.validateStringNotEmpty("build.testResources.testResource.directory", result, r.getDirectory());
            }
        }
        if ((reporting = model.getReporting()) != null) {
            Iterator it4 = reporting.getPlugins().iterator();
            while (it4.hasNext()) {
                ReportPlugin p = (ReportPlugin)it4.next();
                this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("reporting.plugins.plugin.groupId", result, p.getGroupId());
            }
        }
        this.validateRepositories(result, model.getRepositories(), "repositories.repository");
        this.validateRepositories(result, model.getPluginRepositories(), "pluginRepositories.pluginRepository");
        this.forcePluginExecutionIdCollision(model, result);
        return result;
    }

    private boolean validateId(String fieldName, ModelValidationResult result, String id) {
        if (!this.validateStringNotEmpty(fieldName, result, id)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            result.addMessage("'" + fieldName + "' with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateRepositories(ModelValidationResult result, List repositories, String prefix) {
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            Repository repository = (Repository)it.next();
            this.validateStringNotEmpty(prefix + ".id", result, repository.getId());
            this.validateStringNotEmpty(prefix + ".url", result, repository.getUrl());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelValidationResult result) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    result.addMessage(collisionException.getMessage());
                }
            }
        }
    }

    private String dependencySourceHint(Dependency d) {
        return d.getGroupId() + ":" + d.getArtifactId();
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string) {
        return this.validateStringNotEmpty(fieldName, result, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, result, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelValidationResult result, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }
}

