/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DefaultProfileManager
implements ProfileManager {
    private MutablePlexusContainer container;
    private Map profilesById = new LinkedHashMap();
    private ProfileActivationContext profileActivationContext;

    public DefaultProfileManager(PlexusContainer container, ProfileActivationContext profileActivationContext) {
        this.container = (MutablePlexusContainer)container;
        this.profileActivationContext = profileActivationContext == null ? this.createDefaultActivationContext() : profileActivationContext;
    }

    public DefaultProfileManager(PlexusContainer container) {
        this.container = (MutablePlexusContainer)container;
        this.profileActivationContext = this.createDefaultActivationContext();
    }

    private ProfileActivationContext createDefaultActivationContext() {
        return new DefaultProfileActivationContext(System.getProperties(), false);
    }

    public ProfileActivationContext getProfileActivationContext() {
        return this.profileActivationContext;
    }

    public void setProfileActivationContext(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext;
    }

    public Map getProfilesById() {
        return this.profilesById;
    }

    public void addProfile(Profile profile) {
        String profileId = profile.getId();
        Profile existing = (Profile)this.profilesById.get(profileId);
        if (existing != null) {
            this.container.getLogger().warn("Overriding profile: '" + profileId + "' (source: " + existing.getSource() + ") with new instance from source: " + profile.getSource());
        }
        this.profilesById.put(profile.getId(), profile);
        Activation activation = profile.getActivation();
        if (activation != null && activation.isActiveByDefault()) {
            this.activateAsDefault(profileId);
        }
    }

    public void explicitlyActivate(String profileId) {
        List activatedIds = this.profileActivationContext.getExplicitlyActiveProfileIds();
        if (!activatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly activated.");
            this.profileActivationContext.setActive(profileId);
        }
    }

    public void explicitlyActivate(List profileIds) {
        for (String profileId : profileIds) {
            this.explicitlyActivate(profileId);
        }
    }

    public void explicitlyDeactivate(String profileId) {
        List deactivatedIds = this.profileActivationContext.getExplicitlyInactiveProfileIds();
        if (!deactivatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly deactivated.");
            this.profileActivationContext.setInactive(profileId);
        }
    }

    public void explicitlyDeactivate(List profileIds) {
        for (String profileId : profileIds) {
            this.explicitlyDeactivate(profileId);
        }
    }

    public List getActiveProfiles() throws ProfileActivationException {
        return this.getActiveProfiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveProfiles(Model model) throws ProfileActivationException {
        ArrayList<Profile> activeFromPom = new ArrayList<Profile>();
        ArrayList<Profile> activeExternal = new ArrayList<Profile>();
        for (Map.Entry entry : this.profilesById.entrySet()) {
            String profileId = (String)entry.getKey();
            Profile profile = (Profile)entry.getValue();
            boolean shouldAdd = false;
            if (this.profileActivationContext.isExplicitlyActive(profileId)) {
                shouldAdd = true;
            } else if (this.isActive(profile, this.profileActivationContext)) {
                shouldAdd = true;
            }
            if (this.profileActivationContext.isExplicitlyInactive(profileId) || !shouldAdd) continue;
            if ("pom".equals(profile.getSource())) {
                activeFromPom.add(profile);
                continue;
            }
            activeExternal.add(profile);
        }
        if (activeFromPom.isEmpty()) {
            List defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
            List deactivatedIds = this.profileActivationContext.getExplicitlyInactiveProfileIds();
            for (String profileId : defaultIds) {
                Profile profile;
                if (deactivatedIds.contains(profileId) || (profile = (Profile)this.profilesById.get(profileId)) == null) continue;
                activeFromPom.add(profile);
            }
        }
        ArrayList<Profile> allActive = new ArrayList<Profile>(activeFromPom.size() + activeExternal.size());
        allActive.addAll(activeExternal);
        allActive.addAll(activeFromPom);
        ArrayList<Profile> arrayList = allActive;
        return arrayList;
    }

    private boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        List activators = null;
        try {
            activators = this.container.lookupList(ProfileActivator.class);
            for (ProfileActivator activator : activators) {
                if (!activator.canDetermineActivation(profile, context) || !activator.isActive(profile, context)) continue;
                this.container.getLogger().debug("Profile: " + profile.getId() + " is active. (source: " + profile.getSource() + ")");
                boolean bl = true;
                return bl;
            }
            boolean i$ = false;
            return i$;
        }
        catch (ComponentLookupException e) {
            throw new ProfileActivationException("Cannot retrieve list of profile activators.", e);
        }
        finally {
            this.container.getContext().put((Object)"SystemProperties", null);
            if (activators != null) {
                try {
                    this.container.releaseAll(activators);
                }
                catch (ComponentLifecycleException e) {
                    this.container.getLogger().debug("Error releasing profile activators - ignoring.", (Throwable)e);
                }
            }
        }
    }

    public void addProfiles(List profiles) {
        for (Profile profile : profiles) {
            this.addProfile(profile);
        }
    }

    public void activateAsDefault(String profileId) {
        List defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
        if (!defaultIds.contains(profileId)) {
            this.profileActivationContext.setActiveByDefault(profileId);
        }
    }

    public List getExplicitlyActivatedIds() {
        return this.profileActivationContext.getExplicitlyActiveProfileIds();
    }

    public List getExplicitlyDeactivatedIds() {
        return this.profileActivationContext.getExplicitlyInactiveProfileIds();
    }

    public List getIdsActivatedByDefault() {
        return this.profileActivationContext.getActiveByDefaultProfileIds();
    }

    private static String getVersion(Model model) {
        Parent parent = model.getParent();
        String version = model.getVersion();
        if (parent != null && version == null) {
            version = parent.getVersion();
        }
        return version;
    }

    public static String getGroupId(Model model) {
        Parent parent = model.getParent();
        String groupId = model.getGroupId();
        if (parent != null && groupId == null) {
            groupId = parent.getGroupId();
        }
        return groupId;
    }
}

