/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ProfileActivator.class, hint="system-property")
public class SystemPropertyProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile, ProfileActivationContext context) {
        return profile.getActivation() != null && profile.getActivation().getProperty() != null;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context) {
        Activation activation = profile.getActivation();
        ActivationProperty property = activation.getProperty();
        if (property != null) {
            String name = property.getName();
            boolean reverseName = false;
            if (name.startsWith("!")) {
                reverseName = true;
                name = name.substring(1);
            }
            Properties execProperties = context.getExecutionProperties();
            String sysValue = execProperties.getProperty(name);
            String propValue = property.getValue();
            if (StringUtils.isNotEmpty((String)propValue)) {
                boolean reverseValue = false;
                if (propValue.startsWith("!")) {
                    reverseValue = true;
                    propValue = propValue.substring(1);
                }
                boolean result = propValue.equals(sysValue);
                if (reverseValue) {
                    return !result;
                }
                return result;
            }
            boolean result = StringUtils.isNotEmpty((String)sysValue);
            if (reverseName) {
                return !result;
            }
            return result;
        }
        return false;
    }
}

