/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ActiveProjectArtifact;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.validation.ModelValidationResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactMetadataSource.class)
public class MavenMetadataSource
extends AbstractLogEnabled
implements ArtifactMetadataSource,
Contextualizable {
    public static final String ROLE_HINT = "default";
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;
    private MavenProject superProject;
    @Requirement
    private PlexusContainer container;
    private MavenProjectBuilder mavenProjectBuilder;
    private boolean strictlyEnforceThePresenceOfAValidMavenPOM = false;

    public Artifact retrieveRelocatedArtifact(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        if (artifact instanceof ActiveProjectArtifact) {
            return artifact;
        }
        ProjectRelocation rel = this.retrieveRelocatedProject(artifact, localRepository, remoteRepositories);
        if (rel == null) {
            return artifact;
        }
        MavenProject project = rel.project;
        if (project == null || this.getRelocationKey(artifact).equals(this.getRelocationKey(project.getArtifact()))) {
            return artifact;
        }
        Artifact result = null;
        result = artifact.getClassifier() != null ? this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier()) : this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType());
        result.setScope(artifact.getScope());
        result.setArtifactHandler(artifact.getArtifactHandler());
        result.setDependencyFilter(artifact.getDependencyFilter());
        result.setDependencyTrail(artifact.getDependencyTrail());
        result.setOptional(artifact.isOptional());
        result.setRelease(artifact.isRelease());
        return result;
    }

    private String getRelocationKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private ProjectRelocation retrieveRelocatedProject(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        if (remoteRepositories == null) {
            remoteRepositories = Collections.emptyList();
        }
        try {
            this.loadProjectBuilder();
        }
        catch (ComponentLookupException e) {
            throw new ArtifactMetadataRetrievalException("Cannot lookup MavenProjectBuilder component instance: " + e.getMessage(), (Throwable)e);
        }
        MavenProject project = null;
        boolean done = false;
        do {
            pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
            }
            catch (InvalidProjectModelException e) {
                this.handleInvalidOrMissingMavenPOM(artifact, e);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Reason: " + e.getMessage());
                    ModelValidationResult validationResult = e.getValidationResult();
                    if (validationResult != null) {
                        this.getLogger().debug("\nValidation Errors:");
                        Iterator i = validationResult.getMessages().iterator();
                        while (i.hasNext()) {
                            this.getLogger().debug(i.next().toString());
                        }
                        this.getLogger().debug("\n");
                    } else {
                        this.getLogger().debug("", (Throwable)e);
                    }
                }
                project = null;
            }
            catch (ProjectBuildingException e) {
                this.handleInvalidOrMissingMavenPOM(artifact, e);
                project = null;
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                        project.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                        project.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion((String)relocation.getVersion()));
                        project.setVersion(relocation.getVersion());
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    List available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        artifact.setAvailableVersions(this.retrieveAvailableVersions(artifact, localRepository, remoteRepositories));
                    }
                    String message = "\n  This artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage() + "\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.getLogger().warn("While downloading " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + message + "\n");
                        continue;
                    }
                    this.getLogger().debug("While downloading " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        ProjectRelocation res = new ProjectRelocation();
        res.project = project;
        res.pomArtifact = pomArtifact;
        return res;
    }

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ResolutionGroup result;
        ProjectRelocation res = this.retrieveRelocatedProject(artifact, localRepository, remoteRepositories);
        MavenProject project = res.project;
        Artifact pomArtifact = res.pomArtifact;
        if (artifact.getDownloadUrl() == null) {
            artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        }
        if (project == null) {
            result = new ResolutionGroup(pomArtifact, Collections.EMPTY_SET, Collections.EMPTY_LIST);
        } else {
            Set artifacts = Collections.EMPTY_SET;
            if (!artifact.getArtifactHandler().isIncludesDependencies()) {
                try {
                    artifacts = project.createArtifacts(this.artifactFactory, artifact.getScope(), artifact.getDependencyFilter());
                }
                catch (InvalidDependencyVersionException e) {
                    throw new ArtifactMetadataRetrievalException("Error in metadata for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
                }
            }
            List repositories = this.aggregateRepositoryLists(remoteRepositories, project.getRemoteArtifactRepositories());
            result = new ResolutionGroup(pomArtifact, artifacts, repositories);
        }
        return result;
    }

    private void handleInvalidOrMissingMavenPOM(Artifact artifact, ProjectBuildingException e) throws ArtifactMetadataRetrievalException {
        if (this.strictlyEnforceThePresenceOfAValidMavenPOM) {
            throw new ArtifactMetadataRetrievalException("Invalid POM file for artifact: '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e, artifact);
        }
        this.getLogger().debug("\n\tDEPRECATION: The POM for the artifact '" + artifact.getDependencyConflictId() + "' was invalid or not found on any repositories.\n" + "\tThis may not be supported by future versions of Maven and should be corrected as soon as possible.\n" + "\tError given: " + e.getMessage() + "\n");
    }

    private void loadProjectBuilder() throws ComponentLookupException {
        if (this.mavenProjectBuilder == null) {
            this.mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.class);
        }
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ArtifactMetadataRetrievalException {
        if (this.superProject == null) {
            try {
                this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject(new DefaultProjectBuilderConfiguration());
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to parse the Maven built-in model: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        for (ArtifactRepository superRepo : this.superProject.getRemoteArtifactRepositories()) {
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        if (remoteArtifactRepositories != null) {
            for (ArtifactRepository repository : remoteArtifactRepositories) {
                if (repositories.contains(repository)) continue;
                repositories.add(repository);
            }
        }
        return repositories;
    }

    public static Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, List<Dependency> dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> projectArtifacts = new LinkedHashSet<Artifact>(dependencies.size());
        for (Dependency d : dependencies) {
            VersionRange versionRange;
            String scope = d.getScope();
            if (StringUtils.isEmpty((String)scope)) {
                scope = Artifact.SCOPE_COMPILE;
                d.setScope(scope);
            }
            try {
                versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), scope, inheritedScope, d.isOptional());
            if (Artifact.SCOPE_SYSTEM.equals(scope)) {
                artifact.setFile(new File(d.getSystemPath()));
            }
            ArtifactFilter artifactFilter = dependencyFilter;
            if (artifact == null || artifactFilter != null && !artifactFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                for (Exclusion e : d.getExclusions()) {
                    exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (artifactFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(artifactFilter);
                    filter.add((ArtifactFilter)newFilter);
                    artifactFilter = filter;
                } else {
                    artifactFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(artifactFilter);
            if (project != null) {
                artifact = project.replaceWithActiveArtifact(artifact);
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    public List<ArtifactVersion> retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), (Throwable)e);
        }
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata());
    }

    public List<ArtifactVersion> retrieveAvailableVersionsFromDeploymentRepository(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolveAlways((RepositoryMetadata)metadata, localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), (Throwable)e);
        }
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata());
    }

    private List<ArtifactVersion> retrieveAvailableVersionsFromMetadata(Metadata repoMetadata) {
        List<ArtifactVersion> versions;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            List metadataVersions = repoMetadata.getVersioning().getVersions();
            versions = new ArrayList<ArtifactVersion>(metadataVersions.size());
            for (String version : metadataVersions) {
                versions.add((ArtifactVersion)new DefaultArtifactVersion(version));
            }
        } else {
            versions = Collections.emptyList();
        }
        return versions;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private static final class ProjectRelocation {
        private MavenProject project;
        private Artifact pomArtifact;

        private ProjectRelocation() {
        }
    }
}

