/*
 * $Id$
 */

package org.apache.maven.artifact.repository.metadata;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Versioning.
 * 
 * @version $Revision$ $Date$
 */
public class Versioning implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field latest
     */
    private String latest;

    /**
     * Field release
     */
    private String release;

    /**
     * Field snapshot
     */
    private Snapshot snapshot;

    /**
     * Field versions
     */
    private java.util.List versions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addVersion
     * 
     * @param string
     */
    public void addVersion(String string)
    {
        getVersions().add( string );
    } //-- void addVersion(String) 

    /**
     * Method getLatest
     */
    public String getLatest()
    {
        return this.latest;
    } //-- String getLatest() 

    /**
     * Method getRelease
     */
    public String getRelease()
    {
        return this.release;
    } //-- String getRelease() 

    /**
     * Method getSnapshot
     */
    public Snapshot getSnapshot()
    {
        return this.snapshot;
    } //-- Snapshot getSnapshot() 

    /**
     * Method getVersions
     */
    public java.util.List getVersions()
    {
        if ( this.versions == null )
        {
            this.versions = new java.util.ArrayList();
        }
        
        return this.versions;
    } //-- java.util.List getVersions() 

    /**
     * Method removeVersion
     * 
     * @param string
     */
    public void removeVersion(String string)
    {
        getVersions().remove( string );
    } //-- void removeVersion(String) 

    /**
     * Method setLatest
     * 
     * @param latest
     */
    public void setLatest(String latest)
    {
        this.latest = latest;
    } //-- void setLatest(String) 

    /**
     * Method setRelease
     * 
     * @param release
     */
    public void setRelease(String release)
    {
        this.release = release;
    } //-- void setRelease(String) 

    /**
     * Method setSnapshot
     * 
     * @param snapshot
     */
    public void setSnapshot(Snapshot snapshot)
    {
        this.snapshot = snapshot;
    } //-- void setSnapshot(Snapshot) 

    /**
     * Method setVersions
     * 
     * @param versions
     */
    public void setVersions(java.util.List versions)
    {
        this.versions = versions;
    } //-- void setVersions(java.util.List) 

}
