/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.v4;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.artifact.repository.metadata.v4.ImmutableCollections;
import org.apache.maven.artifact.repository.metadata.v4.Plugin;
import org.apache.maven.artifact.repository.metadata.v4.Versioning;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Metadata
implements Serializable {
    final String namespaceUri;
    final String modelEncoding;
    final String modelVersion;
    final String groupId;
    final String artifactId;
    final Versioning versioning;
    final String version;
    final List<Plugin> plugins;

    Metadata(String namespaceUri, String modelEncoding, String modelVersion, String groupId, String artifactId, Versioning versioning, String version, Collection<Plugin> plugins) {
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.modelVersion = modelVersion;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.versioning = versioning;
        this.version = version;
        this.plugins = ImmutableCollections.copy(plugins);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Nonnull
    public Builder with() {
        return Metadata.newBuilder(this);
    }

    @Nonnull
    public Metadata withModelVersion(String modelVersion) {
        return Metadata.newBuilder(this, true).modelVersion(modelVersion).build();
    }

    @Nonnull
    public Metadata withGroupId(String groupId) {
        return Metadata.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Metadata withArtifactId(String artifactId) {
        return Metadata.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Metadata withVersioning(Versioning versioning) {
        return Metadata.newBuilder(this, true).versioning(versioning).build();
    }

    @Nonnull
    public Metadata withVersion(String version) {
        return Metadata.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Metadata withPlugins(Collection<Plugin> plugins) {
        return Metadata.newBuilder(this, true).plugins(plugins).build();
    }

    @Nonnull
    public static Metadata newInstance() {
        return Metadata.newInstance(true);
    }

    @Nonnull
    public static Metadata newInstance(boolean withDefaults) {
        return Metadata.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Metadata.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Metadata from) {
        return Metadata.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Metadata from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Metadata base;
        String namespaceUri;
        String modelEncoding;
        String modelVersion;
        String groupId;
        String artifactId;
        Versioning versioning;
        String version;
        Collection<Plugin> plugins;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Metadata base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.modelVersion = base.modelVersion;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.versioning = base.versioning;
                this.version = base.version;
                this.plugins = base.plugins;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder versioning(Versioning versioning) {
            this.versioning = versioning;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Metadata build() {
            if (!(this.base == null || this.modelVersion != null && this.modelVersion != this.base.modelVersion || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.versioning != null && this.versioning != this.base.versioning || this.version != null && this.version != this.base.version || this.plugins != null && this.plugins != this.base.plugins)) {
                return this.base;
            }
            return new Metadata(this.namespaceUri != null ? this.namespaceUri : (this.base != null ? this.base.namespaceUri : ""), this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.modelVersion != null ? this.modelVersion : (this.base != null ? this.base.modelVersion : null), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.versioning != null ? this.versioning : (this.base != null ? this.base.versioning : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null));
        }
    }
}

