/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.repository.metadata.io.MetadataStaxReader;
import org.apache.maven.artifact.repository.metadata.io.MetadataStaxWriter;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    protected org.apache.maven.artifact.repository.metadata.Metadata metadata;
    private final File file;
    protected final Date timestamp;
    private boolean merged;

    protected MavenMetadata(org.apache.maven.artifact.repository.metadata.Metadata metadata, File file, Date timestamp) {
        this.metadata = metadata;
        this.file = file;
        this.timestamp = timestamp;
    }

    public String getType() {
        return MAVEN_METADATA_XML;
    }

    public File getFile() {
        return this.file;
    }

    public void merge(File existing, File result) throws RepositoryException {
        org.apache.maven.artifact.repository.metadata.Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(org.apache.maven.artifact.repository.metadata.Metadata var1);

    static org.apache.maven.artifact.repository.metadata.Metadata read(File metadataFile) throws RepositoryException {
        org.apache.maven.artifact.repository.metadata.Metadata metadata;
        block9: {
            if (metadataFile.length() <= 0L) {
                return new org.apache.maven.artifact.repository.metadata.Metadata();
            }
            InputStream input = Files.newInputStream(metadataFile.toPath(), new OpenOption[0]);
            try {
                metadata = new org.apache.maven.artifact.repository.metadata.Metadata(new MetadataStaxReader().read(input, false));
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
                }
            }
            input.close();
        }
        return metadata;
    }

    private void write(File metadataFile, org.apache.maven.artifact.repository.metadata.Metadata metadata) throws RepositoryException {
        metadataFile.getParentFile().mkdirs();
        try (OutputStream output = Files.newOutputStream(metadataFile.toPath(), new OpenOption[0]);){
            new MetadataStaxWriter().write(output, metadata.getDelegate());
        }
        catch (IOException | XMLStreamException e) {
            throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

