/*
 * $Id$
 */

package org.apache.maven.settings.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.*;
import org.codehaus.plexus.util.xml.pull.*;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class SettingsXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class SettingsXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param settings
     */
    public void write(Writer writer, Settings settings)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        writeSettings( settings, "settings", serializer );
    } //-- void write(Writer, Settings) 

    /**
     * Method writeActivation
     * 
     * @param activation
     * @param serializer
     * @param tagName
     */
    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activation != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activation.isActiveByDefault() != false )
            {
                serializer.startTag( NAMESPACE, "activeByDefault" ).text( String.valueOf( activation.isActiveByDefault() ) ).endTag( NAMESPACE, "activeByDefault" );
            }
            if ( activation.getJdk() != null )
            {
                serializer.startTag( NAMESPACE, "jdk" ).text( activation.getJdk() ).endTag( NAMESPACE, "jdk" );
            }
            if ( activation.getOs() != null )
            {
                writeActivationOS( activation.getOs(), "os", serializer );
            }
            if ( activation.getProperty() != null )
            {
                writeActivationProperty( activation.getProperty(), "property", serializer );
            }
            if ( activation.getFile() != null )
            {
                writeActivationFile( activation.getFile(), "file", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivation(Activation, String, XmlSerializer) 

    /**
     * Method writeActivationFile
     * 
     * @param activationFile
     * @param serializer
     * @param tagName
     */
    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activationFile != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activationFile.getMissing() != null )
            {
                serializer.startTag( NAMESPACE, "missing" ).text( activationFile.getMissing() ).endTag( NAMESPACE, "missing" );
            }
            if ( activationFile.getExists() != null )
            {
                serializer.startTag( NAMESPACE, "exists" ).text( activationFile.getExists() ).endTag( NAMESPACE, "exists" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivationFile(ActivationFile, String, XmlSerializer) 

    /**
     * Method writeActivationOS
     * 
     * @param activationOS
     * @param serializer
     * @param tagName
     */
    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activationOS != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activationOS.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( activationOS.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( activationOS.getFamily() != null )
            {
                serializer.startTag( NAMESPACE, "family" ).text( activationOS.getFamily() ).endTag( NAMESPACE, "family" );
            }
            if ( activationOS.getArch() != null )
            {
                serializer.startTag( NAMESPACE, "arch" ).text( activationOS.getArch() ).endTag( NAMESPACE, "arch" );
            }
            if ( activationOS.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( activationOS.getVersion() ).endTag( NAMESPACE, "version" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivationOS(ActivationOS, String, XmlSerializer) 

    /**
     * Method writeActivationProperty
     * 
     * @param activationProperty
     * @param serializer
     * @param tagName
     */
    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activationProperty != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activationProperty.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( activationProperty.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( activationProperty.getValue() != null )
            {
                serializer.startTag( NAMESPACE, "value" ).text( activationProperty.getValue() ).endTag( NAMESPACE, "value" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivationProperty(ActivationProperty, String, XmlSerializer) 

    /**
     * Method writeIdentifiableBase
     * 
     * @param identifiableBase
     * @param serializer
     * @param tagName
     */
    private void writeIdentifiableBase(IdentifiableBase identifiableBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( identifiableBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( identifiableBase.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( identifiableBase.getId() ).endTag( NAMESPACE, "id" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeIdentifiableBase(IdentifiableBase, String, XmlSerializer) 

    /**
     * Method writeMirror
     * 
     * @param mirror
     * @param serializer
     * @param tagName
     */
    private void writeMirror(Mirror mirror, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( mirror != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( mirror.getMirrorOf() != null )
            {
                serializer.startTag( NAMESPACE, "mirrorOf" ).text( mirror.getMirrorOf() ).endTag( NAMESPACE, "mirrorOf" );
            }
            if ( mirror.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( mirror.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( mirror.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( mirror.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( mirror.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( mirror.getId() ).endTag( NAMESPACE, "id" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeMirror(Mirror, String, XmlSerializer) 

    /**
     * Method writeProfile
     * 
     * @param profile
     * @param serializer
     * @param tagName
     */
    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( profile != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( profile.getActivation() != null )
            {
                writeActivation( profile.getActivation(), "activation", serializer );
            }
            if ( profile.getProperties() != null && profile.getProperties().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "properties" );
                for ( Iterator iter = profile.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) profile.getProperties().get( key );
                    serializer.startTag( NAMESPACE, "" + key + "" ).text( value ).endTag( NAMESPACE, "" + key + "" );
                }
                serializer.endTag( NAMESPACE, "properties" );
            }
            if ( profile.getRepositories() != null && profile.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = profile.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "pluginRepositories" );
                for ( Iterator iter = profile.getPluginRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "pluginRepository", serializer );
                }
                serializer.endTag( NAMESPACE, "pluginRepositories" );
            }
            if ( profile.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( profile.getId() ).endTag( NAMESPACE, "id" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeProfile(Profile, String, XmlSerializer) 

    /**
     * Method writeProxy
     * 
     * @param proxy
     * @param serializer
     * @param tagName
     */
    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( proxy != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( proxy.isActive() != false )
            {
                serializer.startTag( NAMESPACE, "active" ).text( String.valueOf( proxy.isActive() ) ).endTag( NAMESPACE, "active" );
            }
            if ( proxy.getProtocol() != null && !proxy.getProtocol().equals( "http" ) )
            {
                serializer.startTag( NAMESPACE, "protocol" ).text( proxy.getProtocol() ).endTag( NAMESPACE, "protocol" );
            }
            if ( proxy.getUsername() != null )
            {
                serializer.startTag( NAMESPACE, "username" ).text( proxy.getUsername() ).endTag( NAMESPACE, "username" );
            }
            if ( proxy.getPassword() != null )
            {
                serializer.startTag( NAMESPACE, "password" ).text( proxy.getPassword() ).endTag( NAMESPACE, "password" );
            }
            if ( proxy.getPort() != 0 )
            {
                serializer.startTag( NAMESPACE, "port" ).text( String.valueOf( proxy.getPort() ) ).endTag( NAMESPACE, "port" );
            }
            if ( proxy.getHost() != null )
            {
                serializer.startTag( NAMESPACE, "host" ).text( proxy.getHost() ).endTag( NAMESPACE, "host" );
            }
            if ( proxy.getNonProxyHosts() != null )
            {
                serializer.startTag( NAMESPACE, "nonProxyHosts" ).text( proxy.getNonProxyHosts() ).endTag( NAMESPACE, "nonProxyHosts" );
            }
            if ( proxy.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( proxy.getId() ).endTag( NAMESPACE, "id" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeProxy(Proxy, String, XmlSerializer) 

    /**
     * Method writeRepository
     * 
     * @param repository
     * @param serializer
     * @param tagName
     */
    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repository != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repository.getReleases() != null )
            {
                writeRepositoryPolicy( repository.getReleases(), "releases", serializer );
            }
            if ( repository.getSnapshots() != null )
            {
                writeRepositoryPolicy( repository.getSnapshots(), "snapshots", serializer );
            }
            if ( repository.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( repository.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( repository.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( repository.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( repository.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( repository.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( repository.getLayout() != null && !repository.getLayout().equals( "default" ) )
            {
                serializer.startTag( NAMESPACE, "layout" ).text( repository.getLayout() ).endTag( NAMESPACE, "layout" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepository(Repository, String, XmlSerializer) 

    /**
     * Method writeRepositoryBase
     * 
     * @param repositoryBase
     * @param serializer
     * @param tagName
     */
    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repositoryBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repositoryBase.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( repositoryBase.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( repositoryBase.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( repositoryBase.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( repositoryBase.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( repositoryBase.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals( "default" ) )
            {
                serializer.startTag( NAMESPACE, "layout" ).text( repositoryBase.getLayout() ).endTag( NAMESPACE, "layout" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepositoryBase(RepositoryBase, String, XmlSerializer) 

    /**
     * Method writeRepositoryPolicy
     * 
     * @param repositoryPolicy
     * @param serializer
     * @param tagName
     */
    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repositoryPolicy != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repositoryPolicy.isEnabled() != true )
            {
                serializer.startTag( NAMESPACE, "enabled" ).text( String.valueOf( repositoryPolicy.isEnabled() ) ).endTag( NAMESPACE, "enabled" );
            }
            if ( repositoryPolicy.getUpdatePolicy() != null )
            {
                serializer.startTag( NAMESPACE, "updatePolicy" ).text( repositoryPolicy.getUpdatePolicy() ).endTag( NAMESPACE, "updatePolicy" );
            }
            if ( repositoryPolicy.getChecksumPolicy() != null )
            {
                serializer.startTag( NAMESPACE, "checksumPolicy" ).text( repositoryPolicy.getChecksumPolicy() ).endTag( NAMESPACE, "checksumPolicy" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepositoryPolicy(RepositoryPolicy, String, XmlSerializer) 

    /**
     * Method writeServer
     * 
     * @param server
     * @param serializer
     * @param tagName
     */
    private void writeServer(Server server, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( server != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( server.getUsername() != null )
            {
                serializer.startTag( NAMESPACE, "username" ).text( server.getUsername() ).endTag( NAMESPACE, "username" );
            }
            if ( server.getPassword() != null )
            {
                serializer.startTag( NAMESPACE, "password" ).text( server.getPassword() ).endTag( NAMESPACE, "password" );
            }
            if ( server.getPrivateKey() != null )
            {
                serializer.startTag( NAMESPACE, "privateKey" ).text( server.getPrivateKey() ).endTag( NAMESPACE, "privateKey" );
            }
            if ( server.getPassphrase() != null )
            {
                serializer.startTag( NAMESPACE, "passphrase" ).text( server.getPassphrase() ).endTag( NAMESPACE, "passphrase" );
            }
            if ( server.getFilePermissions() != null )
            {
                serializer.startTag( NAMESPACE, "filePermissions" ).text( server.getFilePermissions() ).endTag( NAMESPACE, "filePermissions" );
            }
            if ( server.getDirectoryPermissions() != null )
            {
                serializer.startTag( NAMESPACE, "directoryPermissions" ).text( server.getDirectoryPermissions() ).endTag( NAMESPACE, "directoryPermissions" );
            }
            if ( server.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( server.getId() ).endTag( NAMESPACE, "id" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeServer(Server, String, XmlSerializer) 

    /**
     * Method writeSettings
     * 
     * @param settings
     * @param serializer
     * @param tagName
     */
    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( settings != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( settings.getLocalRepository() != null )
            {
                serializer.startTag( NAMESPACE, "localRepository" ).text( settings.getLocalRepository() ).endTag( NAMESPACE, "localRepository" );
            }
            if ( settings.isInteractiveMode() != true )
            {
                serializer.startTag( NAMESPACE, "interactiveMode" ).text( String.valueOf( settings.isInteractiveMode() ) ).endTag( NAMESPACE, "interactiveMode" );
            }
            if ( settings.isUsePluginRegistry() != false )
            {
                serializer.startTag( NAMESPACE, "usePluginRegistry" ).text( String.valueOf( settings.isUsePluginRegistry() ) ).endTag( NAMESPACE, "usePluginRegistry" );
            }
            if ( settings.isOffline() != false )
            {
                serializer.startTag( NAMESPACE, "offline" ).text( String.valueOf( settings.isOffline() ) ).endTag( NAMESPACE, "offline" );
            }
            if ( settings.getProxies() != null && settings.getProxies().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "proxies" );
                for ( Iterator iter = settings.getProxies().iterator(); iter.hasNext(); )
                {
                    Proxy proxy = (Proxy) iter.next();
                    writeProxy( proxy, "proxy", serializer );
                }
                serializer.endTag( NAMESPACE, "proxies" );
            }
            if ( settings.getServers() != null && settings.getServers().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "servers" );
                for ( Iterator iter = settings.getServers().iterator(); iter.hasNext(); )
                {
                    Server server = (Server) iter.next();
                    writeServer( server, "server", serializer );
                }
                serializer.endTag( NAMESPACE, "servers" );
            }
            if ( settings.getMirrors() != null && settings.getMirrors().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "mirrors" );
                for ( Iterator iter = settings.getMirrors().iterator(); iter.hasNext(); )
                {
                    Mirror mirror = (Mirror) iter.next();
                    writeMirror( mirror, "mirror", serializer );
                }
                serializer.endTag( NAMESPACE, "mirrors" );
            }
            if ( settings.getProfiles() != null && settings.getProfiles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "profiles" );
                for ( Iterator iter = settings.getProfiles().iterator(); iter.hasNext(); )
                {
                    Profile profile = (Profile) iter.next();
                    writeProfile( profile, "profile", serializer );
                }
                serializer.endTag( NAMESPACE, "profiles" );
            }
            if ( settings.getActiveProfiles() != null && settings.getActiveProfiles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "activeProfiles" );
                for ( Iterator iter = settings.getActiveProfiles().iterator(); iter.hasNext(); )
                {
                    String activeProfile = (String) iter.next();
                    serializer.startTag( NAMESPACE, "activeProfile" ).text( activeProfile ).endTag( NAMESPACE, "activeProfile" );
                }
                serializer.endTag( NAMESPACE, "activeProfiles" );
            }
            if ( settings.getPluginGroups() != null && settings.getPluginGroups().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "pluginGroups" );
                for ( Iterator iter = settings.getPluginGroups().iterator(); iter.hasNext(); )
                {
                    String pluginGroup = (String) iter.next();
                    serializer.startTag( NAMESPACE, "pluginGroup" ).text( pluginGroup ).endTag( NAMESPACE, "pluginGroup" );
                }
                serializer.endTag( NAMESPACE, "pluginGroups" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSettings(Settings, String, XmlSerializer) 

    /**
     * Method writeTrackableBase
     * 
     * @param trackableBase
     * @param serializer
     * @param tagName
     */
    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( trackableBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeTrackableBase(TrackableBase, String, XmlSerializer) 

}
