/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         The <code>&lt;proxy&gt;</code> element contains
 * informations required to a proxy settings.
 *         
 * 
 * @version $Revision$ $Date$
 */
public class Proxy extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             Whether this proxy configuration is the active
     * one.
     *             
     *           
     */
    private boolean active = false;

    /**
     * 
     *             
     *             The proxy protocol.
     *             
     *           
     */
    private String protocol = "http";

    /**
     * 
     *             
     *             The proxy user.
     *             
     *           
     */
    private String username;

    /**
     * 
     *             
     *             The proxy password.
     *             
     *           
     */
    private String password;

    /**
     * 
     *             
     *             The proxy port.
     *             
     *           
     */
    private int port = 8080;

    /**
     * 
     *             
     *             The proxy host.
     *             
     *           
     */
    private String host;

    /**
     * 
     *             
     *             The list of non-proxied hosts (delimited by |).
     *             
     *           
     */
    private String nonProxyHosts;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             
     *             The proxy host.
     *             
     *           
     * 
     * @return String
     */
    public String getHost()
    {
        return this.host;
    } //-- String getHost() 

    /**
     * Get 
     *             
     *             The list of non-proxied hosts (delimited by |).
     *             
     *           
     * 
     * @return String
     */
    public String getNonProxyHosts()
    {
        return this.nonProxyHosts;
    } //-- String getNonProxyHosts() 

    /**
     * Get 
     *             
     *             The proxy password.
     *             
     *           
     * 
     * @return String
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Get 
     *             
     *             The proxy port.
     *             
     *           
     * 
     * @return int
     */
    public int getPort()
    {
        return this.port;
    } //-- int getPort() 

    /**
     * Get 
     *             
     *             The proxy protocol.
     *             
     *           
     * 
     * @return String
     */
    public String getProtocol()
    {
        return this.protocol;
    } //-- String getProtocol() 

    /**
     * Get 
     *             
     *             The proxy user.
     *             
     *           
     * 
     * @return String
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Get 
     *             
     *             Whether this proxy configuration is the active
     * one.
     *             
     *           
     * 
     * @return boolean
     */
    public boolean isActive()
    {
        return this.active;
    } //-- boolean isActive() 

    /**
     * Set 
     *             
     *             Whether this proxy configuration is the active
     * one.
     *             
     *           
     * 
     * @param active
     */
    public void setActive( boolean active )
    {
        this.active = active;
    } //-- void setActive( boolean ) 

    /**
     * Set 
     *             
     *             The proxy host.
     *             
     *           
     * 
     * @param host
     */
    public void setHost( String host )
    {
        this.host = host;
    } //-- void setHost( String ) 

    /**
     * Set 
     *             
     *             The list of non-proxied hosts (delimited by |).
     *             
     *           
     * 
     * @param nonProxyHosts
     */
    public void setNonProxyHosts( String nonProxyHosts )
    {
        this.nonProxyHosts = nonProxyHosts;
    } //-- void setNonProxyHosts( String ) 

    /**
     * Set 
     *             
     *             The proxy password.
     *             
     *           
     * 
     * @param password
     */
    public void setPassword( String password )
    {
        this.password = password;
    } //-- void setPassword( String ) 

    /**
     * Set 
     *             
     *             The proxy port.
     *             
     *           
     * 
     * @param port
     */
    public void setPort( int port )
    {
        this.port = port;
    } //-- void setPort( int ) 

    /**
     * Set 
     *             
     *             The proxy protocol.
     *             
     *           
     * 
     * @param protocol
     */
    public void setProtocol( String protocol )
    {
        this.protocol = protocol;
    } //-- void setProtocol( String ) 

    /**
     * Set 
     *             
     *             The proxy user.
     *             
     *           
     * 
     * @param username
     */
    public void setUsername( String username )
    {
        this.username = username;
    } //-- void setUsername( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
