/*
 * $Id$
 */

package org.apache.maven.settings;

/**
 * Download policy
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryPolicy implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field enabled
     */
    private boolean enabled = true;

    /**
     * Field updatePolicy
     */
    private String updatePolicy;

    /**
     * Field checksumPolicy
     */
    private String checksumPolicy;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get What to do when verification of an artifact checksum
     * fails - warn, fail, etc. Valid values are
     *             "fail" or "warn"
     */
    public String getChecksumPolicy()
    {
        return this.checksumPolicy;
    } //-- String getChecksumPolicy() 

    /**
     * Get 
     *             The frequency for downloading updates - can be
     * "always", "daily" (default), "interval:XXX" (in minutes) or
     *             "never" (only if it doesn't exist locally).
     *           
     */
    public String getUpdatePolicy()
    {
        return this.updatePolicy;
    } //-- String getUpdatePolicy() 

    /**
     * Get Whether to use this repository for downloading this type
     * of artifact
     */
    public boolean isEnabled()
    {
        return this.enabled;
    } //-- boolean isEnabled() 

    /**
     * Set What to do when verification of an artifact checksum
     * fails - warn, fail, etc. Valid values are
     *             "fail" or "warn"
     * 
     * @param checksumPolicy
     */
    public void setChecksumPolicy(String checksumPolicy)
    {
        this.checksumPolicy = checksumPolicy;
    } //-- void setChecksumPolicy(String) 

    /**
     * Set Whether to use this repository for downloading this type
     * of artifact
     * 
     * @param enabled
     */
    public void setEnabled(boolean enabled)
    {
        this.enabled = enabled;
    } //-- void setEnabled(boolean) 

    /**
     * Set 
     *             The frequency for downloading updates - can be
     * "always", "daily" (default), "interval:XXX" (in minutes) or
     *             "never" (only if it doesn't exist locally).
     *           
     * 
     * @param updatePolicy
     */
    public void setUpdatePolicy(String updatePolicy)
    {
        this.updatePolicy = updatePolicy;
    } //-- void setUpdatePolicy(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
