/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A download mirror for a given repository.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Mirror extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field mirrorOf
     */
    private String mirrorOf;

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The server ID of the repository being mirrored,
     * eg
     *             "central". This MUST NOT match the mirror id.
     *           
     */
    public String getMirrorOf()
    {
        return this.mirrorOf;
    } //-- String getMirrorOf() 

    /**
     * Get 
     *             The optional name that describes the mirror.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The URL of the mirror repository.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *             The server ID of the repository being mirrored,
     * eg
     *             "central". This MUST NOT match the mirror id.
     *           
     * 
     * @param mirrorOf
     */
    public void setMirrorOf(String mirrorOf)
    {
        this.mirrorOf = mirrorOf;
    } //-- void setMirrorOf(String) 

    /**
     * Set 
     *             The optional name that describes the mirror.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The URL of the mirror repository.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
