/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Root element of the user configuration file.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Settings extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field localRepository
     */
    private String localRepository;

    /**
     * Field interactiveMode
     */
    private boolean interactiveMode = true;

    /**
     * Field usePluginRegistry
     */
    private boolean usePluginRegistry = false;

    /**
     * Field offline
     */
    private boolean offline = false;

    /**
     * Field proxies
     */
    private java.util.List proxies;

    /**
     * Field servers
     */
    private java.util.List servers;

    /**
     * Field mirrors
     */
    private java.util.List mirrors;

    /**
     * Field profiles
     */
    private java.util.List profiles;

    /**
     * Field activeProfiles
     */
    private java.util.List activeProfiles;

    /**
     * Field pluginGroups
     */
    private java.util.List pluginGroups;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addActiveProfile
     * 
     * @param string
     */
    public void addActiveProfile(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Settings.addActiveProfiles(string) parameter must be instanceof " + String.class.getName() );
        }
        getActiveProfiles().add( string );
    } //-- void addActiveProfile(String) 

    /**
     * Method addMirror
     * 
     * @param mirror
     */
    public void addMirror(Mirror mirror)
    {
        if ( !(mirror instanceof Mirror) )
        {
            throw new ClassCastException( "Settings.addMirrors(mirror) parameter must be instanceof " + Mirror.class.getName() );
        }
        getMirrors().add( mirror );
    } //-- void addMirror(Mirror) 

    /**
     * Method addPluginGroup
     * 
     * @param string
     */
    public void addPluginGroup(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Settings.addPluginGroups(string) parameter must be instanceof " + String.class.getName() );
        }
        getPluginGroups().add( string );
    } //-- void addPluginGroup(String) 

    /**
     * Method addProfile
     * 
     * @param profile
     */
    public void addProfile(Profile profile)
    {
        if ( !(profile instanceof Profile) )
        {
            throw new ClassCastException( "Settings.addProfiles(profile) parameter must be instanceof " + Profile.class.getName() );
        }
        getProfiles().add( profile );
    } //-- void addProfile(Profile) 

    /**
     * Method addProxy
     * 
     * @param proxy
     */
    public void addProxy(Proxy proxy)
    {
        if ( !(proxy instanceof Proxy) )
        {
            throw new ClassCastException( "Settings.addProxies(proxy) parameter must be instanceof " + Proxy.class.getName() );
        }
        getProxies().add( proxy );
    } //-- void addProxy(Proxy) 

    /**
     * Method addServer
     * 
     * @param server
     */
    public void addServer(Server server)
    {
        if ( !(server instanceof Server) )
        {
            throw new ClassCastException( "Settings.addServers(server) parameter must be instanceof " + Server.class.getName() );
        }
        getServers().add( server );
    } //-- void addServer(Server) 

    /**
     * Method getActiveProfiles
     */
    public java.util.List getActiveProfiles()
    {
        if ( this.activeProfiles == null )
        {
            this.activeProfiles = new java.util.ArrayList();
        }
        
        return this.activeProfiles;
    } //-- java.util.List getActiveProfiles() 

    /**
     * Get 
     *             
     *             The local repository.
     *             
     *           
     */
    public String getLocalRepository()
    {
        return this.localRepository;
    } //-- String getLocalRepository() 

    /**
     * Method getMirrors
     */
    public java.util.List getMirrors()
    {
        if ( this.mirrors == null )
        {
            this.mirrors = new java.util.ArrayList();
        }
        
        return this.mirrors;
    } //-- java.util.List getMirrors() 

    /**
     * Method getPluginGroups
     */
    public java.util.List getPluginGroups()
    {
        if ( this.pluginGroups == null )
        {
            this.pluginGroups = new java.util.ArrayList();
        }
        
        return this.pluginGroups;
    } //-- java.util.List getPluginGroups() 

    /**
     * Method getProfiles
     */
    public java.util.List getProfiles()
    {
        if ( this.profiles == null )
        {
            this.profiles = new java.util.ArrayList();
        }
        
        return this.profiles;
    } //-- java.util.List getProfiles() 

    /**
     * Method getProxies
     */
    public java.util.List getProxies()
    {
        if ( this.proxies == null )
        {
            this.proxies = new java.util.ArrayList();
        }
        
        return this.proxies;
    } //-- java.util.List getProxies() 

    /**
     * Method getServers
     */
    public java.util.List getServers()
    {
        if ( this.servers == null )
        {
            this.servers = new java.util.ArrayList();
        }
        
        return this.servers;
    } //-- java.util.List getServers() 

    /**
     * Get 
     *             
     *             Whether Maven should attempt to interact with
     * the user for input.
     *             
     *           
     */
    public boolean isInteractiveMode()
    {
        return this.interactiveMode;
    } //-- boolean isInteractiveMode() 

    /**
     * Get 
     *             
     *             Indicate whether maven should operate in offline
     * mode full-time.
     *             
     *           
     */
    public boolean isOffline()
    {
        return this.offline;
    } //-- boolean isOffline() 

    /**
     * Get 
     *             
     *             Whether Maven should use the plugin-registry.xml
     * file to manage plugin versions.
     *             
     *           
     */
    public boolean isUsePluginRegistry()
    {
        return this.usePluginRegistry;
    } //-- boolean isUsePluginRegistry() 

    /**
     * Method removeActiveProfile
     * 
     * @param string
     */
    public void removeActiveProfile(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Settings.removeActiveProfiles(string) parameter must be instanceof " + String.class.getName() );
        }
        getActiveProfiles().remove( string );
    } //-- void removeActiveProfile(String) 

    /**
     * Method removeMirror
     * 
     * @param mirror
     */
    public void removeMirror(Mirror mirror)
    {
        if ( !(mirror instanceof Mirror) )
        {
            throw new ClassCastException( "Settings.removeMirrors(mirror) parameter must be instanceof " + Mirror.class.getName() );
        }
        getMirrors().remove( mirror );
    } //-- void removeMirror(Mirror) 

    /**
     * Method removePluginGroup
     * 
     * @param string
     */
    public void removePluginGroup(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Settings.removePluginGroups(string) parameter must be instanceof " + String.class.getName() );
        }
        getPluginGroups().remove( string );
    } //-- void removePluginGroup(String) 

    /**
     * Method removeProfile
     * 
     * @param profile
     */
    public void removeProfile(Profile profile)
    {
        if ( !(profile instanceof Profile) )
        {
            throw new ClassCastException( "Settings.removeProfiles(profile) parameter must be instanceof " + Profile.class.getName() );
        }
        getProfiles().remove( profile );
    } //-- void removeProfile(Profile) 

    /**
     * Method removeProxy
     * 
     * @param proxy
     */
    public void removeProxy(Proxy proxy)
    {
        if ( !(proxy instanceof Proxy) )
        {
            throw new ClassCastException( "Settings.removeProxies(proxy) parameter must be instanceof " + Proxy.class.getName() );
        }
        getProxies().remove( proxy );
    } //-- void removeProxy(Proxy) 

    /**
     * Method removeServer
     * 
     * @param server
     */
    public void removeServer(Server server)
    {
        if ( !(server instanceof Server) )
        {
            throw new ClassCastException( "Settings.removeServers(server) parameter must be instanceof " + Server.class.getName() );
        }
        getServers().remove( server );
    } //-- void removeServer(Server) 

    /**
     * Set 
     *             
     *             List of manually-activated build profiles,
     * specified in the order in which
     *             they should be applied.
     *             
     *           
     * 
     * @param activeProfiles
     */
    public void setActiveProfiles(java.util.List activeProfiles)
    {
        this.activeProfiles = activeProfiles;
    } //-- void setActiveProfiles(java.util.List) 

    /**
     * Set 
     *             
     *             Whether Maven should attempt to interact with
     * the user for input.
     *             
     *           
     * 
     * @param interactiveMode
     */
    public void setInteractiveMode(boolean interactiveMode)
    {
        this.interactiveMode = interactiveMode;
    } //-- void setInteractiveMode(boolean) 

    /**
     * Set 
     *             
     *             The local repository.
     *             
     *           
     * 
     * @param localRepository
     */
    public void setLocalRepository(String localRepository)
    {
        this.localRepository = localRepository;
    } //-- void setLocalRepository(String) 

    /**
     * Set 
     *             Configuration of download mirrors for
     * repositories.
     *           
     * 
     * @param mirrors
     */
    public void setMirrors(java.util.List mirrors)
    {
        this.mirrors = mirrors;
    } //-- void setMirrors(java.util.List) 

    /**
     * Set 
     *             
     *             Indicate whether maven should operate in offline
     * mode full-time.
     *             
     *           
     * 
     * @param offline
     */
    public void setOffline(boolean offline)
    {
        this.offline = offline;
    } //-- void setOffline(boolean) 

    /**
     * Set 
     *             List of groupIds to search for a plugin when
     * that plugin
     *             groupId is not explicitly provided.
     *           
     * 
     * @param pluginGroups
     */
    public void setPluginGroups(java.util.List pluginGroups)
    {
        this.pluginGroups = pluginGroups;
    } //-- void setPluginGroups(java.util.List) 

    /**
     * Set 
     *             
     *             Configuration of build profiles for adjusting
     * the build
     *             according to environmental parameters.
     *             
     *           
     * 
     * @param profiles
     */
    public void setProfiles(java.util.List profiles)
    {
        this.profiles = profiles;
    } //-- void setProfiles(java.util.List) 

    /**
     * Set 
     *             
     *             Configuration for different proxy profiles.
     * Multiple proxy profiles
     *             might come in handy for anyone working from a
     * notebook or other
     *             mobile platform, to enable easy switching of
     * entire proxy
     *             configurations by simply specifying the profile
     * id, again either from
     *             the command line or from the defaults section
     * below.
     *             
     *           
     * 
     * @param proxies
     */
    public void setProxies(java.util.List proxies)
    {
        this.proxies = proxies;
    } //-- void setProxies(java.util.List) 

    /**
     * Set 
     *             
     *             Configuration of server-specific settings,
     * mainly authentication
     *             method. This allows configuration of
     * authentication on a per-server
     *             basis.
     *             
     *           
     * 
     * @param servers
     */
    public void setServers(java.util.List servers)
    {
        this.servers = servers;
    } //-- void setServers(java.util.List) 

    /**
     * Set 
     *             
     *             Whether Maven should use the plugin-registry.xml
     * file to manage plugin versions.
     *             
     *           
     * 
     * @param usePluginRegistry
     */
    public void setUsePluginRegistry(boolean usePluginRegistry)
    {
        this.usePluginRegistry = usePluginRegistry;
    } //-- void setUsePluginRegistry(boolean) 


            
    public Boolean getInteractiveMode()
    {
        return Boolean.valueOf( isInteractiveMode() );
    }

    private Proxy activeProxy;

    /**
     * Reset the <code>activeProxy</code> field to <code>null</code>
     */
    public void flushActiveProxy()
    {
        this.activeProxy = null;
    }

    /**
     * @return the first active proxy
     */
    public synchronized Proxy getActiveProxy()
    {
        if(activeProxy == null)
        {
            java.util.List proxies = getProxies();
            if ( proxies != null && !proxies.isEmpty() )
            {
                if ( proxies.size() > 1 )
                {
                    for ( java.util.Iterator it = proxies.iterator(); it.hasNext(); )
                    {
                        Proxy proxy = (Proxy) it.next();
                        if ( proxy.isActive() )
                        {
                            activeProxy = proxy;
                            break;
                        }
                    }
                }
                else
                {
                    // If we only have one proxy, use it as the active one.
                    activeProxy = (Proxy) proxies.get( 0 );
                }
            }
        }

        return activeProxy;
    }

    public Server getServer( String serverId )
    {
        Server match = null;

        java.util.List servers = getServers();
        if ( servers != null && serverId != null )
        {
            for ( java.util.Iterator it = servers.iterator(); it.hasNext(); )
            {
                Server server = (Server) it.next();
                if ( serverId.equals( server.getId() ) )
                {
                    match = server;
                    break;
                }
            }
        }

        return match;
    }

    public Mirror getMirrorOf( String repositoryId )
    {
        Mirror match = null;

        java.util.List mirrors = getMirrors();
        if ( mirrors != null && repositoryId != null )
        {
            for ( java.util.Iterator it = mirrors.iterator(); it.hasNext(); )
            {
                Mirror mirror = (Mirror) it.next();
                if ( repositoryId.equals( mirror.getMirrorOf() ) )
                {
                    match = mirror;
                    break;
                }
            }
        }

        return match;
    }

    private java.util.Map profileMap;

    /**
     * Reset the <code>profileMap</code> field to <code>null</code>
     */
    public void flushProfileMap()
    {
        this.profileMap = null;
    }

    /**
     * @return a Map of profiles field with <code>Profile#getId()</code> as key
     * @see org.apache.maven.settings.Profile#getId()
     */
    public java.util.Map getProfilesAsMap()
    {
        if ( profileMap == null )
        {
            profileMap = new java.util.HashMap();

            if ( getProfiles() != null )
            {
                for ( java.util.Iterator it = getProfiles().iterator(); it.hasNext(); )
                {
                    Profile profile = (Profile) it.next();

                    profileMap.put( profile.getId(), profile );
                }
            }
        }

        return profileMap;
    }

    private RuntimeInfo runtimeInfo;

    public void setRuntimeInfo( RuntimeInfo runtimeInfo )
    {
        this.runtimeInfo = runtimeInfo;
    }

    public RuntimeInfo getRuntimeInfo()
    {
        return runtimeInfo;
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
