/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.internal.ProviderMethodsModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.plugin.testing.Basedir;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoParameter;
import org.apache.maven.api.plugin.testing.MojoParameters;
import org.apache.maven.api.plugin.testing.MojoTest;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.testing.MojoLogWrapper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.testing.PlexusExtension;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class MojoExtension
extends PlexusExtension
implements ParameterResolver {
    private static final ExtensionContext.Namespace MOJO_EXTENSION = ExtensionContext.Namespace.create((Object[])new Object[]{"MojoExtension"});
    public static final String BASEDIR_IS_SET_KEY = "basedirIsSet";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Mojo.class.isAssignableFrom(parameterContext.getParameter().getType()) && (parameterContext.isAnnotated(InjectMojo.class) || parameterContext.getDeclaringExecutable().isAnnotationPresent(InjectMojo.class));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            InjectMojo injectMojo = parameterContext.findAnnotation(InjectMojo.class).orElseGet(() -> parameterContext.getDeclaringExecutable().getAnnotation(InjectMojo.class));
            LinkedHashSet<MojoParameter> mojoParameters = new LinkedHashSet<MojoParameter>();
            extensionContext.getEnclosingTestClasses().forEach(testClass -> mojoParameters.addAll(Arrays.asList((MojoParameter[])testClass.getAnnotationsByType(MojoParameter.class))));
            extensionContext.getTestClass().map(c -> (MojoParameter[])c.getAnnotationsByType(MojoParameter.class)).map(Arrays::asList).ifPresent(mojoParameters::addAll);
            Optional.ofNullable(parameterContext.getDeclaringExecutable().getAnnotation(MojoParameter.class)).ifPresent(mojoParameters::add);
            Optional.ofNullable(parameterContext.getDeclaringExecutable().getAnnotation(MojoParameters.class)).map(MojoParameters::value).map(Arrays::asList).ifPresent(mojoParameters::addAll);
            mojoParameters.addAll(parameterContext.findRepeatableAnnotations(MojoParameter.class));
            Class<?> holder = parameterContext.getTarget().get().getClass();
            PluginDescriptor descriptor = (PluginDescriptor)extensionContext.getStore(MOJO_EXTENSION).get(PluginDescriptor.class, PluginDescriptor.class);
            return this.lookupMojo(extensionContext, holder, injectMojo, mojoParameters, descriptor);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Unable to resolve parameter", (Throwable)e);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        String basedir = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), Basedir.class).map(Basedir::value).orElseGet(() -> AnnotationSupport.findAnnotation((Class)context.getRequiredTestClass(), Basedir.class, (List)context.getEnclosingTestClasses()).map(Basedir::value).orElse(null));
        if (basedir == null) {
            basedir = MojoExtension.getBasedir();
        } else {
            context.getStore(MOJO_EXTENSION).put((Object)BASEDIR_IS_SET_KEY, (Object)Boolean.TRUE);
        }
        URL resource = context.getRequiredTestClass().getResource(basedir);
        if (resource != null) {
            basedir = Paths.get(resource.toURI()).toString();
        }
        basedir = new File(basedir).getAbsolutePath();
        this.setTestBasedir(basedir, context);
        PlexusContainer plexusContainer = this.getContainer(context);
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> ((DefaultPlexusContainer)plexusContainer).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> {
            binder.install(ProviderMethodsModule.forObject((Object)testInstance));
            binder.install((Module)new MavenProvidesModule(testInstance));
        }}));
        this.addMock(plexusContainer, Log.class, () -> (Log)Mockito.spy((Object)new MojoLogWrapper(LoggerFactory.getLogger((String)"anonymous"))));
        MavenProject mavenProject = this.addMock(plexusContainer, MavenProject.class, this::mockMavenProject);
        MojoExecution mojoExecution = this.addMock(plexusContainer, MojoExecution.class, this::mockMojoExecution);
        MavenSession mavenSession = this.addMock(plexusContainer, MavenSession.class, this::mockMavenSession);
        this.createMavenExecutionRequest(context);
        SessionScope sessionScope = (SessionScope)plexusContainer.lookup(SessionScope.class);
        sessionScope.enter();
        sessionScope.seed(MavenSession.class, (Object)mavenSession);
        MojoExecutionScope executionScope = (MojoExecutionScope)plexusContainer.lookup(MojoExecutionScope.class);
        executionScope.enter();
        executionScope.seed(MavenProject.class, (Object)mavenProject);
        executionScope.seed(MojoExecution.class, (Object)mojoExecution);
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> ((DefaultPlexusContainer)plexusContainer).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> binder.requestInjection(testInstance)}));
        Map map = plexusContainer.getContext().getContextData();
        ClassLoader classLoader = context.getRequiredTestClass().getClassLoader();
        try (InputStream is = Objects.requireNonNull(classLoader.getResourceAsStream(this.getPluginDescriptorLocation()), "Unable to find plugin descriptor: " + this.getPluginDescriptorLocation());
             BufferedReader reader = new BufferedReader((Reader)new XmlStreamReader(is));
             InterpolationFilterReader interpolationReader = new InterpolationFilterReader((Reader)reader, map, "${", "}");){
            PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationReader);
            Plugin plugin = new Plugin();
            plugin.setGroupId(pluginDescriptor.getGroupId());
            plugin.setArtifactId(pluginDescriptor.getArtifactId());
            plugin.setVersion(pluginDescriptor.getVersion());
            pluginDescriptor.setPlugin(plugin);
            context.getStore(MOJO_EXTENSION).put(PluginDescriptor.class, (Object)pluginDescriptor);
            for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
                plexusContainer.addComponentDescriptor(desc);
            }
        }
    }

    private <T> T addMock(PlexusContainer container, Class<T> role, Supplier<T> supplier) throws ComponentLookupException {
        if (!container.hasComponent(role)) {
            T mock = supplier.get();
            container.addComponent(mock, role, "default");
            return mock;
        }
        return (T)container.lookup(role);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        SessionScope sessionScope = (SessionScope)this.getContainer(context).lookup(SessionScope.class);
        sessionScope.exit();
        MojoExecutionScope executionScope = (MojoExecutionScope)this.getContainer(context).lookup(MojoExecutionScope.class);
        executionScope.exit();
        super.afterEach(context);
    }

    private MojoExecution mockMojoExecution() {
        return (MojoExecution)Mockito.spy((Object)new MojoExecution(null));
    }

    private MavenSession mockMavenSession() {
        MavenSession session = (MavenSession)Mockito.mock(MavenSession.class);
        Mockito.lenient().when((Object)session.getUserProperties()).thenReturn((Object)new Properties());
        Mockito.lenient().when((Object)session.getSystemProperties()).thenReturn((Object)new Properties());
        return session;
    }

    private MavenProject mockMavenProject() {
        MavenProject mavenProject = (MavenProject)Mockito.spy((Object)new MavenProject());
        Build build = (Build)Mockito.spy((Object)new Build());
        build.setDirectory(Paths.get(MojoExtension.getBasedir(), "target").toString());
        build.setOutputDirectory(Paths.get(MojoExtension.getBasedir(), "target", "classes").toString());
        build.setTestOutputDirectory(Paths.get(MojoExtension.getBasedir(), "target", "test-classes").toString());
        build.setSourceDirectory(Paths.get(MojoExtension.getBasedir(), "src", "main", "java").toString());
        build.setTestSourceDirectory(Paths.get(MojoExtension.getBasedir(), "src", "test", "java").toString());
        Resource resource = (Resource)Mockito.spy((Object)new Resource());
        resource.setDirectory(Paths.get(MojoExtension.getBasedir(), "src", "main", "resource").toString());
        build.setResources(Arrays.asList(resource));
        Resource testResource = (Resource)Mockito.spy((Object)new Resource());
        testResource.setDirectory(Paths.get(MojoExtension.getBasedir(), "src", "test", "resource").toString());
        build.setTestResources(Arrays.asList(resource));
        mavenProject.setBuild(build);
        mavenProject.addCompileSourceRoot(build.getSourceDirectory());
        mavenProject.addTestCompileSourceRoot(build.getTestSourceDirectory());
        try {
            MojoExtension.setVariableValueToObject(mavenProject, "basedir", Paths.get(MojoExtension.getBasedir(), new String[0]).toFile());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return mavenProject;
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private Mojo lookupMojo(ExtensionContext extensionContext, Class<?> holder, InjectMojo injectMojo, Collection<MojoParameter> mojoParameters, PluginDescriptor descriptor) throws Exception {
        String goal = injectMojo.goal();
        String pom = injectMojo.pom();
        Path basedir = Paths.get(this.getTestBasedir(extensionContext), new String[0]);
        String[] coord = this.mojoCoordinates(goal, descriptor);
        Xpp3Dom pomDom = null;
        Path pomPath = null;
        if (pom.startsWith("file:")) {
            pomPath = basedir.resolve(pom.substring("file:".length()));
        } else if (pom.startsWith("classpath:")) {
            URL url = holder.getResource(pom.substring("classpath:".length()));
            if (url == null) {
                throw new IllegalStateException("Unable to find pom on classpath: " + pom);
            }
            pomPath = Paths.get(url.toURI());
        } else if (pom.contains("<project>")) {
            pomDom = Xpp3DomBuilder.build((Reader)new StringReader(pom));
        } else if (!pom.isEmpty()) {
            pomPath = basedir.resolve(pom);
        } else if (this.isBasedirSet(extensionContext)) {
            pomPath = basedir.resolve("pom.xml");
        }
        if (pomDom == null) {
            pomDom = pomPath != null && Files.exists(pomPath, new LinkOption[0]) ? Xpp3DomBuilder.build((Reader)new XmlStreamReader(pomPath.toFile())) : new Xpp3Dom("");
        }
        Xpp3Dom pluginConfiguration = MojoExtension.extractPluginConfiguration(coord[1], pomDom);
        if (!mojoParameters.isEmpty()) {
            List<Xpp3Dom> children = mojoParameters.stream().map(mp -> {
                Xpp3Dom c = new Xpp3Dom(mp.name());
                c.setValue(mp.value());
                return c;
            }).collect(Collectors.toList());
            Xpp3Dom config = new Xpp3Dom("configuration");
            children.forEach(arg_0 -> ((Xpp3Dom)config).addChild(arg_0));
            pluginConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)config, (Xpp3Dom)pluginConfiguration);
        }
        return this.lookupMojo(extensionContext, coord, pluginConfiguration, descriptor, pomPath);
    }

    private boolean isBasedirSet(ExtensionContext extensionContext) {
        return (Boolean)extensionContext.getStore(MOJO_EXTENSION).getOrDefault((Object)BASEDIR_IS_SET_KEY, Boolean.class, (Object)Boolean.FALSE);
    }

    protected String[] mojoCoordinates(String goal, PluginDescriptor pluginDescriptor) throws Exception {
        if (goal.matches(".*:.*:.*:.*")) {
            return goal.split(":");
        }
        String artifactId = pluginDescriptor.getArtifactId();
        String groupId = pluginDescriptor.getGroupId();
        String version = pluginDescriptor.getVersion();
        return new String[]{groupId, artifactId, version, goal};
    }

    protected Mojo lookupMojo(ExtensionContext extensionContext, String[] coord, Xpp3Dom pluginConfiguration, PluginDescriptor descriptor, Path pomPath) throws Exception {
        PlexusContainer plexusContainer = this.getContainer(extensionContext);
        MavenExecutionRequest request = this.setupMavenExecutionRequest(extensionContext);
        ((MavenExecutionRequestPopulator)plexusContainer.lookup(MavenExecutionRequestPopulator.class)).populateDefaults(request);
        this.setupRepositorySession(extensionContext, request);
        Mojo mojo = (Mojo)plexusContainer.lookup(Mojo.class, coord[0] + ":" + coord[1] + ":" + coord[2] + ":" + coord[3]);
        Optional<MojoDescriptor> mojoDescriptor = descriptor.getMojos().stream().filter(md -> Objects.equals(md.getImplementation(), mojo.getClass().getName())).findFirst();
        if (mojoDescriptor.isPresent()) {
            pluginConfiguration = this.finalizeConfig(pluginConfiguration, mojoDescriptor.get());
        }
        MavenSession session = (MavenSession)plexusContainer.lookup(MavenSession.class);
        MavenProject mavenProject = (MavenProject)plexusContainer.lookup(MavenProject.class);
        MojoExecution mojoExecution = (MojoExecution)plexusContainer.lookup(MojoExecution.class);
        if (Mockito.mockingDetails((Object)session).isMock()) {
            ((MavenSession)Mockito.lenient().doReturn((Object)mavenProject).when((Object)session)).getCurrentProject();
            ((MavenSession)Mockito.lenient().doReturn((Object)request.getLocalRepository()).when((Object)session)).getLocalRepository();
        }
        if (Mockito.mockingDetails((Object)mavenProject).isMock()) {
            File pomFile = Optional.ofNullable(pomPath).map(Path::toFile).orElse(null);
            if (Mockito.mockingDetails((Object)mavenProject).isSpy()) {
                mavenProject.setPomFile(pomFile);
            } else {
                ((MavenProject)Mockito.lenient().doReturn((Object)pomFile).when((Object)mavenProject)).getFile();
            }
        }
        if (mojoDescriptor.isPresent() && Mockito.mockingDetails((Object)mojoExecution).isMock()) {
            if (Mockito.mockingDetails((Object)mojoExecution).isSpy()) {
                mojoExecution.setMojoDescriptor(mojoDescriptor.get());
            } else {
                ((MojoExecution)Mockito.lenient().doReturn((Object)mojoDescriptor.get()).when((Object)mojoExecution)).getMojoDescriptor();
            }
        }
        if (pluginConfiguration != null) {
            WrapEvaluator evaluator = new WrapEvaluator(plexusContainer, (TypeAwareExpressionEvaluator)new PluginParameterExpressionEvaluator(session, mojoExecution));
            BasicComponentConfigurator configurator = new BasicComponentConfigurator();
            configurator.configureComponent((Object)mojo, (PlexusConfiguration)new XmlPlexusConfiguration(pluginConfiguration), (ExpressionEvaluator)evaluator, plexusContainer.getContainerRealm());
        }
        mojo.setLog((Log)plexusContainer.lookup(Log.class));
        if (Mockito.mockingDetails((Object)session).isMock()) {
            Mockito.clearInvocations((Object[])new MavenSession[]{session});
        }
        if (Mockito.mockingDetails((Object)mavenProject).isMock()) {
            Mockito.clearInvocations((Object[])new MavenProject[]{mavenProject});
        }
        if (Mockito.mockingDetails((Object)mojoExecution).isMock()) {
            Mockito.clearInvocations((Object[])new MojoExecution[]{mojoExecution});
        }
        return mojo;
    }

    private boolean isRealRepositorySessionNotRequired(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Class)context.getRequiredTestClass(), MojoTest.class, (List)context.getEnclosingTestClasses()).map(MojoTest::realRepositorySession).orElse(false) == false;
    }

    private void createMavenExecutionRequest(ExtensionContext context) throws ComponentLookupException {
        PlexusContainer container = this.getContainer(context);
        MavenSession session = (MavenSession)container.lookup(MavenSession.class);
        MavenExecutionRequest request = session.getRequest();
        if (request == null && Mockito.mockingDetails((Object)session).isMock()) {
            ((MavenSession)Mockito.lenient().doReturn(Mockito.spy((Object)new DefaultMavenExecutionRequest())).when((Object)session)).getRequest();
        }
    }

    private MavenExecutionRequest setupMavenExecutionRequest(ExtensionContext context) throws ComponentLookupException {
        PlexusContainer container = this.getContainer(context);
        MavenSession session = (MavenSession)container.lookup(MavenSession.class);
        MavenExecutionRequest request = session.getRequest();
        if (request == null) {
            request = new DefaultMavenExecutionRequest();
        }
        if (request.getStartTime() == null) {
            request.setStartTime(new Date());
        }
        if (request.getUserProperties().isEmpty()) {
            request.setUserProperties(session.getUserProperties());
        }
        if (request.getSystemProperties().isEmpty()) {
            request.setSystemProperties(session.getSystemProperties());
        }
        if (request.getLocalRepositoryPath() == null && request.getLocalRepository() == null) {
            request.setLocalRepositoryPath(this.getTestBasedir(context) + "/target/local-repo");
        }
        if (request.getBaseDirectory() == null) {
            request.setBaseDirectory(new File(this.getTestBasedir(context)));
        }
        return request;
    }

    private void setupRepositorySession(ExtensionContext context, MavenExecutionRequest request) throws ComponentLookupException {
        if (this.isRealRepositorySessionNotRequired(context)) {
            return;
        }
        PlexusContainer container = this.getContainer(context);
        MavenProject mavenProject = (MavenProject)container.lookup(MavenProject.class);
        if (Mockito.mockingDetails((Object)mavenProject).isMock()) {
            ((MavenProject)Mockito.lenient().doReturn((Object)request.getRemoteRepositories()).when((Object)mavenProject)).getRemoteArtifactRepositories();
            ((MavenProject)Mockito.lenient().doReturn((Object)request.getPluginArtifactRepositories()).when((Object)mavenProject)).getPluginArtifactRepositories();
            ((MavenProject)Mockito.lenient().doReturn((Object)RepositoryUtils.toRepos((List)request.getRemoteRepositories())).when((Object)mavenProject)).getRemoteProjectRepositories();
            ((MavenProject)Mockito.lenient().doReturn((Object)RepositoryUtils.toRepos((List)request.getPluginArtifactRepositories())).when((Object)mavenProject)).getRemotePluginRepositories();
        }
        DefaultRepositorySystemSession repositorySystemSession = ((DefaultRepositorySystemSessionFactory)container.lookup(DefaultRepositorySystemSessionFactory.class)).newRepositorySession(request);
        MavenSession session = (MavenSession)container.lookup(MavenSession.class);
        if (Mockito.mockingDetails((Object)session).isMock()) {
            ((MavenSession)Mockito.lenient().doReturn((Object)repositorySystemSession).when((Object)session)).getRepositorySession();
        }
    }

    private Xpp3Dom finalizeConfig(Xpp3Dom config, MojoDescriptor mojoDescriptor) {
        ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
        if (mojoDescriptor != null && mojoDescriptor.getParameters() != null) {
            Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = config.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = config.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (this.isEmpty(parameterConfiguration.getAttribute("implementation")) && !this.isEmpty(parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                children.add(parameterConfiguration);
            }
        }
        Xpp3Dom c = new Xpp3Dom("configuration");
        children.forEach(arg_0 -> ((Xpp3Dom)c).addChild(arg_0));
        return c;
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static Optional<Xpp3Dom> child(Xpp3Dom element, String name) {
        return Optional.ofNullable(element.getChild(name));
    }

    private static Stream<Xpp3Dom> children(Xpp3Dom element) {
        return Stream.of(element.getChildren());
    }

    public static Xpp3Dom extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginConfigurationElement = MojoExtension.child(pomDom, "build").flatMap(buildElement -> MojoExtension.child(buildElement, "plugins")).map(MojoExtension::children).orElseGet(Stream::empty).filter(e -> e.getChild("artifactId").getValue().equals(artifactId)).findFirst().flatMap(buildElement -> MojoExtension.child(buildElement, "configuration")).orElse(Xpp3DomBuilder.build((Reader)new StringReader("<configuration/>")));
        return pluginConfigurationElement;
    }

    public static <T> T getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return (T)field.get(object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return MojoExtension.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(MojoExtension.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    public static String getBasedir() {
        return PlexusExtension.getBasedir();
    }

    public static File getTestFile(String path) {
        return PlexusExtension.getTestFile((String)path);
    }

    public static String getTestPath(String path) {
        return PlexusExtension.getTestPath((String)path);
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        Objects.requireNonNull(field, "Field " + variable + " not found");
        field.setAccessible(true);
        field.set(object, value);
    }

    private static class WrapEvaluator
    implements TypeAwareExpressionEvaluator {
        private final PlexusContainer container;
        private final TypeAwareExpressionEvaluator evaluator;

        WrapEvaluator(PlexusContainer container, TypeAwareExpressionEvaluator evaluator) {
            this.container = container;
            this.evaluator = evaluator;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            String expr;
            Object value = this.evaluator.evaluate(expression, type);
            if (value == null && (expr = this.stripTokens(expression)) != null) {
                try {
                    value = this.container.lookup(type, expr);
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }
            return value;
        }

        private String stripTokens(String expr) {
            if (expr.startsWith("${") && expr.endsWith("}")) {
                return expr.substring(2, expr.length() - 1);
            }
            return null;
        }

        public File alignToBaseDirectory(File path) {
            return this.evaluator.alignToBaseDirectory(path);
        }
    }

    private static class MavenProvidesModule
    implements Module {
        private final Object testInstance;

        MavenProvidesModule(Object testInstance) {
            this.testInstance = testInstance;
        }

        public void configure(Binder binder) {
            List providesMethods = AnnotationSupport.findAnnotatedMethods(this.testInstance.getClass(), Provides.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
            for (Method method : providesMethods) {
                if (method.getParameterCount() > 0) {
                    throw new IllegalArgumentException("Parameterized method are not supported " + method);
                }
                try {
                    method.setAccessible(true);
                    Object value = method.invoke(this.testInstance, new Object[0]);
                    if (value == null) {
                        throw new IllegalArgumentException("Provides method returned null: " + method);
                    }
                    binder.bind(method.getReturnType()).toInstance(value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }
}

