/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.test.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.model.Build;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Site;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.shared.test.plugin.BuildTool;
import org.apache.maven.shared.test.plugin.RepositoryTool;
import org.apache.maven.shared.test.plugin.TestToolsException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=ProjectTool.class)
public class ProjectTool {
    public static final String ROLE = ProjectTool.class.getName();
    public static final String INTEGRATION_TEST_DEPLOYMENT_REPO_URL = "integration-test.deployment.repo.url";
    @Requirement
    private BuildTool buildTool;
    @Requirement
    private RepositoryTool repositoryTool;
    @Requirement
    private ProjectBuilder projectBuilder;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;

    public MavenProject readProject(File pomFile) throws TestToolsException {
        return this.readProject(pomFile, this.repositoryTool.findLocalRepositoryDirectory());
    }

    public MavenProject readProject(File pomFile, File localRepositoryBasedir) throws TestToolsException {
        try {
            ArtifactRepository localRepository = this.repositoryTool.createLocalArtifactRepositoryInstance(localRepositoryBasedir);
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            return this.projectBuilder.build(pomFile, (ProjectBuildingRequest)request).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new TestToolsException("Error building MavenProject instance from test pom: " + pomFile, e);
        }
    }

    public MavenProject readProjectWithDependencies(File pomFile) throws TestToolsException {
        return this.readProjectWithDependencies(pomFile, this.repositoryTool.findLocalRepositoryDirectory());
    }

    public MavenProject readProjectWithDependencies(File pomFile, File localRepositoryBasedir) throws TestToolsException {
        try {
            ArtifactRepository localRepository = this.repositoryTool.createLocalArtifactRepositoryInstance(localRepositoryBasedir);
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            return this.projectBuilder.build(pomFile, (ProjectBuildingRequest)request).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new TestToolsException("Error building MavenProject instance from test pom: " + pomFile, e);
        }
    }

    public MavenProject packageProjectArtifact(File pomFile, String testVersion, boolean skipUnitTests) throws TestToolsException {
        return this.packageProjectArtifact(pomFile, testVersion, skipUnitTests, null);
    }

    public MavenProject packageProjectArtifact(File pomFile, String testVersion, boolean skipUnitTests, File logFile) throws TestToolsException {
        PomInfo pomInfo = this.manglePomForTesting(pomFile, testVersion, skipUnitTests);
        Properties properties = new Properties();
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("package");
        File buildLog = logFile == null ? pomInfo.getBuildLogFile() : logFile;
        System.out.println("Now Building test version of the plugin...\nUsing staged plugin-pom: " + pomInfo.getPomFile().getAbsolutePath());
        this.buildTool.executeMaven(pomInfo.getPomFile(), properties, goals, buildLog);
        File artifactFile = new File(pomInfo.getPomFile().getParentFile(), pomInfo.getBuildDirectory() + "/" + pomInfo.getFinalName());
        System.out.println("Using IT Plugin Jar: " + artifactFile.getAbsolutePath());
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setLocalRepository(this.artifactRepositoryFactory.createArtifactRepository("local", new File("target/localrepo").getCanonicalFile().toURL().toExternalForm(), "default", null, null));
            request.setRepositorySession((RepositorySystemSession)new MavenRepositorySystemSession());
            MavenProject project = this.projectBuilder.build(pomInfo.getPomFile(), (ProjectBuildingRequest)request).getProject();
            Artifact artifact = this.artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            artifact.setFile(artifactFile);
            artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, project.getFile()));
            project.setArtifact(artifact);
            return project;
        }
        catch (ProjectBuildingException e) {
            throw new TestToolsException("Error building MavenProject instance from test pom: " + pomInfo.getPomFile(), e);
        }
        catch (UnknownRepositoryLayoutException e) {
            throw new TestToolsException("Error building ArtifactRepository instance from test pom: " + pomInfo.getPomFile(), e);
        }
        catch (IOException e) {
            throw new TestToolsException("Error building ArtifactRepository instance from test pom: " + pomInfo.getPomFile(), e);
        }
    }

    protected PomInfo manglePomForTesting(File pomFile, String testVersion, boolean skipUnitTests) throws TestToolsException {
        File input = pomFile;
        File output = new File(pomFile.getParentFile(), "pom-" + testVersion + ".xml");
        output.deleteOnExit();
        XmlStreamReader reader = null;
        XmlStreamWriter writer = null;
        Model model = null;
        String finalName = null;
        String buildDirectory = null;
        try {
            reader = ReaderFactory.newXmlReader((File)input);
            model = new MavenXpp3Reader().read((Reader)reader);
        }
        catch (IOException e) {
            throw new TestToolsException("Error creating test-time version of POM for: " + input, e);
        }
        catch (XmlPullParserException e) {
            throw new TestToolsException("Error creating test-time version of POM for: " + input, e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        try {
            model.setVersion(testVersion);
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
            }
            if ((buildDirectory = build.getDirectory()) == null) {
                buildDirectory = "target";
            }
            buildDirectory = buildDirectory + File.separatorChar + "it-build-target";
            build.setDirectory(buildDirectory);
            build.setOutputDirectory(buildDirectory + File.separatorChar + "classes");
            System.out.println("Using " + build.getDirectory() + " and " + build.getOutputDirectory() + " to build IT version of plugin");
            model.setBuild(build);
            finalName = build.getFinalName();
            if (finalName == null) {
                ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(model.getPackaging());
                String ext = handler.getExtension();
                finalName = model.getArtifactId() + "-" + model.getVersion() + "." + ext;
            }
            DistributionManagement distMgmt = new DistributionManagement();
            DeploymentRepository deployRepo = new DeploymentRepository();
            deployRepo.setId("integration-test.output");
            File tmpDir = FileUtils.createTempFile((String)"integration-test-repo", (String)"", null);
            String tmpUrl = tmpDir.toURL().toExternalForm();
            deployRepo.setUrl(tmpUrl);
            distMgmt.setRepository(deployRepo);
            distMgmt.setSnapshotRepository(deployRepo);
            Repository localAsRemote = new Repository();
            localAsRemote.setId("testing.mainLocalAsRemote");
            File localRepoDir = this.repositoryTool.findLocalRepositoryDirectory();
            localAsRemote.setUrl(localRepoDir.toURL().toExternalForm());
            model.addRepository(localAsRemote);
            model.addPluginRepository(localAsRemote);
            Site site = new Site();
            site.setId("integration-test.output");
            site.setUrl(tmpUrl);
            distMgmt.setSite(site);
            model.setDistributionManagement(distMgmt);
            model.addProperty(INTEGRATION_TEST_DEPLOYMENT_REPO_URL, tmpUrl);
            if (skipUnitTests) {
                Xpp3Dom configDom;
                List plugins = build.getPlugins();
                Plugin plugin = null;
                for (Plugin plug : plugins) {
                    if (!"maven-surefire-plugin".equals(plug.getArtifactId())) continue;
                    plugin = plug;
                    break;
                }
                if (plugin == null) {
                    plugin = new Plugin();
                    plugin.setArtifactId("maven-surefire-plugin");
                    build.addPlugin(plugin);
                }
                if ((configDom = (Xpp3Dom)plugin.getConfiguration()) == null) {
                    configDom = new Xpp3Dom("configuration");
                    plugin.setConfiguration((Object)configDom);
                }
                Xpp3Dom skipDom = new Xpp3Dom("skip");
                skipDom.setValue("true");
                configDom.addChild(skipDom);
            }
            writer = WriterFactory.newXmlWriter((File)output);
            new MavenXpp3Writer().write((Writer)writer, model);
        }
        catch (IOException e) {
            try {
                throw new TestToolsException("Error creating test-time version of POM for: " + input, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return new PomInfo(output, model.getGroupId(), model.getArtifactId(), model.getVersion(), model.getBuild().getDirectory(), model.getBuild().getOutputDirectory(), finalName);
    }

    static final class PomInfo {
        private final File pomFile;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String finalName;
        private final String buildDirectory;
        private final String buildOutputDirectory;

        PomInfo(File pomFile, String groupId, String artifactId, String version, String buildDirectory, String buildOutputDirectory, String finalName) {
            this.pomFile = pomFile;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.buildDirectory = buildDirectory;
            this.buildOutputDirectory = buildOutputDirectory;
            this.finalName = finalName;
        }

        File getPomFile() {
            return this.pomFile;
        }

        String getBuildDirectory() {
            return this.buildDirectory;
        }

        String getBuildOutputDirectory() {
            return this.buildOutputDirectory;
        }

        String getFinalName() {
            return this.finalName;
        }

        File getBuildLogFile() {
            return new File(this.buildDirectory + "/test-build-logs/" + this.groupId + "_" + this.artifactId + "_" + this.version + ".build.log");
        }
    }
}

