/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.AbstractScriptedMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.model.PluginMetadataParseException;
import org.apache.maven.tools.plugin.extractor.model.PluginMetadataParser;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.StringUtils;

@Component(role=MojoDescriptorExtractor.class, hint="ant")
public class AntMojoDescriptorExtractor
extends AbstractScriptedMojoDescriptorExtractor
implements MojoDescriptorExtractor {
    private static final String METADATA_FILE_EXTENSION = ".mojos.xml";
    private static final String SCRIPT_FILE_EXTENSION = ".build.xml";

    protected List<MojoDescriptor> extractMojoDescriptorsFromMetadata(Map<String, Set<File>> metadataFilesKeyedByBasedir, PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        PluginMetadataParser parser = new PluginMetadataParser();
        for (Map.Entry<String, Set<File>> entry : metadataFilesKeyedByBasedir.entrySet()) {
            String basedir = entry.getKey();
            Set<File> metadataFiles = entry.getValue();
            for (File metadataFile : metadataFiles) {
                String basename = metadataFile.getName();
                basename = basename.substring(0, basename.length() - METADATA_FILE_EXTENSION.length());
                File scriptFile = new File(metadataFile.getParentFile(), basename + SCRIPT_FILE_EXTENSION);
                if (!scriptFile.exists()) {
                    throw new InvalidPluginDescriptorException("Found orphaned plugin metadata file: " + metadataFile);
                }
                String relativePath = scriptFile.getPath().substring(basedir.length()).replace('\\', '/');
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                try {
                    Set mojoDescriptors = parser.parseMojoDescriptors(metadataFile);
                    for (MojoDescriptor descriptor : mojoDescriptors) {
                        Parameter param;
                        Map paramMap = descriptor.getParameterMap();
                        if (!paramMap.containsKey("basedir")) {
                            param = new Parameter();
                            param.setName("basedir");
                            param.setAlias("ant.basedir");
                            param.setExpression("${antBasedir}");
                            param.setDefaultValue("${basedir}");
                            param.setType("java.io.File");
                            param.setDescription("The base directory from which to execute the Ant script.");
                            param.setEditable(true);
                            param.setRequired(true);
                            descriptor.addParameter(param);
                        }
                        if (!paramMap.containsKey("antMessageLevel")) {
                            param = new Parameter();
                            param.setName("messageLevel");
                            param.setAlias("ant.messageLevel");
                            param.setExpression("${antMessageLevel}");
                            param.setDefaultValue("info");
                            param.setType("java.lang.String");
                            param.setDescription("The message-level used to tune the verbosity of Ant logging.");
                            param.setEditable(true);
                            param.setRequired(false);
                            descriptor.addParameter(param);
                        }
                        if (!paramMap.containsKey("project")) {
                            param = new Parameter();
                            param.setName("project");
                            param.setDefaultValue("${project}");
                            param.setType(MavenProject.class.getName());
                            param.setDescription("The current MavenProject instance, which contains classpath elements.");
                            param.setEditable(false);
                            param.setRequired(true);
                            descriptor.addParameter(param);
                        }
                        if (!paramMap.containsKey("session")) {
                            param = new Parameter();
                            param.setName("session");
                            param.setDefaultValue("${session}");
                            param.setType("org.apache.maven.execution.MavenSession");
                            param.setDescription("The current MavenSession instance, which is used for plugin-style expression resolution.");
                            param.setEditable(false);
                            param.setRequired(true);
                            descriptor.addParameter(param);
                        }
                        if (!paramMap.containsKey("mojoExecution")) {
                            param = new Parameter();
                            param.setName("mojoExecution");
                            param.setDefaultValue("${mojoExecution}");
                            param.setType("org.apache.maven.plugin.MojoExecution");
                            param.setDescription("The current Maven MojoExecution instance, which contains information about the mojo currently executing.");
                            param.setEditable(false);
                            param.setRequired(true);
                            descriptor.addParameter(param);
                        }
                        List requirements = descriptor.getRequirements();
                        HashMap<String, ComponentRequirement> reqMap = new HashMap<String, ComponentRequirement>();
                        if (requirements != null) {
                            for (ComponentRequirement req : requirements) {
                                reqMap.put(req.getRole(), req);
                            }
                        }
                        if (!reqMap.containsKey(PathTranslator.class.getName())) {
                            ComponentRequirement req = new ComponentRequirement();
                            req.setRole(PathTranslator.class.getName());
                            descriptor.addRequirement(req);
                        }
                        String implementation = relativePath;
                        String dImpl = descriptor.getImplementation();
                        if (StringUtils.isNotEmpty((String)dImpl)) {
                            implementation = "<REPLACE-WITH-MOJO-PATH>".equals(dImpl) ? relativePath : relativePath + dImpl.substring("<REPLACE-WITH-MOJO-PATH>".length());
                        }
                        descriptor.setImplementation(implementation);
                        descriptor.setLanguage("ant-mojo");
                        descriptor.setComponentComposer("map-oriented");
                        descriptor.setComponentConfigurator("map-oriented");
                        descriptor.setPluginDescriptor(request.getPluginDescriptor());
                        descriptors.add(descriptor);
                    }
                }
                catch (PluginMetadataParseException e) {
                    throw new ExtractionException("Error extracting mojo descriptor from script: " + metadataFile, (Throwable)e);
                }
            }
        }
        return descriptors;
    }

    protected String getScriptFileExtension(PluginToolsRequest request) {
        return SCRIPT_FILE_EXTENSION;
    }

    protected String getMetadataFileExtension(PluginToolsRequest request) {
        return METADATA_FILE_EXTENSION;
    }
}

