/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.javadoc;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.SortedClassLibraryBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.descriptor.InvalidParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.GroupKey;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.javadoc.JavadocMojoAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="java-javadoc")
@Singleton
public class JavaJavadocMojoDescriptorExtractor
implements MojoDescriptorExtractor,
JavadocMojoAnnotation {
    public static final String NAME = "java-javadoc";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaJavadocMojoDescriptorExtractor.class);
    private static final GroupKey GROUP_KEY = new GroupKey("java", 200);

    public String getName() {
        return NAME;
    }

    public boolean isDeprecated() {
        return true;
    }

    public GroupKey getGroupKey() {
        return GROUP_KEY;
    }

    protected void validateParameter(Parameter parameter, int i) throws InvalidParameterException {
        String name = parameter.getName();
        if (name == null) {
            throw new InvalidParameterException("name", i);
        }
        String type = parameter.getType();
        if (type == null) {
            throw new InvalidParameterException("type", i);
        }
        String description = parameter.getDescription();
        if (description == null) {
            throw new InvalidParameterException("description", i);
        }
    }

    protected MojoDescriptor createMojoDescriptor(JavaClass javaClass) throws InvalidPluginDescriptorException {
        DocletTag since;
        DocletTag requiresDependencyCollection;
        DocletTag requiresDependencyResolution;
        DocletTag phase;
        DocletTag goal;
        DocletTag execute;
        DocletTag configurator;
        ExtendedMojoDescriptor mojoDescriptor = new ExtendedMojoDescriptor();
        mojoDescriptor.setLanguage("java");
        mojoDescriptor.setImplementation(javaClass.getFullyQualifiedName());
        mojoDescriptor.setDescription(javaClass.getComment());
        DocletTag aggregator = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "aggregator");
        if (aggregator != null) {
            mojoDescriptor.setAggregator(true);
        }
        if ((configurator = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "configurator")) != null) {
            mojoDescriptor.setComponentConfigurator(configurator.getValue());
        }
        if ((execute = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "execute")) != null) {
            String executePhase = execute.getNamedParameter("phase");
            String executeGoal = execute.getNamedParameter("goal");
            if (executePhase == null && executeGoal == null) {
                throw new InvalidPluginDescriptorException(javaClass.getFullyQualifiedName() + ": @execute tag requires either a 'phase' or 'goal' parameter");
            }
            if (executePhase != null && executeGoal != null) {
                throw new InvalidPluginDescriptorException(javaClass.getFullyQualifiedName() + ": @execute tag can have only one of a 'phase' or 'goal' parameter");
            }
            mojoDescriptor.setExecutePhase(executePhase);
            mojoDescriptor.setExecuteGoal(executeGoal);
            String lifecycle = execute.getNamedParameter("lifecycle");
            if (lifecycle != null) {
                mojoDescriptor.setExecuteLifecycle(lifecycle);
                if (mojoDescriptor.getExecuteGoal() != null) {
                    throw new InvalidPluginDescriptorException(javaClass.getFullyQualifiedName() + ": @execute lifecycle requires a phase instead of a goal");
                }
            }
        }
        if ((goal = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "goal")) != null) {
            mojoDescriptor.setGoal(goal.getValue());
        }
        boolean value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "inheritByDefault", mojoDescriptor.isInheritedByDefault());
        mojoDescriptor.setInheritedByDefault(value);
        DocletTag tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "instantiationStrategy");
        if (tag != null) {
            mojoDescriptor.setInstantiationStrategy(tag.getValue());
        }
        if ((tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "attainAlways")) != null) {
            LOGGER.warn("@attainAlways in {} is deprecated: please use '@executionStrategy always' instead.", (Object)javaClass.getFullyQualifiedName());
            mojoDescriptor.setExecutionStrategy("always");
        } else {
            mojoDescriptor.setExecutionStrategy("once-per-session");
        }
        tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "executionStrategy");
        if (tag != null) {
            mojoDescriptor.setExecutionStrategy(tag.getValue());
        }
        if ((phase = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "phase")) != null) {
            mojoDescriptor.setPhase(phase.getValue());
        }
        if ((requiresDependencyResolution = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "requiresDependencyResolution")) != null) {
            String v = requiresDependencyResolution.getValue();
            if (v == null || v.isEmpty()) {
                v = "runtime";
            }
            mojoDescriptor.setDependencyResolutionRequired(v);
        }
        if ((requiresDependencyCollection = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "requiresDependencyCollection")) != null) {
            String v = requiresDependencyCollection.getValue();
            if (v == null || v.isEmpty()) {
                v = "runtime";
            }
            mojoDescriptor.setDependencyCollectionRequired(v);
        }
        value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "requiresDirectInvocation", mojoDescriptor.isDirectInvocationOnly());
        mojoDescriptor.setDirectInvocationOnly(value);
        value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "requiresOnline", mojoDescriptor.isOnlineRequired());
        mojoDescriptor.setOnlineRequired(value);
        value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "requiresProject", mojoDescriptor.isProjectRequired());
        mojoDescriptor.setProjectRequired(value);
        value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "requiresReports", mojoDescriptor.isRequiresReports());
        mojoDescriptor.setRequiresReports(value);
        DocletTag deprecated = javaClass.getTagByName("deprecated");
        if (deprecated != null) {
            mojoDescriptor.setDeprecated(deprecated.getValue());
        }
        if ((since = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, "since")) != null) {
            mojoDescriptor.setSince(since.getValue());
        }
        value = JavaJavadocMojoDescriptorExtractor.getBooleanTagValue(javaClass, "threadSafe", true, mojoDescriptor.isThreadSafe());
        mojoDescriptor.setThreadSafe(value);
        this.extractParameters((MojoDescriptor)mojoDescriptor, javaClass);
        return mojoDescriptor;
    }

    private static boolean getBooleanTagValue(JavaClass javaClass, String tagName, boolean defaultValue) {
        String value;
        DocletTag tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, tagName);
        if (tag != null && (value = tag.getValue()) != null && !value.isEmpty()) {
            defaultValue = Boolean.valueOf(value);
        }
        return defaultValue;
    }

    private static boolean getBooleanTagValue(JavaClass javaClass, String tagName, boolean defaultForTag, boolean defaultValue) {
        DocletTag tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(javaClass, tagName);
        if (tag != null) {
            String value = tag.getValue();
            if (value != null && !value.isEmpty()) {
                return Boolean.valueOf(value);
            }
            return defaultForTag;
        }
        return defaultValue;
    }

    private static DocletTag findInClassHierarchy(JavaClass javaClass, String tagName) {
        JavaClass superClass;
        DocletTag tag = javaClass.getTagByName(tagName);
        if (tag == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            tag = JavaJavadocMojoDescriptorExtractor.findInClassHierarchy(superClass, tagName);
        }
        return tag;
    }

    private void extractParameters(MojoDescriptor mojoDescriptor, JavaClass javaClass) throws InvalidPluginDescriptorException {
        Map<String, JavaField> rawParams = this.extractFieldParameterTags(javaClass);
        for (Map.Entry<String, JavaField> entry : rawParams.entrySet()) {
            DocletTag componentTag;
            DocletTag sinceTag;
            JavaField field = entry.getValue();
            JavaClass type = field.getType();
            Parameter pd = new Parameter();
            pd.setName(entry.getKey());
            pd.setType(type.getFullyQualifiedName());
            pd.setDescription(field.getComment());
            DocletTag deprecationTag = field.getTagByName("deprecated");
            if (deprecationTag != null) {
                pd.setDeprecated(deprecationTag.getValue());
            }
            if ((sinceTag = field.getTagByName("since")) != null) {
                pd.setSince(sinceTag.getValue());
            }
            if ((componentTag = field.getTagByName("component")) != null) {
                String roleHint;
                String role = componentTag.getNamedParameter("role");
                if (role == null) {
                    role = field.getType().toString();
                }
                if ((roleHint = componentTag.getNamedParameter("roleHint")) == null) {
                    roleHint = componentTag.getNamedParameter("role-hint");
                }
                pd.setRequirement(new Requirement(role, roleHint));
                pd.setEditable(false);
            } else {
                String alias;
                DocletTag parameter = field.getTagByName("parameter");
                pd.setRequired(field.getTagByName("required") != null);
                pd.setEditable(field.getTagByName("readonly") == null);
                String name = parameter.getNamedParameter("name");
                if (name != null && !name.isEmpty()) {
                    pd.setName(name);
                }
                if ((alias = parameter.getNamedParameter("alias")) != null && !alias.isEmpty()) {
                    pd.setAlias(alias);
                }
                String expression = parameter.getNamedParameter("expression");
                String property = parameter.getNamedParameter("property");
                if (expression != null && !expression.isEmpty() && property != null && !property.isEmpty()) {
                    LOGGER.error(javaClass.getFullyQualifiedName() + "#" + field.getName() + ":");
                    LOGGER.error("  Cannot use both:");
                    LOGGER.error("    @parameter expression=\"${property}\"");
                    LOGGER.error("  and");
                    LOGGER.error("    @parameter property=\"property\"");
                    LOGGER.error("  Second syntax is preferred.");
                    throw new InvalidParameterException(javaClass.getFullyQualifiedName() + "#" + field.getName() + ": cannot use both @parameter expression and property", null);
                }
                if (expression != null && !expression.isEmpty()) {
                    LOGGER.warn(javaClass.getFullyQualifiedName() + "#" + field.getName() + ":");
                    LOGGER.warn("  The syntax");
                    LOGGER.warn("    @parameter expression=\"${property}\"");
                    LOGGER.warn("  is deprecated, please use");
                    LOGGER.warn("    @parameter property=\"property\"");
                    LOGGER.warn("  instead.");
                } else if (property != null && !property.isEmpty()) {
                    expression = "${" + property + "}";
                }
                pd.setExpression(expression);
                if (expression != null && !expression.isEmpty() && expression.startsWith("${component.")) {
                    LOGGER.warn(javaClass.getFullyQualifiedName() + "#" + field.getName() + ":");
                    LOGGER.warn("  The syntax");
                    LOGGER.warn("    @parameter expression=\"${component.<role>#<roleHint>}\"");
                    LOGGER.warn("  is deprecated, please use");
                    LOGGER.warn("    @component role=\"<role>\" roleHint=\"<roleHint>\"");
                    LOGGER.warn("  instead.");
                }
                if ("${reports}".equals(pd.getExpression())) {
                    mojoDescriptor.setRequiresReports(true);
                }
                pd.setDefaultValue(parameter.getNamedParameter("default-value"));
                pd.setImplementation(parameter.getNamedParameter("implementation"));
            }
            mojoDescriptor.addParameter(pd);
        }
    }

    private Map<String, JavaField> extractFieldParameterTags(JavaClass javaClass) {
        JavaClass superClass = javaClass.getSuperJavaClass();
        Map<String, JavaField> rawParams = superClass != null ? this.extractFieldParameterTags(superClass) : new TreeMap<String, JavaField>();
        for (JavaField field : javaClass.getFields()) {
            if (field.getTagByName("parameter") == null && field.getTagByName("component") == null) continue;
            rawParams.put(field.getName(), field);
        }
        return rawParams;
    }

    public List<MojoDescriptor> execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Collection<JavaClass> javaClasses = this.discoverClasses(request);
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        for (JavaClass javaClass : javaClasses) {
            DocletTag tag = javaClass.getTagByName("goal");
            if (tag == null) continue;
            MojoDescriptor mojoDescriptor = this.createMojoDescriptor(javaClass);
            mojoDescriptor.setPluginDescriptor(request.getPluginDescriptor());
            this.validate(mojoDescriptor);
            descriptors.add(mojoDescriptor);
        }
        return descriptors;
    }

    protected Collection<JavaClass> discoverClasses(PluginToolsRequest request) {
        JavaProjectBuilder builder = new JavaProjectBuilder((ClassLibraryBuilder)new SortedClassLibraryBuilder());
        builder.setEncoding(request.getEncoding());
        ArrayList<URL> urls = new ArrayList<URL>(request.getDependencies().size());
        for (Object artifact : request.getDependencies()) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        builder.addClassLoader((ClassLoader)new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
        MavenProject project = request.getProject();
        for (String source : project.getCompileSourceRoots()) {
            builder.addSourceTree(new File(source));
        }
        File generatedPlugin = new File(project.getBasedir(), "target/generated-sources/plugin");
        if (!project.getCompileSourceRoots().contains(generatedPlugin.getAbsolutePath())) {
            builder.addSourceTree(generatedPlugin);
        }
        return builder.getClasses();
    }

    protected void validate(MojoDescriptor mojoDescriptor) throws InvalidParameterException {
        List parameters = mojoDescriptor.getParameters();
        if (parameters != null) {
            for (int j = 0; j < parameters.size(); ++j) {
                this.validateParameter((Parameter)parameters.get(j), j);
            }
        }
    }
}

