/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.model;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.tools.plugin.extractor.model.Component;
import org.apache.maven.tools.plugin.extractor.model.LifecycleExecution;
import org.apache.maven.tools.plugin.extractor.model.Mojo;
import org.apache.maven.tools.plugin.extractor.model.Parameter;
import org.apache.maven.tools.plugin.extractor.model.PluginMetadata;
import org.apache.maven.tools.plugin.extractor.model.PluginMetadataParseException;
import org.apache.maven.tools.plugin.extractor.model.io.xpp3.PluginMetadataXpp3Reader;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Deprecated
public class PluginMetadataParser {
    public static final String IMPL_BASE_PLACEHOLDER = "<REPLACE-WITH-MOJO-PATH>";

    public Set<MojoDescriptor> parseMojoDescriptors(File metadataFile) throws PluginMetadataParseException {
        HashSet<MojoDescriptor> descriptors = new HashSet<MojoDescriptor>();
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)metadataFile);){
            PluginMetadataXpp3Reader metadataReader = new PluginMetadataXpp3Reader();
            PluginMetadata pluginMetadata = metadataReader.read((Reader)reader);
            List<Mojo> mojos = pluginMetadata.getMojos();
            if (mojos != null) {
                for (Mojo mojo : mojos) {
                    MojoDescriptor descriptor = this.asDescriptor(metadataFile, mojo);
                    descriptors.add(descriptor);
                }
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new PluginMetadataParseException(metadataFile, "Cannot parse plugin metadata from file.", e);
        }
        return descriptors;
    }

    private MojoDescriptor asDescriptor(File metadataFile, Mojo mojo) throws PluginMetadataParseException {
        List<Component> components;
        List<Parameter> parameters;
        MojoDescriptor descriptor = new MojoDescriptor();
        if (mojo.getCall() != null) {
            descriptor.setImplementation("<REPLACE-WITH-MOJO-PATH>:" + mojo.getCall());
        } else {
            descriptor.setImplementation(IMPL_BASE_PLACEHOLDER);
        }
        descriptor.setGoal(mojo.getGoal());
        descriptor.setPhase(mojo.getPhase());
        descriptor.setDependencyResolutionRequired(mojo.getRequiresDependencyResolution());
        descriptor.setAggregator(mojo.isAggregator());
        descriptor.setInheritedByDefault(mojo.isInheritByDefault());
        descriptor.setDirectInvocationOnly(mojo.isRequiresDirectInvocation());
        descriptor.setOnlineRequired(mojo.isRequiresOnline());
        descriptor.setProjectRequired(mojo.isRequiresProject());
        descriptor.setRequiresReports(mojo.isRequiresReports());
        descriptor.setDescription(mojo.getDescription());
        descriptor.setDeprecated(mojo.getDeprecation());
        descriptor.setSince(mojo.getSince());
        LifecycleExecution le = mojo.getExecution();
        if (le != null) {
            descriptor.setExecuteLifecycle(le.getLifecycle());
            descriptor.setExecutePhase(le.getPhase());
            descriptor.setExecuteGoal(le.getGoal());
        }
        if ((parameters = mojo.getParameters()) != null && !parameters.isEmpty()) {
            for (Parameter param : parameters) {
                org.apache.maven.plugin.descriptor.Parameter dParam = new org.apache.maven.plugin.descriptor.Parameter();
                dParam.setAlias(param.getAlias());
                dParam.setDeprecated(param.getDeprecation());
                dParam.setDescription(param.getDescription());
                dParam.setEditable(!param.isReadonly());
                dParam.setExpression(param.getExpression());
                dParam.setDefaultValue(param.getDefaultValue());
                dParam.setSince(param.getSince());
                String property = param.getProperty();
                if (StringUtils.isNotEmpty((String)property)) {
                    dParam.setName(property);
                } else {
                    dParam.setName(param.getName());
                }
                if (StringUtils.isEmpty((String)dParam.getName())) {
                    throw new PluginMetadataParseException(metadataFile, "Mojo: '" + mojo.getGoal() + "' has a parameter without either property or name attributes. Please specify one.");
                }
                dParam.setRequired(param.isRequired());
                dParam.setType(param.getType());
                try {
                    descriptor.addParameter(dParam);
                }
                catch (DuplicateParameterException e) {
                    throw new PluginMetadataParseException(metadataFile, "Duplicate parameters detected for mojo: " + mojo.getGoal(), e);
                }
            }
        }
        if ((components = mojo.getComponents()) != null && !components.isEmpty()) {
            for (Component component : components) {
                ComponentRequirement cr = new ComponentRequirement();
                cr.setRole(component.getRole());
                cr.setRoleHint(component.getHint());
                descriptor.addRequirement(cr);
            }
        }
        return descriptor;
    }
}

