/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.artifact.buildinfo.AbstractBuildinfoMojo;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="describe-build-output", aggregator=true, threadSafe=true)
public class DescribeBuildOutputMojo
extends AbstractBuildinfoMojo {
    private Path rootPath;
    private BuildInfoWriter bi;

    @Inject
    public DescribeBuildOutputMojo(ToolchainManager toolchainManager, RuntimeInformation rtInformation, MavenProject project, MavenSession session) {
        super(toolchainManager, rtInformation, project, session);
    }

    @Override
    public void execute() throws MojoExecutionException {
        Instant timestamp = MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).orElse(null);
        String effective = timestamp == null ? "disabled" : DateTimeFormatter.ISO_INSTANT.format(timestamp);
        DescribeBuildOutputMojo.diagnose(this.outputTimestamp, this.getLog(), this.project, this.session, effective);
        this.getLog().info((CharSequence)"");
        this.describeBuildOutput();
    }

    private void describeBuildOutput() throws MojoExecutionException {
        this.rootPath = this.session.getTopLevelProject().getBasedir().toPath();
        this.bi = this.newBuildInfoWriter(null, false);
        Map<MavenProject, Long> reactorParents = this.session.getProjects().stream().collect(Collectors.groupingBy(p -> DescribeBuildOutputMojo.getReactorParent(this.session, p), Collectors.counting()));
        reactorParents.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(e -> this.getLog().info((CharSequence)("parent in reactor: " + ((MavenProject)e.getKey()).getGroupId() + ":" + ((MavenProject)e.getKey()).getArtifactId() + " @ " + this.rootPath.relativize(((MavenProject)e.getKey()).getFile().toPath()) + " (" + e.getValue() + " module" + ((Long)e.getValue() > 1L ? "s" : "") + "), property = " + ((MavenProject)e.getKey()).getProperties().get("project.build.outputTimestamp"))));
        this.getLog().info((CharSequence)"");
        Map<String, Long> groupIds = this.session.getProjects().stream().collect(Collectors.groupingBy(MavenProject::getGroupId, Collectors.counting()));
        groupIds.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(e -> this.getLog().info((CharSequence)("groupId: " + (String)e.getKey() + " (" + e.getValue() + " artifactId" + ((Long)e.getValue() > 1L ? "s" : "") + ")")));
        Map artifactIds = this.session.getProjects().stream().collect(Collectors.groupingBy(MavenProject::getArtifactId, Collectors.mapping(MavenProject::getGroupId, Collectors.toSet())));
        artifactIds.entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(e -> ((Set)e.getValue()).size() > 1).forEach(e -> this.getLog().info((CharSequence)("artifactId: " + (String)e.getKey() + " defined for multiple groupIds: " + e.getValue())));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"skip/ignore? artifactId").strong((Object)"[:classifier][:extension]").a((CharSequence)" = build-path repository-filename size [sha256]").build());
        for (MavenProject p2 : this.session.getProjects()) {
            boolean skipped = this.isSkip(p2);
            String s = skipped ? (this.isSkipModule(p2) ? "skipped      " : "not-deployed ") : "             ";
            Artifact consumerPom = RepositoryUtils.toArtifacts((Collection)p2.getAttachedArtifacts()).stream().filter(a -> "pom".equals(a.getExtension()) && "consumer".equals(a.getClassifier())).findAny().orElse(null);
            DefaultArtifact pomArtifact = new DefaultArtifact(p2.getGroupId(), p2.getArtifactId(), null, "pom", p2.getVersion());
            if (consumerPom != null) {
                try {
                    Path pomFile = Files.createTempFile(Paths.get(p2.getBuild().getDirectory(), new String[0]), "consumer-", ".pom", new FileAttribute[0]);
                    Files.copy(consumerPom.getFile().toPath(), pomFile, StandardCopyOption.REPLACE_EXISTING);
                    pomArtifact = pomArtifact.setFile(pomFile.toFile());
                    this.getLog().info((CharSequence)(s + this.describeArtifact((Artifact)pomArtifact)));
                    pomArtifact = new DefaultArtifact(p2.getGroupId(), p2.getArtifactId(), "build", "pom", p2.getVersion());
                }
                catch (IOException e2) {
                    throw new MojoExecutionException("Error processing consumer POM", (Exception)e2);
                }
            }
            pomArtifact = pomArtifact.setFile(p2.getFile());
            this.getLog().info((CharSequence)(s + this.describeArtifact((Artifact)pomArtifact, skipped)));
            if (p2.getArtifact().getFile() != null) {
                this.getLog().info((CharSequence)(s + this.describeArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)p2.getArtifact()), skipped)));
            }
            for (Artifact a2 : RepositoryUtils.toArtifacts((Collection)p2.getAttachedArtifacts())) {
                boolean ignored;
                if ("pom".equals(a2.getExtension()) && "consumer".equals(a2.getClassifier())) continue;
                boolean bl = ignored = skipped ? false : this.isIgnore(a2);
                String i = skipped ? s : (ignored ? "RB-ignored   " : "             ");
                this.getLog().info((CharSequence)(i + this.describeArtifact(a2, skipped || ignored)));
            }
        }
    }

    private boolean isIgnore(Artifact a) {
        if (a.getExtension().endsWith(".asc")) {
            return true;
        }
        if (this.bi.getIgnoreJavadoc() && "javadoc".equals(a.getClassifier())) {
            return true;
        }
        return this.bi.isIgnore(a);
    }

    private String describeArtifact(Artifact a) throws MojoExecutionException {
        return this.describeArtifact(a, false);
    }

    private String describeArtifact(Artifact a, boolean skipped) throws MojoExecutionException {
        String sha256 = skipped ? "" : " " + this.sha256(a.getFile());
        String ce = ("".equals(a.getClassifier()) ? "" : ':' + a.getClassifier()) + ("jar".equals(a.getExtension()) ? "" : ":" + a.getExtension());
        String path = this.rootPath.relativize(a.getFile().toPath()).toString();
        int i = path.indexOf("target/");
        if (i >= 0) {
            path = MessageUtils.buffer().mojo((Object)path.substring(0, i + 7)).build() + path.substring(i + 7);
        }
        String remoteFilename = BuildInfoWriter.getArtifactFilename(a);
        return a.getArtifactId() + MessageUtils.buffer().strong((Object)ce) + " = " + path + " " + (path.endsWith(remoteFilename) ? "-" : MessageUtils.buffer().strong((Object)remoteFilename).build()) + " " + a.getFile().length() + sha256;
    }

    private String sha256(File file) throws MojoExecutionException {
        String string;
        block8: {
            InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                string = DigestUtils.sha256Hex((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("cannot read " + file, (Exception)ioe);
                }
            }
            is.close();
        }
        return string;
    }

    static MavenProject getReactorParent(MavenSession session, MavenProject project) {
        MavenProject reactorParent = project;
        while (session.getProjects().contains(reactorParent.getParent())) {
            reactorParent = reactorParent.getParent();
        }
        return reactorParent;
    }

    @Override
    public void execute(Map<Artifact, String> artifacts) throws MojoExecutionException {
    }
}

