/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AbstractUnpackingMojo;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AssemblyMojo
extends AbstractUnpackingMojo {
    private File[] descriptors;
    private String[] descriptorRefs;
    protected String descriptorId;
    protected File descriptor;
    private File basedir;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File tempRoot;
    private File siteDirectory;
    private boolean includeSite;
    private MavenArchiveConfiguration archive;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List assemblies = this.readAssemblies();
        Iterator i = assemblies.iterator();
        while (i.hasNext()) {
            Assembly assembly = (Assembly)i.next();
            this.createAssembly(assembly);
        }
    }

    private void createAssembly(Assembly assembly) throws MojoExecutionException, MojoFailureException {
        String fullName = this.finalName + "-" + assembly.getId();
        Iterator i = assembly.getFormats().iterator();
        while (i.hasNext()) {
            File destFile;
            String format = (String)i.next();
            String filename = fullName + "." + format;
            try {
                Archiver archiver = this.createArchiver(format);
                destFile = this.createArchive(archiver, assembly, filename);
            }
            catch (NoSuchArchiverException e) {
                throw new MojoFailureException("Unable to obtain archiver for extension '" + format + "'");
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating assembly", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating assembly", (Exception)e);
            }
            this.projectHelper.attachArtifact(this.project, format, assembly.getId(), destFile);
        }
    }

    protected File createArchive(Archiver archiver, Assembly assembly, String filename) throws ArchiverException, IOException, MojoExecutionException, MojoFailureException {
        this.processDependencySets(archiver, assembly.getDependencySets(), assembly.isIncludeBaseDirectory());
        this.processFileSets(archiver, assembly.getFileSets(), assembly.isIncludeBaseDirectory());
        File destFile = new File(this.outputDirectory, filename);
        if (archiver instanceof JarArchiver) {
            MavenArchiver mavenArchiver = new MavenArchiver();
            if (this.archive != null && this.archive.getManifest() != null) {
                try {
                    Manifest manifest = mavenArchiver.getManifest(this.project, this.archive.getManifest());
                    JarArchiver jarArchiver = (JarArchiver)archiver;
                    jarArchiver.addConfiguredManifest(manifest);
                }
                catch (ManifestException e) {
                    throw new MojoExecutionException("Error creating manifest: " + e.getMessage(), (Exception)((Object)e));
                }
                catch (DependencyResolutionRequiredException e) {
                    throw new MojoExecutionException("Dependencies were not resolved: " + e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        archiver.setDestFile(destFile);
        archiver.createArchive();
        return destFile;
    }

    protected List readAssemblies() throws MojoFailureException, MojoExecutionException {
        int i;
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        if (this.descriptor != null) {
            assemblies.add(this.getAssembly(this.descriptor));
        }
        if (this.descriptorId != null) {
            assemblies.add(this.getAssembly(this.descriptorId));
        }
        if (this.descriptors != null && this.descriptors.length > 0) {
            for (i = 0; i < this.descriptors.length; ++i) {
                assemblies.add(this.getAssembly(this.descriptors[i]));
            }
        }
        if (this.descriptorRefs != null && this.descriptorRefs.length > 0) {
            for (i = 0; i < this.descriptorRefs.length; ++i) {
                assemblies.add(this.getAssembly(this.descriptorRefs[i]));
            }
        }
        if (assemblies.isEmpty()) {
            throw new MojoFailureException("No assembly descriptors found.");
        }
        HashSet<String> ids = new HashSet<String>();
        Iterator i2 = assemblies.iterator();
        while (i2.hasNext()) {
            Assembly assembly = (Assembly)i2.next();
            if (ids.add(assembly.getId())) continue;
            throw new MojoFailureException("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    private Assembly getAssembly(String ref) throws MojoFailureException, MojoExecutionException {
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            throw new MojoFailureException("Descriptor with ID '" + ref + "' not found");
        }
        return this.getAssembly(new InputStreamReader(resourceAsStream));
    }

    private Assembly getAssembly(File file) throws MojoFailureException, MojoExecutionException {
        FileReader r;
        try {
            r = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Unable to find descriptor: " + e.getMessage());
        }
        return this.getAssembly(r);
    }

    private Assembly getAssembly(Reader reader) throws MojoExecutionException {
        Assembly assembly;
        try {
            AssemblyXpp3Reader r = new AssemblyXpp3Reader();
            assembly = r.read(reader);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (this.includeSite || assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly);
        }
        return assembly;
    }

    protected void processDependencySets(Archiver archiver, List dependencySets, boolean includeBaseDirectory) throws ArchiverException, IOException, MojoExecutionException, MojoFailureException {
        Iterator i = dependencySets.iterator();
        while (i.hasNext()) {
            DependencySet dependencySet = (DependencySet)i.next();
            String output = dependencySet.getOutputDirectory();
            output = this.getOutputDirectory(output, includeBaseDirectory);
            archiver.setDefaultDirectoryMode(Integer.parseInt(dependencySet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(dependencySet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("DependencySet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8)));
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter(dependencySet.getScope()));
            if (!dependencySet.getIncludes().isEmpty()) {
                filter.add((ArtifactFilter)new IncludesArtifactFilter(dependencySet.getIncludes()));
            }
            if (!dependencySet.getExcludes().isEmpty()) {
                filter.add((ArtifactFilter)new ExcludesArtifactFilter(dependencySet.getExcludes()));
            }
            Iterator j = this.dependencies.iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (!filter.include(artifact)) continue;
                String name = artifact.getFile().getName();
                if (dependencySet.isUnpack()) {
                    File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
                    boolean process = false;
                    if (!tempLocation.exists()) {
                        tempLocation.mkdirs();
                        process = true;
                    } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                        process = true;
                    }
                    if (process) {
                        try {
                            this.unpack(artifact.getFile(), tempLocation);
                        }
                        catch (NoSuchArchiverException e) {
                            throw new MojoExecutionException("Unable to obtain unarchiver for file '" + artifact.getFile() + "'");
                        }
                    }
                    archiver.addDirectory(tempLocation, output, null, FileUtils.getDefaultExcludes());
                    continue;
                }
                archiver.addFile(artifact.getFile(), output + AssemblyMojo.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), artifact));
            }
        }
    }

    protected void processFileSets(Archiver archiver, List fileSets, boolean includeBaseDirecetory) throws ArchiverException {
        Iterator i = fileSets.iterator();
        while (i.hasNext()) {
            FileSet fileSet = (FileSet)i.next();
            String directory = fileSet.getDirectory();
            String output = fileSet.getOutputDirectory();
            String lineEnding = AssemblyMojo.getLineEndingCharacters(fileSet.getLineEnding());
            File tmpDir = null;
            if (lineEnding != null) {
                tmpDir = FileUtils.createTempFile((String)"", (String)"", (File)this.tempRoot);
                tmpDir.mkdirs();
            }
            archiver.setDefaultDirectoryMode(Integer.parseInt(fileSet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(fileSet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("FileSet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding())));
            if (directory == null) {
                directory = this.basedir.getAbsolutePath();
                if (output == null) {
                    output = "";
                }
            } else if (output == null) {
                output = directory;
            }
            output = this.getOutputDirectory(output, includeBaseDirecetory);
            String[] includes = fileSet.getIncludes().toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            if (includes.length == 0) {
                includes = null;
            }
            List excludesList = fileSet.getExcludes();
            excludesList.addAll(FileUtils.getDefaultExcludesAsList());
            String[] excludes = excludesList.toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            File archiveBaseDir = new File(directory);
            if (lineEnding != null) {
                this.copySetReplacingLineEndings(archiveBaseDir, tmpDir, includes, excludes, lineEnding);
                archiveBaseDir = tmpDir;
            }
            archiver.addDirectory(archiveBaseDir, output, includes, excludes);
        }
    }

    private static String evaluateFileNameMapping(String expression, Artifact artifact) throws MojoExecutionException {
        Pattern pat = Pattern.compile("^(.*)\\$\\{([^\\}]+)\\}(.*)$");
        Matcher mat = pat.matcher(expression);
        if (mat.matches()) {
            Object middle;
            String left = AssemblyMojo.evaluateFileNameMapping(mat.group(1), artifact);
            try {
                middle = ReflectionValueExtractor.evaluate((String)("dep." + mat.group(2)), (Object)artifact);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot evaluate filenameMapping", e);
            }
            String right = mat.group(3);
            if (middle == null) {
                if ("extension".equals(mat.group(2).trim())) {
                    ArtifactHandler artifactHandler = artifact.getArtifactHandler();
                    middle = artifactHandler.getExtension();
                } else {
                    middle = "${" + mat.group(2) + "}";
                }
            }
            return left + middle + right;
        }
        return expression;
    }

    private String getOutputDirectory(String output, boolean includeBaseDirectory) {
        if (output == null) {
            output = "";
        }
        if (!output.endsWith("/") && !output.endsWith("\\")) {
            output = output + '/';
        }
        if (includeBaseDirectory) {
            output = output.startsWith("/") ? this.finalName + output : this.finalName + "/" + output;
        } else if (output.startsWith("/")) {
            output = output.substring(1);
        }
        return output;
    }

    private Archiver createArchiver(String format) throws ArchiverException, NoSuchArchiverException {
        Archiver archiver;
        if (format.startsWith("tar")) {
            TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
            archiver = tarArchiver;
            int index = format.indexOf(46);
            if (index >= 0) {
                TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
                String compression = format.substring(index + 1);
                if ("gz".equals(compression)) {
                    tarCompressionMethod.setValue("gzip");
                } else if ("bz2".equals(compression)) {
                    tarCompressionMethod.setValue("bzip2");
                } else {
                    throw new IllegalArgumentException("Unknown compression format: " + compression);
                }
                tarArchiver.setCompression(tarCompressionMethod);
            }
        } else {
            archiver = this.archiverManager.getArchiver(format);
        }
        return archiver;
    }

    private void copyReplacingLineEndings(File source, File dest, String lineEndings) throws IOException {
        String line;
        this.getLog().debug((CharSequence)("Copying while replacing line endings: " + source + " to " + dest));
        BufferedReader in = new BufferedReader(new FileReader(source));
        BufferedWriter out = new BufferedWriter(new FileWriter(dest));
        while ((line = in.readLine()) != null) {
            out.write(line);
            out.write(lineEndings);
        }
        out.flush();
        out.close();
    }

    private void copySetReplacingLineEndings(File archiveBaseDir, File tmpDir, String[] includes, String[] excludes, String lineEnding) throws ArchiverException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(archiveBaseDir.getAbsolutePath());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(this.tempRoot, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File targetFile = new File(tmpDir, files[j]);
            try {
                targetFile.getParentFile().mkdirs();
                this.copyReplacingLineEndings(new File(archiveBaseDir, files[j]), targetFile, lineEnding);
                continue;
            }
            catch (IOException e) {
                throw new ArchiverException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Throwable)e);
            }
        }
    }

    private static String getLineEndingCharacters(String lineEnding) throws ArchiverException {
        if (lineEnding != null) {
            if ("keep".equals(lineEnding)) {
                lineEnding = null;
            } else if ("dos".equals(lineEnding) || "crlf".equals(lineEnding)) {
                lineEnding = "\r\n";
            } else if ("unix".equals(lineEnding) || "lf".equals(lineEnding)) {
                lineEnding = "\n";
            } else {
                throw new ArchiverException("Illlegal lineEnding specified: '" + lineEnding + "'");
            }
        }
        return lineEnding;
    }

    private void includeSiteInAssembly(Assembly assembly) throws MojoExecutionException {
        if (!this.siteDirectory.exists()) {
            throw new MojoExecutionException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLog().info((CharSequence)("Adding site directory to assembly : " + this.siteDirectory));
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(this.siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }
}

