/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Assembly.
 * 
 * @version $Revision$ $Date$
 */
public class Assembly implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field formats
     */
    private java.util.List formats;

    /**
     * Field includeBaseDirectory
     */
    private boolean includeBaseDirectory = true;

    /**
     * Field fileSets
     */
    private java.util.List fileSets;

    /**
     * Field dependencySets
     */
    private java.util.List dependencySets;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependencySet
     * 
     * @param dependencySet
     */
    public void addDependencySet(DependencySet dependencySet)
    {
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet(DependencySet) 

    /**
     * Method addFileSet
     * 
     * @param fileSet
     */
    public void addFileSet(FileSet fileSet)
    {
        getFileSets().add( fileSet );
    } //-- void addFileSet(FileSet) 

    /**
     * Method addFormat
     * 
     * @param string
     */
    public void addFormat(String string)
    {
        getFormats().add( string );
    } //-- void addFormat(String) 

    /**
     * Method getDependencySets
     */
    public java.util.List getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList();
        }
        
        return this.dependencySets;
    } //-- java.util.List getDependencySets() 

    /**
     * Method getFileSets
     */
    public java.util.List getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList();
        }
        
        return this.fileSets;
    } //-- java.util.List getFileSets() 

    /**
     * Method getFormats
     */
    public java.util.List getFormats()
    {
        if ( this.formats == null )
        {
            this.formats = new java.util.ArrayList();
        }
        
        return this.formats;
    } //-- java.util.List getFormats() 

    /**
     * Method getId
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method isIncludeBaseDirectory
     */
    public boolean isIncludeBaseDirectory()
    {
        return this.includeBaseDirectory;
    } //-- boolean isIncludeBaseDirectory() 

    /**
     * Method removeDependencySet
     * 
     * @param dependencySet
     */
    public void removeDependencySet(DependencySet dependencySet)
    {
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet(DependencySet) 

    /**
     * Method removeFileSet
     * 
     * @param fileSet
     */
    public void removeFileSet(FileSet fileSet)
    {
        getFileSets().remove( fileSet );
    } //-- void removeFileSet(FileSet) 

    /**
     * Method removeFormat
     * 
     * @param string
     */
    public void removeFormat(String string)
    {
        getFormats().remove( string );
    } //-- void removeFormat(String) 

    /**
     * Method setDependencySets
     * 
     * @param dependencySets
     */
    public void setDependencySets(java.util.List dependencySets)
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets(java.util.List) 

    /**
     * Method setFileSets
     * 
     * @param fileSets
     */
    public void setFileSets(java.util.List fileSets)
    {
        this.fileSets = fileSets;
    } //-- void setFileSets(java.util.List) 

    /**
     * Method setFormats
     * 
     * @param formats
     */
    public void setFormats(java.util.List formats)
    {
        this.formats = formats;
    } //-- void setFormats(java.util.List) 

    /**
     * Method setId
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Method setIncludeBaseDirectory
     * 
     * @param includeBaseDirectory
     */
    public void setIncludeBaseDirectory(boolean includeBaseDirectory)
    {
        this.includeBaseDirectory = includeBaseDirectory;
    } //-- void setIncludeBaseDirectory(boolean) 

}
