/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AbstractUnpackingMojo;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class UnpackMojo
extends AbstractUnpackingMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator j = this.dependencies.iterator();
        while (j.hasNext()) {
            Artifact artifact = (Artifact)j.next();
            String name = artifact.getFile().getName();
            File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
            boolean process = false;
            if (!tempLocation.exists()) {
                tempLocation.mkdirs();
                process = true;
            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                process = true;
            }
            if (!process) continue;
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
    }
}

