/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class FileSet extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field directory
     */
    private String directory;

    /**
     * Field lineEnding
     */
    private String lineEnding;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Absolute or relative from the module's
     * directory. For
     *             example, "src/main/bin" would select this
     * subdirectory
     *             of the project in which this dependency is
     * defined.
     *           
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory() 

    /**
     * Get 
     *             
     *             Controls the line-endings of files in this
     * fileSet.
     *             Valid values: 
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding() 

    /**
     * Set 
     *             Absolute or relative from the module's
     * directory. For
     *             example, "src/main/bin" would select this
     * subdirectory
     *             of the project in which this dependency is
     * defined.
     *           
     * 
     * @param directory
     */
    public void setDirectory(String directory)
    {
        this.directory = directory;
    } //-- void setDirectory(String) 

    /**
     * Set 
     *             
     *             Controls the line-endings of files in this
     * fileSet.
     *             Valid values: 
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     * 
     * @param lineEnding
     */
    public void setLineEnding(String lineEnding)
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
