/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A file allows individual file inclusion with the option
 * to change
 *         the destination filename not supported by fileSets.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class FileItem implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field source
     */
    private String source;

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field destName
     */
    private String destName;

    /**
     * Field fileMode
     */
    private String fileMode = "0644";

    /**
     * Field lineEnding
     */
    private String lineEnding;

    /**
     * Field filtered
     */
    private boolean filtered = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Sets the destination filename in the
     * outputDirectory.
     *             Default is the same name as the source's file.
     *           
     */
    public String getDestName()
    {
        return this.destName;
    } //-- String getDestName() 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * default value of 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode() 

    /**
     * Get 
     *             
     *             Sets the line-endings of the files in this file.
     *             Valid values are:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding() 

    /**
     * Get 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Get 
     *             Sets the absolute or relative path from the
     * module's directory
     *             of the file to be included in the assembly.
     *           
     */
    public String getSource()
    {
        return this.source;
    } //-- String getSource() 

    /**
     * Get 
     *             Sets whether to determine if the file is
     * filtered.
     *           
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered() 

    /**
     * Set 
     *             Sets the destination filename in the
     * outputDirectory.
     *             Default is the same name as the source's file.
     *           
     * 
     * @param destName
     */
    public void setDestName(String destName)
    {
        this.destName = destName;
    } //-- void setDestName(String) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * default value of 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     * 
     * @param fileMode
     */
    public void setFileMode(String fileMode)
    {
        this.fileMode = fileMode;
    } //-- void setFileMode(String) 

    /**
     * Set 
     *             Sets whether to determine if the file is
     * filtered.
     *           
     * 
     * @param filtered
     */
    public void setFiltered(boolean filtered)
    {
        this.filtered = filtered;
    } //-- void setFiltered(boolean) 

    /**
     * Set 
     *             
     *             Sets the line-endings of the files in this file.
     *             Valid values are:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     * 
     * @param lineEnding
     */
    public void setLineEnding(String lineEnding)
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding(String) 

    /**
     * Set 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Set 
     *             Sets the absolute or relative path from the
     * module's directory
     *             of the file to be included in the assembly.
     *           
     * 
     * @param source
     */
    public void setSource(String source)
    {
        this.source = source;
    } //-- void setSource(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
