/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Defines a Maven repository to be included in the assembly.
 * 
 * @version $Revision$ $Date$
 */
public class GroupVersionAlignment implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field version
     */
    private String version;

    /**
     * Field excludes
     */
    private java.util.List excludes;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "GroupVersionAlignment.addExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method getExcludes
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Get The groupId for which you want to align the versions.
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get The version you want to align this group to.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeExclude
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "GroupVersionAlignment.removeExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Set Artifact Ids of the artifacts you want excluded from
     * version alignment.
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Set The groupId for which you want to align the versions.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set The version you want to align this group to.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
