/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Defines a Maven repository to be included in the assembly.
 * 
 * @version $Revision$ $Date$
 */
public class Repository extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includeMetadata
     */
    private boolean includeMetadata = false;

    /**
     * Field groupVersionAlignments
     */
    private java.util.List groupVersionAlignments;

    /**
     * Field scope
     */
    private String scope = "runtime";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGroupVersionAlignment
     * 
     * @param groupVersionAlignment
     */
    public void addGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment)
    {
        if ( !(groupVersionAlignment instanceof GroupVersionAlignment) )
        {
            throw new ClassCastException( "Repository.addGroupVersionAlignments(groupVersionAlignment) parameter must be instanceof " + GroupVersionAlignment.class.getName() );
        }
        getGroupVersionAlignments().add( groupVersionAlignment );
    } //-- void addGroupVersionAlignment(GroupVersionAlignment) 

    /**
     * Method getGroupVersionAlignments
     */
    public java.util.List getGroupVersionAlignments()
    {
        if ( this.groupVersionAlignments == null )
        {
            this.groupVersionAlignments = new java.util.ArrayList();
        }
        
        return this.groupVersionAlignments;
    } //-- java.util.List getGroupVersionAlignments() 

    /**
     * Get 
     *             Specifies the scope for artifacts included in
     * this repository.
     *             Default scope value is "runtime".
     *           
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get 
     *             If set to true, this property will trigger the
     * creation of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository.
     *           
     */
    public boolean isIncludeMetadata()
    {
        return this.includeMetadata;
    } //-- boolean isIncludeMetadata() 

    /**
     * Method removeGroupVersionAlignment
     * 
     * @param groupVersionAlignment
     */
    public void removeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment)
    {
        if ( !(groupVersionAlignment instanceof GroupVersionAlignment) )
        {
            throw new ClassCastException( "Repository.removeGroupVersionAlignments(groupVersionAlignment) parameter must be instanceof " + GroupVersionAlignment.class.getName() );
        }
        getGroupVersionAlignments().remove( groupVersionAlignment );
    } //-- void removeGroupVersionAlignment(GroupVersionAlignment) 

    /**
     * Set Align a group to a version or an individual artifact.
     * 
     * @param groupVersionAlignments
     */
    public void setGroupVersionAlignments(java.util.List groupVersionAlignments)
    {
        this.groupVersionAlignments = groupVersionAlignments;
    } //-- void setGroupVersionAlignments(java.util.List) 

    /**
     * Set 
     *             If set to true, this property will trigger the
     * creation of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository.
     *           
     * 
     * @param includeMetadata
     */
    public void setIncludeMetadata(boolean includeMetadata)
    {
        this.includeMetadata = includeMetadata;
    } //-- void setIncludeMetadata(boolean) 

    /**
     * Set 
     *             Specifies the scope for artifacts included in
     * this repository.
     *             Default scope value is "runtime".
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
