/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.interpolation;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Writer;
import org.apache.maven.plugin.assembly.utils.CommandLineUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AssemblyInterpolator
extends AbstractLogEnabled {
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("\\<([^> ]+)[^>]*>([^<]+)");
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.|env\\.)?([^}]+)\\}");
    private static final Map INTERPOLATION_BLACKLIST;
    private Properties envars;

    public AssemblyInterpolator(Properties envars) {
        this.envars = envars;
    }

    public AssemblyInterpolator() throws IOException {
        this.envars = CommandLineUtils.getSystemEnvVars(false);
    }

    public Assembly interpolate(Assembly assembly, MavenProject project, Map context) throws AssemblyInterpolationException {
        return this.interpolate(assembly, project, context, true);
    }

    public Assembly interpolate(Assembly assembly, MavenProject project, Map context, boolean strict) throws AssemblyInterpolationException {
        StringWriter sWriter = new StringWriter();
        AssemblyXpp3Writer writer = new AssemblyXpp3Writer();
        try {
            writer.write(sWriter, assembly);
        }
        catch (IOException e) {
            throw new AssemblyInterpolationException("Cannot serialize assembly descriptor for interpolation.", e);
        }
        String serializedAssembly = sWriter.toString();
        serializedAssembly = this.interpolateInternal(serializedAssembly, assembly, project, context);
        StringReader sReader = new StringReader(serializedAssembly);
        AssemblyXpp3Reader assemblyReader = new AssemblyXpp3Reader();
        try {
            assembly = assemblyReader.read(sReader);
        }
        catch (IOException e) {
            throw new AssemblyInterpolationException("Cannot read assembly descriptor from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new AssemblyInterpolationException("Cannot read assembly descriptor from interpolating filter of serialized version.", e);
        }
        return assembly;
    }

    private String interpolateInternal(String src, Assembly assembly, MavenProject project, Map context) throws AssemblyInterpolationException {
        String result = src;
        Matcher elementMatcher = ELEMENT_PATTERN.matcher(result);
        while (elementMatcher.find()) {
            String element = elementMatcher.group(0);
            String elementName = elementMatcher.group(1);
            String value = elementMatcher.group(2);
            if (!StringUtils.isNotEmpty((String)value) || value.indexOf("${") <= -1) continue;
            List blacklistedExpressions = (List)INTERPOLATION_BLACKLIST.get(elementName);
            if (blacklistedExpressions == null) {
                blacklistedExpressions = Collections.EMPTY_LIST;
            }
            String interpolatedValue = this.interpolateElementValue(value, assembly, project, context, blacklistedExpressions);
            String modifiedElement = StringUtils.replace((String)element, (String)value, (String)interpolatedValue);
            result = StringUtils.replace((String)result, (String)element, (String)modifiedElement);
        }
        return result;
    }

    private String interpolateElementValue(String src, Assembly assembly, MavenProject project, Map context, List blacklistedExpressions) throws AssemblyInterpolationException {
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            Object value;
            String realExpr;
            String wholeExpr;
            block7: {
                wholeExpr = matcher.group(0);
                realExpr = matcher.group(2);
                if (blacklistedExpressions.contains(realExpr)) continue;
                value = context.get(realExpr);
                if (value == null) {
                    value = project.getProperties().getProperty(realExpr);
                }
                if (value == null) {
                    try {
                        value = ReflectionValueExtractor.evaluate((String)realExpr, (Object)project);
                    }
                    catch (Exception e) {
                        Logger logger = this.getLogger();
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("Assembly descriptor interpolation cannot proceed with expression: " + wholeExpr + ". Skipping...", (Throwable)e);
                    }
                }
            }
            if (value == null) {
                value = this.envars.getProperty(realExpr);
            }
            if (wholeExpr.equals(value)) {
                throw new AssemblyInterpolationException(wholeExpr, assembly.getId() + " references itself.");
            }
            if (value == null) continue;
            result = StringUtils.replace((String)result, (String)wholeExpr, (String)String.valueOf(value));
            matcher.reset(result);
        }
        return result;
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "interpolator-internal");
            this.enableLogging(logger);
        }
        return logger;
    }

    static {
        HashMap blacklist = new HashMap();
        ArrayList<String> ofnmBlacklistings = new ArrayList<String>();
        ofnmBlacklistings.add("groupId");
        ofnmBlacklistings.add("artifactId");
        ofnmBlacklistings.add("version");
        blacklist.put("outputFileNameMapping", ofnmBlacklistings);
        blacklist.put("outputDirectoryMapping", ofnmBlacklistings);
        ArrayList<String> odBlacklist = new ArrayList<String>();
        odBlacklist.add("groupId");
        odBlacklist.add("artifactId");
        odBlacklist.add("version");
        odBlacklist.add("build.finalName");
        odBlacklist.add("finalName");
        blacklist.put("outputDirectory", odBlacklist);
        INTERPOLATION_BLACKLIST = blacklist;
    }
}

