/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.PropertiesInterpolationValueSource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;

public final class AssemblyFormatUtils {
    private AssemblyFormatUtils() {
    }

    public static String getDistributionName(Assembly assembly, AssemblerConfigurationSource configSource) {
        String finalName = configSource.getFinalName();
        boolean appendAssemblyId = configSource.isAssemblyIdAppended();
        String classifier = configSource.getClassifier();
        String distributionName = finalName;
        if (appendAssemblyId) {
            if (!StringUtils.isEmpty((String)assembly.getId())) {
                distributionName = finalName + "-" + assembly.getId();
            }
        } else if (classifier != null) {
            distributionName = finalName + "-" + classifier;
        }
        return distributionName;
    }

    public static String getOutputDirectory(String output, MavenProject project, String finalName) {
        String value = output;
        if (value == null) {
            value = "";
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        Properties specialExpressionOverrides = new Properties();
        if (finalName != null) {
            specialExpressionOverrides.setProperty("finalName", finalName);
            specialExpressionOverrides.setProperty("build.finalName", finalName);
        }
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(specialExpressionOverrides));
        if (project != null) {
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)project));
        }
        if ((value = interpolator.interpolate(value, "__project")).length() > 0 && !value.endsWith("/") && !value.endsWith("\\")) {
            value = value + "/";
        }
        if (value.length() > 0 && (value.startsWith("/") || value.startsWith("\\"))) {
            value = value.substring(1);
        }
        return value;
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact) throws AssemblyFormattingException {
        String value = expression;
        artifact.isSnapshot();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact));
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact.getArtifactHandler()));
        Properties classifierMask = new Properties();
        classifierMask.setProperty("classifier", "");
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(classifierMask));
        value = interpolator.interpolate(value, "__artifact");
        return value;
    }
}

