/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.FileFormatter;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

public class FileSetFormatter {
    private final AssemblerConfigurationSource configSource;
    private final Logger logger;

    public FileSetFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    public File formatFileSetForAssembly(File archiveBaseDir, FileSet set) throws AssemblyFormattingException, IOException {
        String lineEndingHint = set.getLineEnding();
        String lineEnding = AssemblyFileUtils.getLineEndingCharacters(lineEndingHint);
        if (lineEnding != null || set.isFiltered()) {
            org.apache.maven.shared.model.fileset.FileSet fileSet = new org.apache.maven.shared.model.fileset.FileSet();
            fileSet.setLineEnding(lineEnding);
            fileSet.setDirectory(set.getDirectory());
            fileSet.setIncludes(set.getIncludes());
            fileSet.setExcludes(set.getExcludes());
            fileSet.setUseDefaultExcludes(true);
            FileSetManager fsm = new FileSetManager(this.logger);
            String[] files = fsm.getIncludedFiles(fileSet);
            if (files == null || files.length == 0) {
                this.logger.info("No files selected for line-ending conversion. Skipping: " + fileSet.getDirectory());
            } else {
                File formattedDir = FileUtils.createTempFile((String)"fileSetFormatter.", (String)".tmp", (File)this.configSource.getTemporaryRootDirectory());
                formattedDir.delete();
                formattedDir.mkdirs();
                FileFormatter fileFormatter = new FileFormatter(this.configSource, this.logger);
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    File targetFile = new File(formattedDir, file);
                    targetFile.getParentFile().mkdirs();
                    File sourceFile = new File(archiveBaseDir, file);
                    try {
                        sourceFile = fileFormatter.format(sourceFile, set.isFiltered(), lineEndingHint, formattedDir);
                        AssemblyFileUtils.copyFile(sourceFile, targetFile);
                        continue;
                    }
                    catch (AssemblyFormattingException e) {
                        FileSetFormatter.deleteDirectory(formattedDir);
                        throw e;
                    }
                    catch (IOException e) {
                        FileSetFormatter.deleteDirectory(formattedDir);
                        throw e;
                    }
                }
                return formattedDir;
            }
        }
        return archiveBaseDir;
    }

    private static void deleteDirectory(File formattedDir) {
        try {
            FileUtils.deleteDirectory((File)formattedDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

