package org.apache.maven.plugin.assembly.mojos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-assembly-plugin.<br/> Call <pre>  mvn assembly:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Dec 17 18:44:36 EST 2008
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.4.3)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-assembly-plugin:2.2-beta-3", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Assembly Plugin 2.2-beta-3", 0 );
        append( sb, "A Maven 2 plugin to create archives of your project\'s sources, classes, dependencies etc. from flexible assembly descriptors.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 8 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "assembly".equals( goal ) )
        {
            append( sb, "assembly:assembly", 0 );
            append( sb, "Assemble an application bundle or distribution using an assembly descriptor from the command line. This goal will force Maven to build all included POMs up to the package phase BEFORE the assembly is processed.\nNOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:single goal for binding your assembly to the lifecycle.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "executedProject", 2 );
                append( sb, "Get the executed project from the forked lifecycle.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "attached".equals( goal ) )
        {
            append( sb, "assembly:attached", 0 );
            append( sb, "Deprecated. Use goal: \'assembly\' (from the command line) or \'single\' (from a lifecycle binding) instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Assemble an application bundle or distribution from an assembly descriptor, WITHOUT first forcing Maven to build all POMs to the package phase (as is required by the assembly:assembly goal).\nNOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:single goal for binding your assembly to the lifecycle.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "directory".equals( goal ) )
        {
            append( sb, "assembly:directory", 0 );
            append( sb, "Like the assembly:attached goal, assemble an application bundle or distribution using an assembly descriptor from the command line. This goal will force Maven to build all included POMs up to the package phase BEFORE the assembly is processed. This goal differs from assembly:assembly in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project\'s build-output directory (usually ./target).\nThis goal is also functionally equivalent to using the assembly:assembly goal in conjunction with the dir assembly format.\nNOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:directory-single goal for binding your assembly to the lifecycle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "executedProject", 2 );
                append( sb, "Get the executed project from the forked lifecycle.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "directory-inline".equals( goal ) )
        {
            append( sb, "assembly:directory-inline", 0 );
            append( sb, "Deprecated. Use goal: \'directory\' (from the command line) or \'directory-single\' (from a lifecycle binding) instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Like the assembly:attached goal, assemble an application bundle or distribution from an assembly descriptor, WITHOUT first forcing Maven to build all POMs to the package phase (as is required by the assembly:assembly goal). This goal differs from assembly:attached in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project\'s build-output directory (usually ./target).\nThis goal is also functionally equivalent to using the assembly:attached goal in conjunction with the dir assembly format.\nNOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:directory-single goal for binding your assembly to the lifecycle.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "directory-single".equals( goal ) )
        {
            append( sb, "assembly:directory-single", 0 );
            append( sb, "Like the assembly:attached goal, assemble an application bundle or distribution from an assembly descriptor. This goal is suitable either for binding to the lifecycle or calling directly from the command line (provided all required files are available before the build starts, or are produced by another goal specified before this one on the command line).\nThis goal differs from assembly:single in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project\'s build-output directory (usually ./target).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "assembly:help", 0 );
            append( sb, "Display help information on maven-assembly-plugin.\nCall\n\u00a0\u00a0mvn\u00a0assembly:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "single".equals( goal ) )
        {
            append( sb, "assembly:single", 0 );
            append( sb, "Assemble an application bundle or distribution from an assembly descriptor. This goal is suitable either for binding to the lifecycle or calling directly from the command line (provided all required files are available before the build starts, or are produced by another goal specified before this one on the command line).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendAssemblyId (Default: true)", 2 );
                append( sb, "Set to false to exclude the assembly id from the assembly final name.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "This is a set of instructions to the archive builder, especially for building .jar files. It enables you to specify a Manifest file for the jar, in addition to other options.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveBaseDirectory", 2 );
                append( sb, "This is the base directory from which archive files are created. This base directory pre-pended to any <directory> specifications in the assembly descriptor. This is an optional parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "archiverConfig", 2 );
                append( sb, "Allows additional configuration options that are specific to a particular type of archive format. This is intended to capture an XML configuration that will be used to reflectively setup the options on the archiver instance.\nFor instance, to direct an assembly with the \'ear\' format to use a particular appXml file, you should specify the following for the archiverConfig value in your plugin configuration:\n\n<appXml>${project.basedir}/somepath/app.xml</appXml>\n", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Controls whether the assembly plugin tries to attach the resulting assembly to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Deprecated. Please use the Assembly\'s id for classifier instead", 3 );
                append( sb, "", 0 );
                append( sb, "This is the artifact classifier to be used for the resultant assembly artifact. Normally, you would use the assembly-id instead of specifying this here.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor", 2 );
                append( sb, "Deprecated. Please use descriptors instead", 3 );
                append( sb, "", 0 );
                append( sb, "Assembly XML Descriptor file. This must be the path to your customized descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorId", 2 );
                append( sb, "Deprecated. Please use descriptorRefs instead", 3 );
                append( sb, "", 0 );
                append( sb, "Predefined Assembly Descriptor Id\'s. You can select bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorRefs", 2 );
                append( sb, "A list of built-in descriptor references to generate from. You can select from bin, jar-with-dependencies, or src.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptorSourceDirectory", 2 );
                append( sb, "Directory to scan for descriptor files in.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptors", 2 );
                append( sb, "A list of descriptor files to generate from.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "If this flag is set, everything up to the call to Archiver.createArchive() will be executed.", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirFormatExtensions (Default: true)", 2 );
                append( sb, "If this flag is set, the \'.dir\' suffix will be suppressed in the output directory name when using assembly/format == \'dir\' and other formats that begin with \'dir\'.\nNOTE: Since 2.2-beta-3, the default-value for this is true, NOT false as it used to be.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreMissingDescriptor (Default: false)", 2 );
                append( sb, "Set to true in order to not fail when a descriptor is missing.", 3 );
                append( sb, "", 0 );

                append( sb, "includeSite (Default: false)", 2 );
                append( sb, "Deprecated. Please set this variable in the assembly descriptor instead", 3 );
                append( sb, "", 0 );
                append( sb, "Set to true to include the site generated by site:site goal.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The output directory of the assembled distribution file.", 3 );
                append( sb, "", 0 );

                append( sb, "skipAssembly (Default: false)", 2 );
                append( sb, "Flag allowing one or more executions of the assembly plugin to be configured as skipped for a particular build. This makes the assembly plugin more controllable from profiles.", 3 );
                append( sb, "", 0 );

                append( sb, "tarLongFileMode (Default: warn)", 2 );
                append( sb, "Sets the TarArchiver behavior on file paths with more than 100 characters length. Valid values are: \'warn\' (default), \'fail\', \'truncate\', \'gnu\', or \'omit\'.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/assembly/work)", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "unpack".equals( goal ) )
        {
            append( sb, "assembly:unpack", 0 );
            append( sb, "Deprecated. Use org.apache.maven.plugins:maven-dependency-plugin goal: unpack or unpack-dependencies instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Unpack project dependencies. Currently supports dependencies of type jar and zip.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "workDirectory", 2 );
                append( sb, "Directory to unpack JARs into if needed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
