/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.SetBase;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ComponentXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Component component) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(component.getModelEncoding(), null);
        this.writeComponent(component, "component", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeComponent(Component component, String tagName, XmlSerializer serializer) throws IOException {
        if (component != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (component.getFileSets() != null && component.getFileSets().size() > 0) {
                serializer.startTag(NAMESPACE, "fileSets");
                iter = component.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(NAMESPACE, "fileSets");
            }
            if (component.getFiles() != null && component.getFiles().size() > 0) {
                serializer.startTag(NAMESPACE, "files");
                iter = component.getFiles().iterator();
                while (iter.hasNext()) {
                    o = (FileItem)iter.next();
                    this.writeFileItem((FileItem)o, "file", serializer);
                }
                serializer.endTag(NAMESPACE, "files");
            }
            if (component.getDependencySets() != null && component.getDependencySets().size() > 0) {
                serializer.startTag(NAMESPACE, "dependencySets");
                iter = component.getDependencySets().iterator();
                while (iter.hasNext()) {
                    o = (DependencySet)iter.next();
                    this.writeDependencySet((DependencySet)o, "dependencySet", serializer);
                }
                serializer.endTag(NAMESPACE, "dependencySets");
            }
            if (component.getRepositories() != null && component.getRepositories().size() > 0) {
                serializer.startTag(NAMESPACE, "repositories");
                iter = component.getRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "repository", serializer);
                }
                serializer.endTag(NAMESPACE, "repositories");
            }
            if (component.getContainerDescriptorHandlers() != null && component.getContainerDescriptorHandlers().size() > 0) {
                serializer.startTag(NAMESPACE, "containerDescriptorHandlers");
                iter = component.getContainerDescriptorHandlers().iterator();
                while (iter.hasNext()) {
                    o = (ContainerDescriptorHandlerConfig)iter.next();
                    this.writeContainerDescriptorHandlerConfig((ContainerDescriptorHandlerConfig)o, "containerDescriptorHandler", serializer);
                }
                serializer.endTag(NAMESPACE, "containerDescriptorHandlers");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeContainerDescriptorHandlerConfig(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig, String tagName, XmlSerializer serializer) throws IOException {
        if (containerDescriptorHandlerConfig != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (containerDescriptorHandlerConfig.getHandlerName() != null) {
                serializer.startTag(NAMESPACE, "handlerName").text(containerDescriptorHandlerConfig.getHandlerName()).endTag(NAMESPACE, "handlerName");
            }
            if (containerDescriptorHandlerConfig.getConfiguration() != null) {
                ((Xpp3Dom)containerDescriptorHandlerConfig.getConfiguration()).writeToSerializer(NAMESPACE, serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer) throws IOException {
        if (dependencySet != null) {
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals("${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}")) {
                serializer.startTag(NAMESPACE, "outputFileNameMapping").text(dependencySet.getOutputFileNameMapping()).endTag(NAMESPACE, "outputFileNameMapping");
            }
            if (dependencySet.isUnpack()) {
                serializer.startTag(NAMESPACE, "unpack").text(String.valueOf(dependencySet.isUnpack())).endTag(NAMESPACE, "unpack");
            }
            if (dependencySet.getUnpackOptions() != null) {
                this.writeUnpackOptions(dependencySet.getUnpackOptions(), "unpackOptions", serializer);
            }
            if (dependencySet.getScope() != null && !dependencySet.getScope().equals("runtime")) {
                serializer.startTag(NAMESPACE, "scope").text(dependencySet.getScope()).endTag(NAMESPACE, "scope");
            }
            if (!dependencySet.isUseProjectArtifact()) {
                serializer.startTag(NAMESPACE, "useProjectArtifact").text(String.valueOf(dependencySet.isUseProjectArtifact())).endTag(NAMESPACE, "useProjectArtifact");
            }
            if (dependencySet.isUseProjectAttachments()) {
                serializer.startTag(NAMESPACE, "useProjectAttachments").text(String.valueOf(dependencySet.isUseProjectAttachments())).endTag(NAMESPACE, "useProjectAttachments");
            }
            if (!dependencySet.isUseTransitiveDependencies()) {
                serializer.startTag(NAMESPACE, "useTransitiveDependencies").text(String.valueOf(dependencySet.isUseTransitiveDependencies())).endTag(NAMESPACE, "useTransitiveDependencies");
            }
            if (dependencySet.isUseTransitiveFiltering()) {
                serializer.startTag(NAMESPACE, "useTransitiveFiltering").text(String.valueOf(dependencySet.isUseTransitiveFiltering())).endTag(NAMESPACE, "useTransitiveFiltering");
            }
            if (dependencySet.isUseStrictFiltering()) {
                serializer.startTag(NAMESPACE, "useStrictFiltering").text(String.valueOf(dependencySet.isUseStrictFiltering())).endTag(NAMESPACE, "useStrictFiltering");
            }
            if (!dependencySet.isUseDefaultExcludes()) {
                serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(dependencySet.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
            }
            if (dependencySet.getOutputDirectory() != null) {
                serializer.startTag(NAMESPACE, "outputDirectory").text(dependencySet.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
            }
            if (dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0) {
                serializer.startTag(NAMESPACE, "includes");
                iter = dependencySet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
                }
                serializer.endTag(NAMESPACE, "includes");
            }
            if (dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                iter = dependencySet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            if (dependencySet.getFileMode() != null) {
                serializer.startTag(NAMESPACE, "fileMode").text(dependencySet.getFileMode()).endTag(NAMESPACE, "fileMode");
            }
            if (dependencySet.getDirectoryMode() != null) {
                serializer.startTag(NAMESPACE, "directoryMode").text(dependencySet.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeFileItem(FileItem fileItem, String tagName, XmlSerializer serializer) throws IOException {
        if (fileItem != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (fileItem.getSource() != null) {
                serializer.startTag(NAMESPACE, "source").text(fileItem.getSource()).endTag(NAMESPACE, "source");
            }
            if (fileItem.getOutputDirectory() != null) {
                serializer.startTag(NAMESPACE, "outputDirectory").text(fileItem.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
            }
            if (fileItem.getDestName() != null) {
                serializer.startTag(NAMESPACE, "destName").text(fileItem.getDestName()).endTag(NAMESPACE, "destName");
            }
            if (fileItem.getFileMode() != null) {
                serializer.startTag(NAMESPACE, "fileMode").text(fileItem.getFileMode()).endTag(NAMESPACE, "fileMode");
            }
            if (fileItem.getLineEnding() != null) {
                serializer.startTag(NAMESPACE, "lineEnding").text(fileItem.getLineEnding()).endTag(NAMESPACE, "lineEnding");
            }
            if (fileItem.isFiltered()) {
                serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(fileItem.isFiltered())).endTag(NAMESPACE, "filtered");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(NAMESPACE, "directory");
            }
            if (fileSet.getLineEnding() != null) {
                serializer.startTag(NAMESPACE, "lineEnding").text(fileSet.getLineEnding()).endTag(NAMESPACE, "lineEnding");
            }
            if (fileSet.isFiltered()) {
                serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(fileSet.isFiltered())).endTag(NAMESPACE, "filtered");
            }
            if (fileSet.isUseStrictFiltering()) {
                serializer.startTag(NAMESPACE, "useStrictFiltering").text(String.valueOf(fileSet.isUseStrictFiltering())).endTag(NAMESPACE, "useStrictFiltering");
            }
            if (!fileSet.isUseDefaultExcludes()) {
                serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(fileSet.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
            }
            if (fileSet.getOutputDirectory() != null) {
                serializer.startTag(NAMESPACE, "outputDirectory").text(fileSet.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
                }
                serializer.endTag(NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            if (fileSet.getFileMode() != null) {
                serializer.startTag(NAMESPACE, "fileMode").text(fileSet.getFileMode()).endTag(NAMESPACE, "fileMode");
            }
            if (fileSet.getDirectoryMode() != null) {
                serializer.startTag(NAMESPACE, "directoryMode").text(fileSet.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment, String tagName, XmlSerializer serializer) throws IOException {
        if (groupVersionAlignment != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (groupVersionAlignment.getId() != null) {
                serializer.startTag(NAMESPACE, "id").text(groupVersionAlignment.getId()).endTag(NAMESPACE, "id");
            }
            if (groupVersionAlignment.getVersion() != null) {
                serializer.startTag(NAMESPACE, "version").text(groupVersionAlignment.getVersion()).endTag(NAMESPACE, "version");
            }
            if (groupVersionAlignment.getExcludes() != null && groupVersionAlignment.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                Iterator iter = groupVersionAlignment.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (repository.isIncludeMetadata()) {
                serializer.startTag(NAMESPACE, "includeMetadata").text(String.valueOf(repository.isIncludeMetadata())).endTag(NAMESPACE, "includeMetadata");
            }
            if (repository.getGroupVersionAlignments() != null && repository.getGroupVersionAlignments().size() > 0) {
                serializer.startTag(NAMESPACE, "groupVersionAlignments");
                iter = repository.getGroupVersionAlignments().iterator();
                while (iter.hasNext()) {
                    GroupVersionAlignment o = (GroupVersionAlignment)iter.next();
                    this.writeGroupVersionAlignment(o, "groupVersionAlignment", serializer);
                }
                serializer.endTag(NAMESPACE, "groupVersionAlignments");
            }
            if (repository.getScope() != null && !repository.getScope().equals("runtime")) {
                serializer.startTag(NAMESPACE, "scope").text(repository.getScope()).endTag(NAMESPACE, "scope");
            }
            if (repository.isUseStrictFiltering()) {
                serializer.startTag(NAMESPACE, "useStrictFiltering").text(String.valueOf(repository.isUseStrictFiltering())).endTag(NAMESPACE, "useStrictFiltering");
            }
            if (!repository.isUseDefaultExcludes()) {
                serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(repository.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
            }
            if (repository.getOutputDirectory() != null) {
                serializer.startTag(NAMESPACE, "outputDirectory").text(repository.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
            }
            if (repository.getIncludes() != null && repository.getIncludes().size() > 0) {
                serializer.startTag(NAMESPACE, "includes");
                iter = repository.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
                }
                serializer.endTag(NAMESPACE, "includes");
            }
            if (repository.getExcludes() != null && repository.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                iter = repository.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            if (repository.getFileMode() != null) {
                serializer.startTag(NAMESPACE, "fileMode").text(repository.getFileMode()).endTag(NAMESPACE, "fileMode");
            }
            if (repository.getDirectoryMode() != null) {
                serializer.startTag(NAMESPACE, "directoryMode").text(repository.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer) throws IOException {
        if (setBase != null) {
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (setBase.isUseStrictFiltering()) {
                serializer.startTag(NAMESPACE, "useStrictFiltering").text(String.valueOf(setBase.isUseStrictFiltering())).endTag(NAMESPACE, "useStrictFiltering");
            }
            if (!setBase.isUseDefaultExcludes()) {
                serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(setBase.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
            }
            if (setBase.getOutputDirectory() != null) {
                serializer.startTag(NAMESPACE, "outputDirectory").text(setBase.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
            }
            if (setBase.getIncludes() != null && setBase.getIncludes().size() > 0) {
                serializer.startTag(NAMESPACE, "includes");
                iter = setBase.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
                }
                serializer.endTag(NAMESPACE, "includes");
            }
            if (setBase.getExcludes() != null && setBase.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                iter = setBase.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            if (setBase.getFileMode() != null) {
                serializer.startTag(NAMESPACE, "fileMode").text(setBase.getFileMode()).endTag(NAMESPACE, "fileMode");
            }
            if (setBase.getDirectoryMode() != null) {
                serializer.startTag(NAMESPACE, "directoryMode").text(setBase.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeUnpackOptions(UnpackOptions unpackOptions, String tagName, XmlSerializer serializer) throws IOException {
        if (unpackOptions != null) {
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (unpackOptions.getIncludes() != null && unpackOptions.getIncludes().size() > 0) {
                serializer.startTag(NAMESPACE, "includes");
                iter = unpackOptions.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
                }
                serializer.endTag(NAMESPACE, "includes");
            }
            if (unpackOptions.getExcludes() != null && unpackOptions.getExcludes().size() > 0) {
                serializer.startTag(NAMESPACE, "excludes");
                iter = unpackOptions.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
                }
                serializer.endTag(NAMESPACE, "excludes");
            }
            if (unpackOptions.isFiltered()) {
                serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(unpackOptions.isFiltered())).endTag(NAMESPACE, "filtered");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

