/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Contains configuration options for including the binary
 * files of a
 *         project module in an assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ModuleBinaries
    extends SetBase
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *           When specified, the attachmentClassifier will
     * cause the assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2)
     *           .
     */
    private String attachmentClassifier;

    /**
     * 
     *           If set to true, the plugin will include the direct
     * and transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     *           
     */
    private boolean includeDependencies = true;

    /**
     * Field dependencySets.
     */
    private java.util.List/*<DependencySet>*/ dependencySets;

    /**
     * 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     */
    private boolean unpack = true;

    /**
     * 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2)
     *           .
     */
    private UnpackOptions unpackOptions;

    /**
     * 
     *             Sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *           
     */
    private String outputFileNameMapping = "${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependencySet.
     * 
     * @param dependencySet
     */
    public void addDependencySet( DependencySet dependencySet )
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "ModuleBinaries.addDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet( DependencySet )

    /**
     * Get 
     *           When specified, the attachmentClassifier will
     * cause the assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2)
     *           .
     * 
     * @return String
     */
    public String getAttachmentClassifier()
    {
        return this.attachmentClassifier;
    } //-- String getAttachmentClassifier()

    /**
     * Method getDependencySets.
     * 
     * @return List
     */
    public java.util.List/*<DependencySet>*/ getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList/*<DependencySet>*/();
        }

        return this.dependencySets;
    } //-- java.util.List/*<DependencySet>*/ getDependencySets()

    /**
     * Get 
     *             Sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *           
     * 
     * @return String
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping()

    /**
     * Get 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2)
     *           .
     * 
     * @return UnpackOptions
     */
    public UnpackOptions getUnpackOptions()
    {
        return this.unpackOptions;
    } //-- UnpackOptions getUnpackOptions()

    /**
     * Get 
     *           If set to true, the plugin will include the direct
     * and transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     *           
     * 
     * @return boolean
     */
    public boolean isIncludeDependencies()
    {
        return this.includeDependencies;
    } //-- boolean isIncludeDependencies()

    /**
     * Get 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     * 
     * @return boolean
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack()

    /**
     * Method removeDependencySet.
     * 
     * @param dependencySet
     */
    public void removeDependencySet( DependencySet dependencySet )
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "ModuleBinaries.removeDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet( DependencySet )

    /**
     * Set 
     *           When specified, the attachmentClassifier will
     * cause the assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2)
     *           .
     * 
     * @param attachmentClassifier
     */
    public void setAttachmentClassifier( String attachmentClassifier )
    {
        this.attachmentClassifier = attachmentClassifier;
    } //-- void setAttachmentClassifier( String )

    /**
     * Set 
     *             
     *             Specifies which dependencies of the module to
     * include in the assembly. A
     *             dependencySet is specified by providing one or
     * more of
     *             &lt;dependencySet&gt; subelements. (Since 2.2)
     *             
     *           .
     * 
     * @param dependencySets
     */
    public void setDependencySets( java.util.List/*<DependencySet>*/ dependencySets )
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets( java.util.List )

    /**
     * Set 
     *           If set to true, the plugin will include the direct
     * and transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     *           
     * 
     * @param includeDependencies
     */
    public void setIncludeDependencies( boolean includeDependencies )
    {
        this.includeDependencies = includeDependencies;
    } //-- void setIncludeDependencies( boolean )

    /**
     * Set 
     *             Sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *           
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping( String outputFileNameMapping )
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping( String )

    /**
     * Set 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     * 
     * @param unpack
     */
    public void setUnpack( boolean unpack )
    {
        this.unpack = unpack;
    } //-- void setUnpack( boolean )

    /**
     * Set 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2)
     *           .
     * 
     * @param unpackOptions
     */
    public void setUnpackOptions( UnpackOptions unpackOptions )
    {
        this.unpackOptions = unpackOptions;
    } //-- void setUnpackOptions( UnpackOptions )


}
