/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Contains configuration options for including the source
 * files of a
 *         project module in an assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ModuleSources
    extends SetBase
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field fileSets.
     */
    private java.util.List/*<FileSet>*/ fileSets;

    /**
     * 
     *             
     *             Specifies whether the module's finalName should
     * be prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2)
     *             
     *           .
     */
    private boolean includeModuleDirectory = true;

    /**
     * 
     *             
     *             Specifies whether sub-module directories below
     * the current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2)
     *             
     *           .
     */
    private boolean excludeSubModuleDirectories = true;

    /**
     * 
     *             Sets the mapping pattern for all module
     * base-directories included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2)
     *           .
     */
    private String outputDirectoryMapping = "${module.artifactId}";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFileSet.
     * 
     * @param fileSet
     */
    public void addFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "ModuleSources.addFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().add( fileSet );
    } //-- void addFileSet( FileSet )

    /**
     * Method getFileSets.
     * 
     * @return List
     */
    public java.util.List/*<FileSet>*/ getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList/*<FileSet>*/();
        }

        return this.fileSets;
    } //-- java.util.List/*<FileSet>*/ getFileSets()

    /**
     * Get 
     *             Sets the mapping pattern for all module
     * base-directories included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2)
     *           .
     * 
     * @return String
     */
    public String getOutputDirectoryMapping()
    {
        return this.outputDirectoryMapping;
    } //-- String getOutputDirectoryMapping()

    /**
     * Get 
     *             
     *             Specifies whether sub-module directories below
     * the current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2)
     *             
     *           .
     * 
     * @return boolean
     */
    public boolean isExcludeSubModuleDirectories()
    {
        return this.excludeSubModuleDirectories;
    } //-- boolean isExcludeSubModuleDirectories()

    /**
     * Get 
     *             
     *             Specifies whether the module's finalName should
     * be prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2)
     *             
     *           .
     * 
     * @return boolean
     */
    public boolean isIncludeModuleDirectory()
    {
        return this.includeModuleDirectory;
    } //-- boolean isIncludeModuleDirectory()

    /**
     * Method removeFileSet.
     * 
     * @param fileSet
     */
    public void removeFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "ModuleSources.removeFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().remove( fileSet );
    } //-- void removeFileSet( FileSet )

    /**
     * Set 
     *             
     *             Specifies whether sub-module directories below
     * the current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2)
     *             
     *           .
     * 
     * @param excludeSubModuleDirectories
     */
    public void setExcludeSubModuleDirectories( boolean excludeSubModuleDirectories )
    {
        this.excludeSubModuleDirectories = excludeSubModuleDirectories;
    } //-- void setExcludeSubModuleDirectories( boolean )

    /**
     * Set 
     *             
     *             Specifies which groups of files from each
     * included module to include in the assembly. A
     *             fileSet is specified by providing one or more of
     * &lt;fileSet&gt; subelements. (Since 2.2)
     *             
     *           .
     * 
     * @param fileSets
     */
    public void setFileSets( java.util.List/*<FileSet>*/ fileSets )
    {
        this.fileSets = fileSets;
    } //-- void setFileSets( java.util.List )

    /**
     * Set 
     *             
     *             Specifies whether the module's finalName should
     * be prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2)
     *             
     *           .
     * 
     * @param includeModuleDirectory
     */
    public void setIncludeModuleDirectory( boolean includeModuleDirectory )
    {
        this.includeModuleDirectory = includeModuleDirectory;
    } //-- void setIncludeModuleDirectory( boolean )

    /**
     * Set 
     *             Sets the mapping pattern for all module
     * base-directories included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2)
     *           .
     * 
     * @param outputDirectoryMapping
     */
    public void setOutputDirectoryMapping( String outputDirectoryMapping )
    {
        this.outputDirectoryMapping = outputDirectoryMapping;
    } //-- void setOutputDirectoryMapping( String )


}
