/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4.1 on 2012-11-15 00:02:59,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugin.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Locale;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.ModuleSources;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class AssemblyXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class AssemblyXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser
     * @param strict
     * @param tagName
     * @param attribute
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser
     * @param strict
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param defaultValue
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param dateFormat
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method initParser.
     * 
     * @param parser
     * @throws XmlPullParserException
     */
    private void initParser( XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( addDefaultEntities )
        {
            // ----------------------------------------------------------------------
            // Latin 1 entities
            // ----------------------------------------------------------------------

            parser.defineEntityReplacementText( "nbsp", "\u00a0" );
            parser.defineEntityReplacementText( "iexcl", "\u00a1" );
            parser.defineEntityReplacementText( "cent", "\u00a2" );
            parser.defineEntityReplacementText( "pound", "\u00a3" );
            parser.defineEntityReplacementText( "curren", "\u00a4" );
            parser.defineEntityReplacementText( "yen", "\u00a5" );
            parser.defineEntityReplacementText( "brvbar", "\u00a6" );
            parser.defineEntityReplacementText( "sect", "\u00a7" );
            parser.defineEntityReplacementText( "uml", "\u00a8" );
            parser.defineEntityReplacementText( "copy", "\u00a9" );
            parser.defineEntityReplacementText( "ordf", "\u00aa" );
            parser.defineEntityReplacementText( "laquo", "\u00ab" );
            parser.defineEntityReplacementText( "not", "\u00ac" );
            parser.defineEntityReplacementText( "shy", "\u00ad" );
            parser.defineEntityReplacementText( "reg", "\u00ae" );
            parser.defineEntityReplacementText( "macr", "\u00af" );
            parser.defineEntityReplacementText( "deg", "\u00b0" );
            parser.defineEntityReplacementText( "plusmn", "\u00b1" );
            parser.defineEntityReplacementText( "sup2", "\u00b2" );
            parser.defineEntityReplacementText( "sup3", "\u00b3" );
            parser.defineEntityReplacementText( "acute", "\u00b4" );
            parser.defineEntityReplacementText( "micro", "\u00b5" );
            parser.defineEntityReplacementText( "para", "\u00b6" );
            parser.defineEntityReplacementText( "middot", "\u00b7" );
            parser.defineEntityReplacementText( "cedil", "\u00b8" );
            parser.defineEntityReplacementText( "sup1", "\u00b9" );
            parser.defineEntityReplacementText( "ordm", "\u00ba" );
            parser.defineEntityReplacementText( "raquo", "\u00bb" );
            parser.defineEntityReplacementText( "frac14", "\u00bc" );
            parser.defineEntityReplacementText( "frac12", "\u00bd" );
            parser.defineEntityReplacementText( "frac34", "\u00be" );
            parser.defineEntityReplacementText( "iquest", "\u00bf" );
            parser.defineEntityReplacementText( "Agrave", "\u00c0" );
            parser.defineEntityReplacementText( "Aacute", "\u00c1" );
            parser.defineEntityReplacementText( "Acirc", "\u00c2" );
            parser.defineEntityReplacementText( "Atilde", "\u00c3" );
            parser.defineEntityReplacementText( "Auml", "\u00c4" );
            parser.defineEntityReplacementText( "Aring", "\u00c5" );
            parser.defineEntityReplacementText( "AElig", "\u00c6" );
            parser.defineEntityReplacementText( "Ccedil", "\u00c7" );
            parser.defineEntityReplacementText( "Egrave", "\u00c8" );
            parser.defineEntityReplacementText( "Eacute", "\u00c9" );
            parser.defineEntityReplacementText( "Ecirc", "\u00ca" );
            parser.defineEntityReplacementText( "Euml", "\u00cb" );
            parser.defineEntityReplacementText( "Igrave", "\u00cc" );
            parser.defineEntityReplacementText( "Iacute", "\u00cd" );
            parser.defineEntityReplacementText( "Icirc", "\u00ce" );
            parser.defineEntityReplacementText( "Iuml", "\u00cf" );
            parser.defineEntityReplacementText( "ETH", "\u00d0" );
            parser.defineEntityReplacementText( "Ntilde", "\u00d1" );
            parser.defineEntityReplacementText( "Ograve", "\u00d2" );
            parser.defineEntityReplacementText( "Oacute", "\u00d3" );
            parser.defineEntityReplacementText( "Ocirc", "\u00d4" );
            parser.defineEntityReplacementText( "Otilde", "\u00d5" );
            parser.defineEntityReplacementText( "Ouml", "\u00d6" );
            parser.defineEntityReplacementText( "times", "\u00d7" );
            parser.defineEntityReplacementText( "Oslash", "\u00d8" );
            parser.defineEntityReplacementText( "Ugrave", "\u00d9" );
            parser.defineEntityReplacementText( "Uacute", "\u00da" );
            parser.defineEntityReplacementText( "Ucirc", "\u00db" );
            parser.defineEntityReplacementText( "Uuml", "\u00dc" );
            parser.defineEntityReplacementText( "Yacute", "\u00dd" );
            parser.defineEntityReplacementText( "THORN", "\u00de" );
            parser.defineEntityReplacementText( "szlig", "\u00df" );
            parser.defineEntityReplacementText( "agrave", "\u00e0" );
            parser.defineEntityReplacementText( "aacute", "\u00e1" );
            parser.defineEntityReplacementText( "acirc", "\u00e2" );
            parser.defineEntityReplacementText( "atilde", "\u00e3" );
            parser.defineEntityReplacementText( "auml", "\u00e4" );
            parser.defineEntityReplacementText( "aring", "\u00e5" );
            parser.defineEntityReplacementText( "aelig", "\u00e6" );
            parser.defineEntityReplacementText( "ccedil", "\u00e7" );
            parser.defineEntityReplacementText( "egrave", "\u00e8" );
            parser.defineEntityReplacementText( "eacute", "\u00e9" );
            parser.defineEntityReplacementText( "ecirc", "\u00ea" );
            parser.defineEntityReplacementText( "euml", "\u00eb" );
            parser.defineEntityReplacementText( "igrave", "\u00ec" );
            parser.defineEntityReplacementText( "iacute", "\u00ed" );
            parser.defineEntityReplacementText( "icirc", "\u00ee" );
            parser.defineEntityReplacementText( "iuml", "\u00ef" );
            parser.defineEntityReplacementText( "eth", "\u00f0" );
            parser.defineEntityReplacementText( "ntilde", "\u00f1" );
            parser.defineEntityReplacementText( "ograve", "\u00f2" );
            parser.defineEntityReplacementText( "oacute", "\u00f3" );
            parser.defineEntityReplacementText( "ocirc", "\u00f4" );
            parser.defineEntityReplacementText( "otilde", "\u00f5" );
            parser.defineEntityReplacementText( "ouml", "\u00f6" );
            parser.defineEntityReplacementText( "divide", "\u00f7" );
            parser.defineEntityReplacementText( "oslash", "\u00f8" );
            parser.defineEntityReplacementText( "ugrave", "\u00f9" );
            parser.defineEntityReplacementText( "uacute", "\u00fa" );
            parser.defineEntityReplacementText( "ucirc", "\u00fb" );
            parser.defineEntityReplacementText( "uuml", "\u00fc" );
            parser.defineEntityReplacementText( "yacute", "\u00fd" );
            parser.defineEntityReplacementText( "thorn", "\u00fe" );
            parser.defineEntityReplacementText( "yuml", "\u00ff" );

            // ----------------------------------------------------------------------
            // Special entities
            // ----------------------------------------------------------------------

            parser.defineEntityReplacementText( "OElig", "\u0152" );
            parser.defineEntityReplacementText( "oelig", "\u0153" );
            parser.defineEntityReplacementText( "Scaron", "\u0160" );
            parser.defineEntityReplacementText( "scaron", "\u0161" );
            parser.defineEntityReplacementText( "Yuml", "\u0178" );
            parser.defineEntityReplacementText( "circ", "\u02c6" );
            parser.defineEntityReplacementText( "tilde", "\u02dc" );
            parser.defineEntityReplacementText( "ensp", "\u2002" );
            parser.defineEntityReplacementText( "emsp", "\u2003" );
            parser.defineEntityReplacementText( "thinsp", "\u2009" );
            parser.defineEntityReplacementText( "zwnj", "\u200c" );
            parser.defineEntityReplacementText( "zwj", "\u200d" );
            parser.defineEntityReplacementText( "lrm", "\u200e" );
            parser.defineEntityReplacementText( "rlm", "\u200f" );
            parser.defineEntityReplacementText( "ndash", "\u2013" );
            parser.defineEntityReplacementText( "mdash", "\u2014" );
            parser.defineEntityReplacementText( "lsquo", "\u2018" );
            parser.defineEntityReplacementText( "rsquo", "\u2019" );
            parser.defineEntityReplacementText( "sbquo", "\u201a" );
            parser.defineEntityReplacementText( "ldquo", "\u201c" );
            parser.defineEntityReplacementText( "rdquo", "\u201d" );
            parser.defineEntityReplacementText( "bdquo", "\u201e" );
            parser.defineEntityReplacementText( "dagger", "\u2020" );
            parser.defineEntityReplacementText( "Dagger", "\u2021" );
            parser.defineEntityReplacementText( "permil", "\u2030" );
            parser.defineEntityReplacementText( "lsaquo", "\u2039" );
            parser.defineEntityReplacementText( "rsaquo", "\u203a" );
            parser.defineEntityReplacementText( "euro", "\u20ac" );

            // ----------------------------------------------------------------------
            // Symbol entities
            // ----------------------------------------------------------------------

            parser.defineEntityReplacementText( "fnof", "\u0192" );
            parser.defineEntityReplacementText( "Alpha", "\u0391" );
            parser.defineEntityReplacementText( "Beta", "\u0392" );
            parser.defineEntityReplacementText( "Gamma", "\u0393" );
            parser.defineEntityReplacementText( "Delta", "\u0394" );
            parser.defineEntityReplacementText( "Epsilon", "\u0395" );
            parser.defineEntityReplacementText( "Zeta", "\u0396" );
            parser.defineEntityReplacementText( "Eta", "\u0397" );
            parser.defineEntityReplacementText( "Theta", "\u0398" );
            parser.defineEntityReplacementText( "Iota", "\u0399" );
            parser.defineEntityReplacementText( "Kappa", "\u039a" );
            parser.defineEntityReplacementText( "Lambda", "\u039b" );
            parser.defineEntityReplacementText( "Mu", "\u039c" );
            parser.defineEntityReplacementText( "Nu", "\u039d" );
            parser.defineEntityReplacementText( "Xi", "\u039e" );
            parser.defineEntityReplacementText( "Omicron", "\u039f" );
            parser.defineEntityReplacementText( "Pi", "\u03a0" );
            parser.defineEntityReplacementText( "Rho", "\u03a1" );
            parser.defineEntityReplacementText( "Sigma", "\u03a3" );
            parser.defineEntityReplacementText( "Tau", "\u03a4" );
            parser.defineEntityReplacementText( "Upsilon", "\u03a5" );
            parser.defineEntityReplacementText( "Phi", "\u03a6" );
            parser.defineEntityReplacementText( "Chi", "\u03a7" );
            parser.defineEntityReplacementText( "Psi", "\u03a8" );
            parser.defineEntityReplacementText( "Omega", "\u03a9" );
            parser.defineEntityReplacementText( "alpha", "\u03b1" );
            parser.defineEntityReplacementText( "beta", "\u03b2" );
            parser.defineEntityReplacementText( "gamma", "\u03b3" );
            parser.defineEntityReplacementText( "delta", "\u03b4" );
            parser.defineEntityReplacementText( "epsilon", "\u03b5" );
            parser.defineEntityReplacementText( "zeta", "\u03b6" );
            parser.defineEntityReplacementText( "eta", "\u03b7" );
            parser.defineEntityReplacementText( "theta", "\u03b8" );
            parser.defineEntityReplacementText( "iota", "\u03b9" );
            parser.defineEntityReplacementText( "kappa", "\u03ba" );
            parser.defineEntityReplacementText( "lambda", "\u03bb" );
            parser.defineEntityReplacementText( "mu", "\u03bc" );
            parser.defineEntityReplacementText( "nu", "\u03bd" );
            parser.defineEntityReplacementText( "xi", "\u03be" );
            parser.defineEntityReplacementText( "omicron", "\u03bf" );
            parser.defineEntityReplacementText( "pi", "\u03c0" );
            parser.defineEntityReplacementText( "rho", "\u03c1" );
            parser.defineEntityReplacementText( "sigmaf", "\u03c2" );
            parser.defineEntityReplacementText( "sigma", "\u03c3" );
            parser.defineEntityReplacementText( "tau", "\u03c4" );
            parser.defineEntityReplacementText( "upsilon", "\u03c5" );
            parser.defineEntityReplacementText( "phi", "\u03c6" );
            parser.defineEntityReplacementText( "chi", "\u03c7" );
            parser.defineEntityReplacementText( "psi", "\u03c8" );
            parser.defineEntityReplacementText( "omega", "\u03c9" );
            parser.defineEntityReplacementText( "thetasym", "\u03d1" );
            parser.defineEntityReplacementText( "upsih", "\u03d2" );
            parser.defineEntityReplacementText( "piv", "\u03d6" );
            parser.defineEntityReplacementText( "bull", "\u2022" );
            parser.defineEntityReplacementText( "hellip", "\u2026" );
            parser.defineEntityReplacementText( "prime", "\u2032" );
            parser.defineEntityReplacementText( "Prime", "\u2033" );
            parser.defineEntityReplacementText( "oline", "\u203e" );
            parser.defineEntityReplacementText( "frasl", "\u2044" );
            parser.defineEntityReplacementText( "weierp", "\u2118" );
            parser.defineEntityReplacementText( "image", "\u2111" );
            parser.defineEntityReplacementText( "real", "\u211c" );
            parser.defineEntityReplacementText( "trade", "\u2122" );
            parser.defineEntityReplacementText( "alefsym", "\u2135" );
            parser.defineEntityReplacementText( "larr", "\u2190" );
            parser.defineEntityReplacementText( "uarr", "\u2191" );
            parser.defineEntityReplacementText( "rarr", "\u2192" );
            parser.defineEntityReplacementText( "darr", "\u2193" );
            parser.defineEntityReplacementText( "harr", "\u2194" );
            parser.defineEntityReplacementText( "crarr", "\u21b5" );
            parser.defineEntityReplacementText( "lArr", "\u21d0" );
            parser.defineEntityReplacementText( "uArr", "\u21d1" );
            parser.defineEntityReplacementText( "rArr", "\u21d2" );
            parser.defineEntityReplacementText( "dArr", "\u21d3" );
            parser.defineEntityReplacementText( "hArr", "\u21d4" );
            parser.defineEntityReplacementText( "forall", "\u2200" );
            parser.defineEntityReplacementText( "part", "\u2202" );
            parser.defineEntityReplacementText( "exist", "\u2203" );
            parser.defineEntityReplacementText( "empty", "\u2205" );
            parser.defineEntityReplacementText( "nabla", "\u2207" );
            parser.defineEntityReplacementText( "isin", "\u2208" );
            parser.defineEntityReplacementText( "notin", "\u2209" );
            parser.defineEntityReplacementText( "ni", "\u220b" );
            parser.defineEntityReplacementText( "prod", "\u220f" );
            parser.defineEntityReplacementText( "sum", "\u2211" );
            parser.defineEntityReplacementText( "minus", "\u2212" );
            parser.defineEntityReplacementText( "lowast", "\u2217" );
            parser.defineEntityReplacementText( "radic", "\u221a" );
            parser.defineEntityReplacementText( "prop", "\u221d" );
            parser.defineEntityReplacementText( "infin", "\u221e" );
            parser.defineEntityReplacementText( "ang", "\u2220" );
            parser.defineEntityReplacementText( "and", "\u2227" );
            parser.defineEntityReplacementText( "or", "\u2228" );
            parser.defineEntityReplacementText( "cap", "\u2229" );
            parser.defineEntityReplacementText( "cup", "\u222a" );
            parser.defineEntityReplacementText( "int", "\u222b" );
            parser.defineEntityReplacementText( "there4", "\u2234" );
            parser.defineEntityReplacementText( "sim", "\u223c" );
            parser.defineEntityReplacementText( "cong", "\u2245" );
            parser.defineEntityReplacementText( "asymp", "\u2248" );
            parser.defineEntityReplacementText( "ne", "\u2260" );
            parser.defineEntityReplacementText( "equiv", "\u2261" );
            parser.defineEntityReplacementText( "le", "\u2264" );
            parser.defineEntityReplacementText( "ge", "\u2265" );
            parser.defineEntityReplacementText( "sub", "\u2282" );
            parser.defineEntityReplacementText( "sup", "\u2283" );
            parser.defineEntityReplacementText( "nsub", "\u2284" );
            parser.defineEntityReplacementText( "sube", "\u2286" );
            parser.defineEntityReplacementText( "supe", "\u2287" );
            parser.defineEntityReplacementText( "oplus", "\u2295" );
            parser.defineEntityReplacementText( "otimes", "\u2297" );
            parser.defineEntityReplacementText( "perp", "\u22a5" );
            parser.defineEntityReplacementText( "sdot", "\u22c5" );
            parser.defineEntityReplacementText( "lceil", "\u2308" );
            parser.defineEntityReplacementText( "rceil", "\u2309" );
            parser.defineEntityReplacementText( "lfloor", "\u230a" );
            parser.defineEntityReplacementText( "rfloor", "\u230b" );
            parser.defineEntityReplacementText( "lang", "\u2329" );
            parser.defineEntityReplacementText( "rang", "\u232a" );
            parser.defineEntityReplacementText( "loz", "\u25ca" );
            parser.defineEntityReplacementText( "spades", "\u2660" );
            parser.defineEntityReplacementText( "clubs", "\u2663" );
            parser.defineEntityReplacementText( "hearts", "\u2665" );
            parser.defineEntityReplacementText( "diams", "\u2666" );

        }
    } //-- void initParser( XmlPullParser )

    /**
     * Method nextTag.
     * 
     * @param parser
     * @throws IOException
     * @throws XmlPullParserException
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * Method parseAssembly.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    private Assembly parseAssembly( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Assembly assembly = new Assembly();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "id", null, parsed ) )
            {
                assembly.setId( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "formats", null, parsed ) )
            {
                java.util.List formats = new java.util.ArrayList/*<String>*/();
                assembly.setFormats( formats );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "format".equals( parser.getName() ) )
                    {
                        formats.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "includeBaseDirectory", null, parsed ) )
            {
                assembly.setIncludeBaseDirectory( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeBaseDirectory", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "baseDirectory", null, parsed ) )
            {
                assembly.setBaseDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeSiteDirectory", null, parsed ) )
            {
                assembly.setIncludeSiteDirectory( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeSiteDirectory", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "containerDescriptorHandlers", null, parsed ) )
            {
                java.util.List containerDescriptorHandlers = new java.util.ArrayList/*<ContainerDescriptorHandlerConfig>*/();
                assembly.setContainerDescriptorHandlers( containerDescriptorHandlers );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "containerDescriptorHandler".equals( parser.getName() ) )
                    {
                        containerDescriptorHandlers.add( parseContainerDescriptorHandlerConfig( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "moduleSets", null, parsed ) )
            {
                java.util.List moduleSets = new java.util.ArrayList/*<ModuleSet>*/();
                assembly.setModuleSets( moduleSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "moduleSet".equals( parser.getName() ) )
                    {
                        moduleSets.add( parseModuleSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileSets", null, parsed ) )
            {
                java.util.List fileSets = new java.util.ArrayList/*<FileSet>*/();
                assembly.setFileSets( fileSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "fileSet".equals( parser.getName() ) )
                    {
                        fileSets.add( parseFileSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "files", null, parsed ) )
            {
                java.util.List files = new java.util.ArrayList/*<FileItem>*/();
                assembly.setFiles( files );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "file".equals( parser.getName() ) )
                    {
                        files.add( parseFileItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "dependencySets", null, parsed ) )
            {
                java.util.List dependencySets = new java.util.ArrayList/*<DependencySet>*/();
                assembly.setDependencySets( dependencySets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "dependencySet".equals( parser.getName() ) )
                    {
                        dependencySets.add( parseDependencySet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "repositories", null, parsed ) )
            {
                java.util.List repositories = new java.util.ArrayList/*<Repository>*/();
                assembly.setRepositories( repositories );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "repository".equals( parser.getName() ) )
                    {
                        repositories.add( parseRepository( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "componentDescriptors", null, parsed ) )
            {
                java.util.List componentDescriptors = new java.util.ArrayList/*<String>*/();
                assembly.setComponentDescriptors( componentDescriptors );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "componentDescriptor".equals( parser.getName() ) )
                    {
                        componentDescriptors.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return assembly;
    } //-- Assembly parseAssembly( XmlPullParser, boolean )

    /**
     * Method parseContainerDescriptorHandlerConfig.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return ContainerDescriptorHandlerConfig
     */
    private ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig = new ContainerDescriptorHandlerConfig();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "handlerName", null, parsed ) )
            {
                containerDescriptorHandlerConfig.setHandlerName( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "configuration", null, parsed ) )
            {
                containerDescriptorHandlerConfig.setConfiguration( Xpp3DomBuilder.build( parser ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return containerDescriptorHandlerConfig;
    } //-- ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig( XmlPullParser, boolean )

    /**
     * Method parseDependencySet.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DependencySet
     */
    private DependencySet parseDependencySet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DependencySet dependencySet = new DependencySet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                dependencySet.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                dependencySet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                dependencySet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                dependencySet.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                dependencySet.setDirectoryMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useStrictFiltering", null, parsed ) )
            {
                dependencySet.setUseStrictFiltering( getBooleanValue( getTrimmedValue( parser.nextText() ), "useStrictFiltering", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputFileNameMapping", null, parsed ) )
            {
                dependencySet.setOutputFileNameMapping( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpack", null, parsed ) )
            {
                dependencySet.setUnpack( getBooleanValue( getTrimmedValue( parser.nextText() ), "unpack", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpackOptions", null, parsed ) )
            {
                dependencySet.setUnpackOptions( parseUnpackOptions( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "scope", null, parsed ) )
            {
                dependencySet.setScope( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useProjectArtifact", null, parsed ) )
            {
                dependencySet.setUseProjectArtifact( getBooleanValue( getTrimmedValue( parser.nextText() ), "useProjectArtifact", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useProjectAttachments", null, parsed ) )
            {
                dependencySet.setUseProjectAttachments( getBooleanValue( getTrimmedValue( parser.nextText() ), "useProjectAttachments", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useTransitiveDependencies", null, parsed ) )
            {
                dependencySet.setUseTransitiveDependencies( getBooleanValue( getTrimmedValue( parser.nextText() ), "useTransitiveDependencies", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useTransitiveFiltering", null, parsed ) )
            {
                dependencySet.setUseTransitiveFiltering( getBooleanValue( getTrimmedValue( parser.nextText() ), "useTransitiveFiltering", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return dependencySet;
    } //-- DependencySet parseDependencySet( XmlPullParser, boolean )

    /**
     * Method parseFileItem.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return FileItem
     */
    private FileItem parseFileItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        FileItem fileItem = new FileItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "source", null, parsed ) )
            {
                fileItem.setSource( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                fileItem.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "destName", null, parsed ) )
            {
                fileItem.setDestName( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                fileItem.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                fileItem.setLineEnding( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                fileItem.setFiltered( getBooleanValue( getTrimmedValue( parser.nextText() ), "filtered", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return fileItem;
    } //-- FileItem parseFileItem( XmlPullParser, boolean )

    /**
     * Method parseFileSet.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return FileSet
     */
    private FileSet parseFileSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                fileSet.setUseDefaultExcludes( getBooleanValue( getTrimmedValue( parser.nextText() ), "useDefaultExcludes", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                fileSet.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                fileSet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                fileSet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                fileSet.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                fileSet.setDirectoryMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directory", null, parsed ) )
            {
                fileSet.setDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                fileSet.setLineEnding( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                fileSet.setFiltered( getBooleanValue( getTrimmedValue( parser.nextText() ), "filtered", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return fileSet;
    } //-- FileSet parseFileSet( XmlPullParser, boolean )

    /**
     * Method parseGroupVersionAlignment.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return GroupVersionAlignment
     */
    private GroupVersionAlignment parseGroupVersionAlignment( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        GroupVersionAlignment groupVersionAlignment = new GroupVersionAlignment();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "id", null, parsed ) )
            {
                groupVersionAlignment.setId( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                groupVersionAlignment.setVersion( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                groupVersionAlignment.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return groupVersionAlignment;
    } //-- GroupVersionAlignment parseGroupVersionAlignment( XmlPullParser, boolean )

    /**
     * Method parseModuleBinaries.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return ModuleBinaries
     */
    private ModuleBinaries parseModuleBinaries( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleBinaries moduleBinaries = new ModuleBinaries();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                moduleBinaries.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                moduleBinaries.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                moduleBinaries.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                moduleBinaries.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                moduleBinaries.setDirectoryMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "attachmentClassifier", null, parsed ) )
            {
                moduleBinaries.setAttachmentClassifier( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeDependencies", null, parsed ) )
            {
                moduleBinaries.setIncludeDependencies( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeDependencies", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "dependencySets", null, parsed ) )
            {
                java.util.List dependencySets = new java.util.ArrayList/*<DependencySet>*/();
                moduleBinaries.setDependencySets( dependencySets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "dependencySet".equals( parser.getName() ) )
                    {
                        dependencySets.add( parseDependencySet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "unpack", null, parsed ) )
            {
                moduleBinaries.setUnpack( getBooleanValue( getTrimmedValue( parser.nextText() ), "unpack", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpackOptions", null, parsed ) )
            {
                moduleBinaries.setUnpackOptions( parseUnpackOptions( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputFileNameMapping", null, parsed ) )
            {
                moduleBinaries.setOutputFileNameMapping( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleBinaries;
    } //-- ModuleBinaries parseModuleBinaries( XmlPullParser, boolean )

    /**
     * Method parseModuleSet.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return ModuleSet
     */
    private ModuleSet parseModuleSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleSet moduleSet = new ModuleSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useAllReactorProjects", null, parsed ) )
            {
                moduleSet.setUseAllReactorProjects( getBooleanValue( getTrimmedValue( parser.nextText() ), "useAllReactorProjects", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeSubModules", null, parsed ) )
            {
                moduleSet.setIncludeSubModules( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeSubModules", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                moduleSet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                moduleSet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "sources", null, parsed ) )
            {
                moduleSet.setSources( parseModuleSources( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "binaries", null, parsed ) )
            {
                moduleSet.setBinaries( parseModuleBinaries( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleSet;
    } //-- ModuleSet parseModuleSet( XmlPullParser, boolean )

    /**
     * Method parseModuleSources.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return ModuleSources
     */
    private ModuleSources parseModuleSources( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleSources moduleSources = new ModuleSources();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                moduleSources.setUseDefaultExcludes( getBooleanValue( getTrimmedValue( parser.nextText() ), "useDefaultExcludes", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                moduleSources.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                moduleSources.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                moduleSources.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                moduleSources.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                moduleSources.setDirectoryMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileSets", null, parsed ) )
            {
                java.util.List fileSets = new java.util.ArrayList/*<FileSet>*/();
                moduleSources.setFileSets( fileSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "fileSet".equals( parser.getName() ) )
                    {
                        fileSets.add( parseFileSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "includeModuleDirectory", null, parsed ) )
            {
                moduleSources.setIncludeModuleDirectory( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeModuleDirectory", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "excludeSubModuleDirectories", null, parsed ) )
            {
                moduleSources.setExcludeSubModuleDirectories( getBooleanValue( getTrimmedValue( parser.nextText() ), "excludeSubModuleDirectories", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectoryMapping", null, parsed ) )
            {
                moduleSources.setOutputDirectoryMapping( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleSources;
    } //-- ModuleSources parseModuleSources( XmlPullParser, boolean )

    /**
     * Method parseRepository.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Repository
     */
    private Repository parseRepository( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Repository repository = new Repository();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                repository.setOutputDirectory( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                repository.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                repository.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                repository.setFileMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                repository.setDirectoryMode( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeMetadata", null, parsed ) )
            {
                repository.setIncludeMetadata( getBooleanValue( getTrimmedValue( parser.nextText() ), "includeMetadata", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "groupVersionAlignments", null, parsed ) )
            {
                java.util.List groupVersionAlignments = new java.util.ArrayList/*<GroupVersionAlignment>*/();
                repository.setGroupVersionAlignments( groupVersionAlignments );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "groupVersionAlignment".equals( parser.getName() ) )
                    {
                        groupVersionAlignments.add( parseGroupVersionAlignment( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "scope", null, parsed ) )
            {
                repository.setScope( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return repository;
    } //-- Repository parseRepository( XmlPullParser, boolean )

    /**
     * Method parseUnpackOptions.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return UnpackOptions
     */
    private UnpackOptions parseUnpackOptions( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        UnpackOptions unpackOptions = new UnpackOptions();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List includes = new java.util.ArrayList/*<String>*/();
                unpackOptions.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List excludes = new java.util.ArrayList/*<String>*/();
                unpackOptions.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( getTrimmedValue( parser.nextText() ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                unpackOptions.setFiltered( getBooleanValue( getTrimmedValue( parser.nextText() ), "filtered", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                unpackOptions.setLineEnding( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                unpackOptions.setUseDefaultExcludes( getBooleanValue( getTrimmedValue( parser.nextText() ), "useDefaultExcludes", parser, "true" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return unpackOptions;
    } //-- UnpackOptions parseUnpackOptions( XmlPullParser, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    public Assembly read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = new MXParser();

        parser.setInput( reader );

        initParser( parser );

        return read( parser, strict );
    } //-- Assembly read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    public Assembly read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- Assembly read( Reader )

    /**
     * Method read.
     * 
     * @param in
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    public Assembly read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- Assembly read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    public Assembly read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- Assembly read( InputStream )

    /**
     * Method read.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Assembly
     */
    private Assembly read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.getEventType();
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "assembly".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'assembly' but found '" + parser.getName() + "'", parser, null );
                }
                Assembly assembly = parseAssembly( parser, strict );
                assembly.setModelEncoding( parser.getInputEncoding() );
                return assembly;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException( "Expected root element 'assembly' but found no element at all: invalid XML document", parser, null );
    } //-- Assembly read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

}
