/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.LineEndings;
import org.apache.maven.plugin.assembly.utils.LineEndingsUtils;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFormatter {
    private final Logger logger;
    private final AssemblerConfigurationSource configSource;

    public FileFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    public File format(@Nonnull File source, boolean filter, String lineEnding, String encoding) throws AssemblyFormattingException {
        LineEndings lineEnding1;
        File tempRoot = this.configSource.getTemporaryRootDirectory();
        AssemblyFileUtils.verifyTempDirectoryAvailability(tempRoot);
        File result = source;
        if (StringUtils.isEmpty((String)encoding) && filter) {
            this.logger.warn("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!");
        }
        if (filter) {
            result = this.doFileFilter(source, tempRoot, encoding, this.configSource.getEscapeString(), this.configSource.getDelimiters());
        }
        if (!LineEndings.keep.equals((Object)(lineEnding1 = LineEndingsUtils.getLineEnding(lineEnding)))) {
            result = this.formatLineEndings(lineEnding1, result, tempRoot, encoding);
        }
        return result;
    }

    private File doFileFilter(@Nonnull File source, @Nullable File tempRoot, String encoding, String escapeString, List<String> delimiters) throws AssemblyFormattingException {
        try {
            File target = FileUtils.createTempFile((String)(source.getName() + "."), (String)".filtered", (File)tempRoot);
            boolean isPropertiesFile = source.getName().toLowerCase(Locale.ENGLISH).endsWith(".properties");
            MavenFileFilterRequest filterRequest = new MavenFileFilterRequest(source, target, true, this.configSource.getProject(), this.configSource.getFilters(), isPropertiesFile, encoding, this.configSource.getMavenSession(), null);
            filterRequest.setEscapeString(escapeString);
            if (delimiters != null && !delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                for (String delim : delimiters) {
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                filterRequest.setDelimiters(delims);
            } else {
                filterRequest.setDelimiters(filterRequest.getDelimiters());
            }
            filterRequest.setInjectProjectBuildFilters(this.configSource.isIncludeProjectBuildFilters());
            this.configSource.getMavenFileFilter().copyFile(filterRequest);
            return target;
        }
        catch (MavenFilteringException e) {
            throw new AssemblyFormattingException("Error filtering file '" + source + "': " + e.getMessage(), e);
        }
    }

    private File formatLineEndings(LineEndings lineEnding, File source, File tempRoot, String encoding) throws AssemblyFormattingException {
        try {
            File target = FileUtils.createTempFile((String)(source.getName() + "."), (String)".formatted", (File)tempRoot);
            LineEndingsUtils.convertLineEndings(source, target, lineEnding, null, encoding);
            return target;
        }
        catch (FileNotFoundException e) {
            throw new AssemblyFormattingException("File to filter not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Error line formatting file '" + source + "': " + e.getMessage(), e);
        }
    }
}

