/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;

@Singleton
@Named(value="dependency-sets")
public class DependencySetAssemblyPhase
implements AssemblyArchiverPhase,
PhaseOrder {
    private final ProjectBuilder projectBuilder;
    private final DependencyResolver dependencyResolver;

    @Inject
    public DependencySetAssemblyPhase(ProjectBuilder projectBuilder, DependencyResolver dependencyResolver) {
        this.projectBuilder = Objects.requireNonNull(projectBuilder);
        this.dependencyResolver = Objects.requireNonNull(dependencyResolver);
    }

    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        Map<DependencySet, Set<Artifact>> resolved = this.dependencyResolver.resolveDependencySets(assembly, configSource, assembly.getDependencySets());
        for (Map.Entry<DependencySet, Set<Artifact>> dependencySetSetEntry : resolved.entrySet()) {
            AddDependencySetsTask task = new AddDependencySetsTask(Collections.singletonList(dependencySetSetEntry.getKey()), dependencySetSetEntry.getValue(), configSource.getProject(), this.projectBuilder);
            task.execute(archiver, configSource);
        }
    }

    @Override
    public int order() {
        return 40;
    }
}

