/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.changelog.ChangeLogReport;
import org.apache.maven.plugin.changelog.FileActivityComparator;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.codehaus.doxia.sink.Sink;

public class FileActivityReport
extends ChangeLogReport {
    public String getDescription(Locale locale) {
        return "Generate file activity report from SCM.";
    }

    public String getName(Locale locale) {
        return "File Activity";
    }

    public String getOutputName() {
        return "file-activity";
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(List changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        Iterator sets = changeLogSets.iterator();
        while (sets.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)sets.next();
            this.doChangedSets(set, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.table_();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.filename"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.timesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doRows(set, sink);
        sink.table_();
        sink.section2_();
    }

    private void doRows(ChangeLogSet set, Sink sink) {
        List list = this.getOrderedFileList(set.getChangeSets());
        this.initReportUrls();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            List revision = (List)i.next();
            ChangeFile file = (ChangeFile)revision.get(0);
            sink.tableRow();
            sink.tableCell();
            try {
                this.generateLinks(this.getConnection(), file.getName(), sink);
            }
            catch (Exception e) {
                e.printStackTrace();
                sink.text(file.getName());
            }
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + revision.size());
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private List getOrderedFileList(Collection entries) {
        LinkedList list = new LinkedList();
        HashMap map = new HashMap();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeSet entry = (ChangeSet)i.next();
            Iterator j = entry.getFiles().iterator();
            while (j.hasNext()) {
                ChangeFile file = (ChangeFile)j.next();
                List<Object> revisions = map.containsKey(file.getName()) ? (List)map.get(file.getName()) : new LinkedList<ChangeFile>();
                revisions.add(file);
                map.put(file.getName(), revisions);
            }
        }
        list.addAll(map.values());
        Collections.sort(list, new FileActivityComparator());
        return list;
    }
}

