/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-changes-plugin:2.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Changes Report Plugin 2.1", 0);
        this.append(sb, "Creates a release history for inclusion into the site and assists in generating an announcement mail.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "announcement-generate".equals(this.goal)) {
            this.append(sb, "changes:announcement-generate", 0);
            this.append(sb, "Goal which generate the template for an announcement.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "announceParameters", 2);
                this.append(sb, "Map which will be pass to the velocity context", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The current project base directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developmentTeam (Default: ${project.name} team)", 2);
                this.append(sb, "Name of the team that develops the artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the artifact to be used in the announcement.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateJiraAnnouncement (Default: false)", 2);
                this.append(sb, "Flag to determine if the plugin will generate a JIRA announcement.", 3);
                this.append(sb, "", 0);
                this.append(sb, "introduction (Default: ${project.description})", 2);
                this.append(sb, "Short description or introduction of the released artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jiraMerge (Default: false)", 2);
                this.append(sb, "The template encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jiraPassword", 2);
                this.append(sb, "Defines the JIRA password for authentication into a private JIRA installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jiraUser", 2);
                this.append(sb, "Defines the JIRA username for authentication into a private JIRA installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxEntries (Default: 25)", 2);
                this.append(sb, "The maximum number of issues to fetch from JIRA.\nNote: In versions 2.0-beta-3 and earlier this parameter was called 'nbEntries'.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory where the template file will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolutionIds (Default: Fixed)", 2);
                this.append(sb, "Only fixed issues are needed.\nNote: In versions 2.0-beta-3 and earlier this parameter was called 'resolutionId'.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "statusIds (Default: Closed)", 2);
                this.append(sb, "Only closed issues are needed.\nNote: In versions 2.0-beta-3 and earlier this parameter was called 'statusId'.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "template (Default: announcement.vm)", 2);
                this.append(sb, "The Velocity template used to format the announcement.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: org/apache/maven/plugin/announcement)", 2);
                this.append(sb, "Directory that contains the template.\nNote: This directory must be a subdirectory of /src/main/resources/ or current project base directory.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The template encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Distribution url of the artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "urlDownload", 2);
                this.append(sb, "URL where the artifact can be downloaded. If not specified, no URL is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${project.version})", 2);
                this.append(sb, "Version of the artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlPath", 2);
                this.append(sb, "The path of the changes.xml file.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "announcement-mail".equals(this.goal)) {
            this.append(sb, "changes:announcement-mail", 0);
            this.append(sb, "Goal which sends an announcement through email.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fromDeveloperId", 2);
                this.append(sb, "The id of the developer sending the announcement mail. Only used if the mailSender attribute is not set. In this case, this should match the id of one of the developers in the pom. If a matching developer is not found, then the first developer in the pom will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailContentType (Default: text/plain)", 2);
                this.append(sb, "Mail content type to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailSender", 2);
                this.append(sb, "Defines the sender of the announcement if the list of developer is empty or if the sender is not a member of the development team.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password used to send the email.", 3);
                this.append(sb, "", 0);
                this.append(sb, "smtpHost", 2);
                this.append(sb, "Smtp Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "smtpPort (Default: 25)", 2);
                this.append(sb, "Port.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sslMode (Default: false)", 2);
                this.append(sb, "If the email should be sent in SSL mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "subject (Default: [ANNOUNCEMENT] - ${project.name} ${project.version} released)", 2);
                this.append(sb, "Subject for the email.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template (Default: announcement.vm)", 2);
                this.append(sb, "The Velocity template used to format the announcement.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateOutputDirectory", 2);
                this.append(sb, "Directory which contains the template for announcement email.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toAddresses", 2);
                this.append(sb, "Recipient email address.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The username used to send the email.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "changes-report".equals(this.goal)) {
            this.append(sb, "changes:changes-report", 0);
            this.append(sb, "Goal which creates a nicely formatted Changes Report in html format from a changes.xml file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addActionDate (Default: false)", 2);
                this.append(sb, "A flag whether the report should also include the dates of individual actions. If set to false, only the dates of releases will be written to the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueLinkTemplate (Default: %URL%/ViewIssue.jspa?key=%ISSUE%)", 2);
                this.append(sb, "Deprecated. As of 2.1 use issueLinkTemplatePerSystem : this one will be with system default", 3);
                this.append(sb, "", 0);
                this.append(sb, "Template string that is used to discover the URL to use to display an issue report. There are 2 template tokens you can use. %URL%: this is computed by getting the <issueManagement>/<url> value from the POM, and removing the last '/' and everything that comes after it. %ISSUE%: this is the issue number.\nNote: In versions of this plugin prior to 2.0-beta-2 this parameter was called link_template.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueLinkTemplatePerSystem", 2);
                this.append(sb, "Template strings per system that is used to discover the URL to use to display an issue report. Each key in this map denotes the (case-sensitive) identifier of the issue tracking system and its value gives the URL template.\nThere are 2 template tokens you can use. %URL%: this is computed by getting the <issueManagement>/<url> value from the POM, and removing the last '/' and everything that comes after it. %ISSUE%: this is the issue number.\n\nNote: The deprecated issueLinkTemplate will be used for a system called 'default'.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlPath (Default: src/changes/changes.xml)", 2);
                this.append(sb, "The path of the changes.xml file that will be converted into an HTML report.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "changes-validate".equals(this.goal)) {
            this.append(sb, "changes:changes-validate", 0);
            this.append(sb, "Goal which validate the changes.xml file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "changesXsdVersion (Default: 1.0.0)", 2);
                this.append(sb, "The changes xsd version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "Mojo failure if validation failed. If not and validation failed only a warning will be logged.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlPath (Default: src/changes/changes.xml)", 2);
                this.append(sb, "The path of the changes.xml file that will be converted into an HTML report.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "changes:help", 0);
            this.append(sb, "Display help information on maven-changes-plugin.\nCall\n\u00a0\u00a0mvn\u00a0changes:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jira-report".equals(this.goal)) {
            this.append(sb, "changes:jira-report", 0);
            this.append(sb, "Goal which downloads issues from the Issue Tracking System and generates a report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "columnNames (Default: Key,Summary,Status,Resolution,Assignee)", 2);
                this.append(sb, "Sets the column names that you want to show in the report. The columns will appear in the report in the same order as you specify them here. Multiple values can be separated by commas.\nValid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version and Component.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "component", 2);
                this.append(sb, "Sets the component(s) that you want to limit your report to include. Multiple values can be separated by commas (such as 10011,10012). If this is set to empty - that means all components will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filter", 2);
                this.append(sb, "Defines the filter parameters to restrict which issues are retrieved from JIRA. The filter parameter uses the same format of url parameters that is used in a JIRA search.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fixVersionIds", 2);
                this.append(sb, "Sets the fix version id(s) that you want to limit your report to include. These are JIRA's internal version ids, NOT the human readable display ones. Multiple fix versions can be separated by commas. If this is set to empty - that means all fix versions will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jiraPassword", 2);
                this.append(sb, "Defines the JIRA password for authentication into a private JIRA installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jiraUser", 2);
                this.append(sb, "Defines the JIRA username for authentication into a private JIRA installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxEntries (Default: 100)", 2);
                this.append(sb, "Maximum number of entries to be fetched from JIRA.", 3);
                this.append(sb, "", 0);
                this.append(sb, "onlyCurrentVersion (Default: false)", 2);
                this.append(sb, "If you only want to show issues for the current version in the report. The current version being used is ${project.version} minus any '-SNAPSHOT' suffix.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "priorityIds", 2);
                this.append(sb, "Sets the priority(s) that you want to limit your report to include. Valid statuses are Blocker, Critical, Major, Minor and Trivial. Multiple values can be separated by commas. If this is set to empty - that means all priorities will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolutionIds (Default: Fixed)", 2);
                this.append(sb, "Sets the resolution(s) that you want to fetch from JIRA. Valid resolutions are: Unresolved, Fixed, Won't Fix, Duplicate, Incomplete and Cannot Reproduce. Multiple values can be separated by commas.\nNote: In versions 2.0-beta-3 and earlier this parameter had no default value.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "sortColumnNames (Default: Priority DESC, Created DESC)", 2);
                this.append(sb, "Sets the column names that you want to sort the report by. Add DESC following the column name to specify descending sequence. For example Fix Version DESC, Type sorts first by the Fix Version in descending order and then by Type in ascending order. By default sorting is done in ascending order, but is possible to specify ASC for consistency. The previous example would then become Fix Version DESC, Type ASC.\nValid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version, Component, Created and Updated.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "statusIds (Default: Closed)", 2);
                this.append(sb, "Sets the status(es) that you want to fetch from JIRA. Valid statuses are: Open, In Progress, Reopened, Resolved and Closed. Multiple values can be separated by commas.\nNote: In versions 2.0-beta-3 and earlier this parameter had no default value.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "typeIds", 2);
                this.append(sb, "Sets the types(s) that you want to limit your report to include. Valid types are: Bug, New Feature, Task, Improvement, Wish, Test and Sub-task. Multiple values can be separated by commas. If this is set to empty - that means all types will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webPassword", 2);
                this.append(sb, "Defines the http password for basic authentication into the JIRA webserver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webUser", 2);
                this.append(sb, "Defines the http user for basic authentication into the JIRA webserver.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "trac-report".equals(this.goal)) {
            this.append(sb, "changes:trac-report", 0);
            this.append(sb, "Goal which downloads issues from the Issue Tracking System and generates a report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "query (Default: order=id)", 2);
                this.append(sb, "Defines the Trac query for searching ticket.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tracPassword", 2);
                this.append(sb, "Defines the Trac password for authentication into a private Trac installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tracUser", 2);
                this.append(sb, "Defines the Trac username for authentication into a private Trac installation.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

