/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes.schema;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlValidationHandler
extends DefaultHandler {
    private boolean parsingError = false;
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private List<SAXParseException> fatalErrors = new ArrayList<SAXParseException>();
    private List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private boolean failOnValidationError;

    public XmlValidationHandler(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    @Override
    public void error(SAXParseException excp) throws SAXException {
        this.setErrorParsing(true);
        this.errors.add(excp);
        if (this.failOnValidationError) {
            throw new SAXException(excp.getMessage(), excp);
        }
    }

    @Override
    public void fatalError(SAXParseException excp) throws SAXException {
        this.fatalErrors.add(excp);
        if (this.failOnValidationError) {
            throw new SAXException(excp.getMessage(), excp);
        }
    }

    @Override
    public void warning(SAXParseException excp) throws SAXException {
        this.warnings.add(excp);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    public boolean isErrorParsing() {
        return this.parsingError;
    }

    public void setErrorParsing(boolean error) {
        this.parsingError = error;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public void setErrors(List<SAXParseException> errors) {
        this.errors = errors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    public void setFatalErrors(List<SAXParseException> fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<SAXParseException> warnings) {
        this.warnings = warnings;
    }
}

