/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jira.JiraQueryBuilder;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JqlQueryBuilder
implements JiraQueryBuilder {
    private String filter = "";
    private boolean urlEncode = true;
    private Log log;
    private StringBuilder orderBy = new StringBuilder();
    private StringBuilder query = new StringBuilder();

    public JqlQueryBuilder(Log log) {
        this.log = log;
    }

    @Override
    public String build() {
        try {
            String jqlQuery = this.filter != null && this.filter.length() > 0 ? this.filter : this.query.toString() + this.orderBy.toString();
            if (this.urlEncode) {
                this.getLog().debug((CharSequence)("Encoding JQL query " + jqlQuery));
                String encodedQuery = URLEncoder.encode(jqlQuery, "UTF-8");
                this.getLog().debug((CharSequence)("Encoded JQL query " + encodedQuery));
                return encodedQuery;
            }
            return jqlQuery;
        }
        catch (UnsupportedEncodingException e) {
            this.getLog().error((CharSequence)"Unable to encode JQL query with UTF-8", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public JiraQueryBuilder components(String components) {
        this.addCommaSeparatedValues("component", components);
        return this;
    }

    @Override
    public JiraQueryBuilder components(List<String> components) {
        this.addValues("component", components);
        return this;
    }

    @Override
    public JiraQueryBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersion(String fixVersion) {
        this.addSingleValue("fixVersion", fixVersion);
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersionIds(String fixVersionIds) {
        this.addCommaSeparatedValues("fixVersion", fixVersionIds);
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersionIds(List<String> fixVersionIds) {
        this.addValues("fixVersion", fixVersionIds);
        return this;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public JiraQueryBuilder priorityIds(String priorityIds) {
        this.addCommaSeparatedValues("priority", priorityIds);
        return this;
    }

    @Override
    public JiraQueryBuilder priorityIds(List<String> priorityIds) {
        this.addValues("priority", priorityIds);
        return this;
    }

    @Override
    public JiraQueryBuilder project(String project) {
        this.addSingleValue("project", project);
        return this;
    }

    @Override
    public JiraQueryBuilder resolutionIds(String resolutionIds) {
        this.addCommaSeparatedValues("resolution", resolutionIds);
        return this;
    }

    @Override
    public JiraQueryBuilder resolutionIds(List<String> resolutionIds) {
        this.addValues("resolution", resolutionIds);
        return this;
    }

    @Override
    public JiraQueryBuilder sortColumnNames(String sortColumnNames) {
        if (sortColumnNames != null) {
            this.orderBy.append(" ORDER BY ");
            String[] sortColumnNamesArray = sortColumnNames.split(",");
            for (int i = 0; i < sortColumnNamesArray.length - 1; ++i) {
                this.addSingleSortColumn(sortColumnNamesArray[i]);
                this.orderBy.append(", ");
            }
            this.addSingleSortColumn(sortColumnNamesArray[sortColumnNamesArray.length - 1]);
        }
        return this;
    }

    @Override
    public JiraQueryBuilder statusIds(String statusIds) {
        this.addCommaSeparatedValues("status", statusIds);
        return this;
    }

    @Override
    public JiraQueryBuilder statusIds(List<String> statusIds) {
        this.addValues("status", statusIds);
        return this;
    }

    @Override
    public JiraQueryBuilder typeIds(String typeIds) {
        this.addCommaSeparatedValues("type", typeIds);
        return this;
    }

    @Override
    public JiraQueryBuilder typeIds(List<String> typeIds) {
        this.addValues("type", typeIds);
        return this;
    }

    public JiraQueryBuilder urlEncode(boolean doEncoding) {
        this.urlEncode = doEncoding;
        return this;
    }

    public boolean urlEncode() {
        return this.urlEncode;
    }

    private void addCommaSeparatedValues(String key, String values) {
        if (values != null) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" in (");
            String[] valuesArr = values.split(",");
            for (int i = 0; i < valuesArr.length - 1; ++i) {
                this.trimAndQuoteValue(valuesArr[i]);
                this.query.append(", ");
            }
            this.trimAndQuoteValue(valuesArr[valuesArr.length - 1]);
            this.query.append(")");
        }
    }

    private void addValues(String key, List<String> values) {
        if (values != null && values.size() > 0) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" in (");
            for (int i = 0; i < values.size() - 1; ++i) {
                this.trimAndQuoteValue(values.get(i));
                this.query.append(", ");
            }
            this.trimAndQuoteValue(values.get(values.size() - 1));
            this.query.append(")");
        }
    }

    private void addSingleSortColumn(String name) {
        boolean descending = false;
        if ((name = name.trim().toLowerCase(Locale.ENGLISH)).endsWith("desc")) {
            descending = true;
            name = name.substring(0, name.length() - 4).trim();
        } else if (name.endsWith("asc")) {
            descending = false;
            name = name.substring(0, name.length() - 3).trim();
        }
        name = name.replaceAll(" ", "");
        this.orderBy.append(name);
        this.orderBy.append(descending ? " DESC" : " ASC");
    }

    private void addSingleValue(String key, String value) {
        if (value != null) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" = ");
            this.trimAndQuoteValue(value);
        }
    }

    private void trimAndQuoteValue(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.contains(" ") || trimmedValue.contains(".")) {
            this.query.append("\"").append(trimmedValue).append("\"");
        } else {
            this.query.append(trimmedValue);
        }
    }
}

