/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.jira;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArraySorter;
import org.apache.maven.plugin.logging.Log;

public class JqlQueryBuilder {
    private static final String[] RESERVED_JQL_WORDS = (String[])ArraySorter.sort((Object[])new String[]{"abort", "access", "add", "after", "alias", "all", "alter", "and", "any", "as", "asc", "audit", "avg", "before", "begin", "between", "boolean", "break", "by", "byte", "catch", "cf", "char", "character", "check", "checkpoint", "collate", "collation", "column", "commit", "connect", "continue", "count", "create", "current", "date", "decimal", "declare", "decrement", "default", "defaults", "define", "delete", "delimiter", "desc", "difference", "distinct", "divide", "do", "double", "drop", "else", "empty", "encoding", "end", "equals", "escape", "exclusive", "exec", "execute", "exists", "explain", "false", "fetch", "file", "field", "first", "float", "for", "from", "function", "go", "goto", "grant", "greater", "group", "having", "identified", "if", "immediate", "in", "increment", "index", "initial", "inner", "inout", "input", "insert", "int", "integer", "intersect", "intersection", "into", "is", "isempty", "isnull", "join", "last", "left", "less", "like", "limit", "lock", "long", "max", "min", "minus", "mode", "modify", "modulo", "more", "multiply", "next", "noaudit", "not", "notin", "nowait", "null", "number", "object", "of", "on", "option", "or", "order", "outer", "output", "power", "previous", "prior", "privileges", "public", "raise", "raw", "remainder", "rename", "resource", "return", "returns", "revoke", "right", "row", "rowid", "rownum", "rows", "select", "session", "set", "share", "size", "sqrt", "start", "strict", "string", "subtract", "sum", "synonym", "table", "then", "to", "trans", "transaction", "trigger", "true", "uid", "union", "unique", "update", "user", "validate", "values", "view", "when", "whenever", "where", "while", "with"});
    private String filter = "";
    private boolean urlEncode = true;
    private Log log;
    private StringBuilder orderBy = new StringBuilder();
    private StringBuilder query = new StringBuilder();

    public JqlQueryBuilder(Log log) {
        this.log = log;
    }

    public String build() {
        try {
            String jqlQuery = this.filter != null && !this.filter.isEmpty() ? this.filter : this.query.toString() + this.orderBy.toString();
            if (this.urlEncode) {
                this.getLog().debug((CharSequence)("Encoding JQL query " + jqlQuery));
                String encodedQuery = URLEncoder.encode(jqlQuery, "UTF-8");
                this.getLog().debug((CharSequence)("Encoded JQL query " + encodedQuery));
                return encodedQuery;
            }
            return jqlQuery;
        }
        catch (UnsupportedEncodingException e) {
            this.getLog().error((CharSequence)"Unable to encode JQL query with UTF-8", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public JqlQueryBuilder components(String components) {
        this.addCommaSeparatedValues("component", components);
        return this;
    }

    public JqlQueryBuilder components(List<String> components) {
        this.addValues("component", components);
        return this;
    }

    public JqlQueryBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    public JqlQueryBuilder fixVersion(String fixVersion) {
        this.addSingleValue("fixVersion", fixVersion);
        return this;
    }

    public JqlQueryBuilder fixVersionIds(String fixVersionIds) {
        this.addCommaSeparatedValues("fixVersion", fixVersionIds);
        return this;
    }

    public JqlQueryBuilder fixVersionIds(List<String> fixVersionIds) {
        this.addValues("fixVersion", fixVersionIds);
        return this;
    }

    public Log getLog() {
        return this.log;
    }

    public JqlQueryBuilder priorityIds(String priorityIds) {
        this.addCommaSeparatedValues("priority", priorityIds);
        return this;
    }

    public JqlQueryBuilder priorityIds(List<String> priorityIds) {
        this.addValues("priority", priorityIds);
        return this;
    }

    public JqlQueryBuilder project(String project) {
        this.addSingleValue("project", project);
        return this;
    }

    public JqlQueryBuilder resolutionIds(String resolutionIds) {
        this.addCommaSeparatedValues("resolution", resolutionIds);
        return this;
    }

    public JqlQueryBuilder resolutionIds(List<String> resolutionIds) {
        this.addValues("resolution", resolutionIds);
        return this;
    }

    public JqlQueryBuilder sortColumnNames(String sortColumnNames) {
        if (sortColumnNames != null) {
            this.orderBy.append(" ORDER BY ");
            String[] sortColumnNamesArray = sortColumnNames.split(",");
            for (int i = 0; i < sortColumnNamesArray.length - 1; ++i) {
                this.addSingleSortColumn(sortColumnNamesArray[i]);
                this.orderBy.append(", ");
            }
            this.addSingleSortColumn(sortColumnNamesArray[sortColumnNamesArray.length - 1]);
        }
        return this;
    }

    public JqlQueryBuilder statusIds(String statusIds) {
        this.addCommaSeparatedValues("status", statusIds);
        return this;
    }

    public JqlQueryBuilder statusIds(List<String> statusIds) {
        this.addValues("status", statusIds);
        return this;
    }

    public JqlQueryBuilder typeIds(String typeIds) {
        this.addCommaSeparatedValues("type", typeIds);
        return this;
    }

    public JqlQueryBuilder typeIds(List<String> typeIds) {
        this.addValues("type", typeIds);
        return this;
    }

    public JqlQueryBuilder urlEncode(boolean doEncoding) {
        this.urlEncode = doEncoding;
        return this;
    }

    public boolean urlEncode() {
        return this.urlEncode;
    }

    private void addCommaSeparatedValues(String key, String values) {
        if (values != null) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" in (");
            String[] valuesArr = values.split(",");
            for (int i = 0; i < valuesArr.length - 1; ++i) {
                this.trimAndQuoteValue(valuesArr[i]);
                this.query.append(", ");
            }
            this.trimAndQuoteValue(valuesArr[valuesArr.length - 1]);
            this.query.append(")");
        }
    }

    private void addValues(String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" in (");
            for (int i = 0; i < values.size() - 1; ++i) {
                this.trimAndQuoteValue(values.get(i));
                this.query.append(", ");
            }
            this.trimAndQuoteValue(values.get(values.size() - 1));
            this.query.append(")");
        }
    }

    private void addSingleSortColumn(String name) {
        boolean descending = false;
        if ((name = name.trim().toLowerCase(Locale.ENGLISH)).endsWith("desc")) {
            descending = true;
            name = name.substring(0, name.length() - 4).trim();
        } else if (name.endsWith("asc")) {
            descending = false;
            name = name.substring(0, name.length() - 3).trim();
        }
        name = name.replaceAll(" ", "");
        this.orderBy.append(name);
        this.orderBy.append(descending ? " DESC" : " ASC");
    }

    private void addSingleValue(String key, String value) {
        if (value != null) {
            if (this.query.length() > 0) {
                this.query.append(" AND ");
            }
            this.query.append(key).append(" = ");
            this.trimAndQuoteValue(value);
        }
    }

    private void trimAndQuoteValue(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.contains(" ") || trimmedValue.contains(".") || this.isReservedJqlWord(trimmedValue)) {
            this.query.append("\"").append(trimmedValue).append("\"");
        } else {
            this.query.append(trimmedValue);
        }
    }

    private boolean isReservedJqlWord(String value) {
        return Arrays.binarySearch(RESERVED_JQL_WORDS, value.toLowerCase(Locale.ROOT)) > 0;
    }
}

