/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.plugins.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugins.changes.schema.SchemaValidatorException;
import org.apache.maven.plugins.changes.schema.XmlValidationHandler;
import org.xml.sax.SAXException;

@Named
@Singleton
public class DefaultChangesSchemaValidator
implements ChangesSchemaValidator {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String CHANGES_SCHEMA_PATH = "META-INF/changes/xsd/";
    private Map<String, Schema> compiledSchemas = new HashMap<String, Schema>();

    @Override
    public XmlValidationHandler validateXmlWithSchema(File file, String schemaVersion, boolean failOnValidationError) throws SchemaValidatorException {
        try {
            String schemaPath = "META-INF/changes/xsd/changes-" + schemaVersion + ".xsd";
            Schema schema = this.getSchema(schemaPath);
            Validator validator = schema.newValidator();
            XmlValidationHandler baseHandler = new XmlValidationHandler(failOnValidationError);
            validator.setErrorHandler(baseHandler);
            try (XmlStreamReader reader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setFile(file)).get();){
                validator.validate(new StreamSource((Reader)reader));
            }
            return baseHandler;
        }
        catch (IOException e) {
            throw new SchemaValidatorException("IOException : " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SchemaValidatorException("SAXException : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SchemaValidatorException("Exception : " + e.getMessage(), e);
        }
    }

    public Schema getSchema(String schemaPath) throws SAXException, IOException {
        if (this.compiledSchemas.containsKey(schemaPath)) {
            return this.compiledSchemas.get(schemaPath);
        }
        Schema schema = this.compileJAXPSchema(schemaPath);
        this.compiledSchemas.put(schemaPath, schema);
        return schema;
    }

    private Schema compileJAXPSchema(String uriSchema) throws IOException, SAXException, NullPointerException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uriSchema);){
            Schema schema;
            if (in == null) {
                throw new NullPointerException(" impossible to load schema with path " + uriSchema);
            }
            Schema schema2 = schema = SchemaFactory.newInstance(W3C_XML_SCHEMA).newSchema(new StreamSource(in));
            return schema2;
        }
    }

    public void loadSchema(String uriSchema) throws SchemaValidatorException {
        try {
            this.getSchema(uriSchema);
        }
        catch (SAXException e) {
            throw new SchemaValidatorException("SAXException : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SchemaValidatorException("IOException : " + e.getMessage(), e);
        }
    }
}

