/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle.resource;

import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.DefaultResourceManager;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.ThreadContextClasspathResourceLoader;

@Component(role=ResourceManager.class, hint="license")
public class LicenseResourceManager
extends DefaultResourceManager {
    @Requirement(role=ResourceLoader.class)
    private Map<String, ResourceLoader> resourceLoaders;

    public void addSearchPath(String id, String path) {
        ResourceLoader loader = this.resourceLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + id);
        }
        loader.addSearchPath(path);
    }

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            if (resourceLoader instanceof ThreadContextClasspathResourceLoader && !"config/maven-header.txt".equals(name)) continue;
            try {
                PlexusResource resource = resourceLoader.getResource(name);
                this.getLogger().debug("The resource '" + name + "'" + " was found as " + resource.getName() + ".");
                return resource;
            }
            catch (ResourceNotFoundException e) {
                this.getLogger().debug("The resource '" + name + "'" + " was not found with resourceLoader " + resourceLoader.getClass().getName() + ".");
            }
        }
        throw new ResourceNotFoundException(name);
    }
}

