/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private File outputFile;
    private String outputFileFormat;
    private boolean failOnViolation;
    private String violationSeverity = "error";
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (!"xml".equals(this.outputFileFormat)) {
                throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml'.");
            }
            if (!this.outputFile.exists()) {
                this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
                return;
            }
            try {
                MXParser xpp = new MXParser();
                InputStreamReader freader = new InputStreamReader((InputStream)new FileInputStream(this.outputFile), "UTF-8");
                BufferedReader breader = new BufferedReader(freader);
                xpp.setInput((Reader)breader);
                int violations = this.countViolations((XmlPullParser)xpp);
                if (violations > 0) {
                    if (this.failOnViolation) {
                        throw new MojoFailureException("You have " + violations + " Checkstyle violation" + (violations > 1 ? "s" : "") + ".");
                    }
                    this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)e);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)((Object)e));
            }
        }
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && "error".equals(xpp.getName()) && this.isViolation(xpp.getAttributeValue("", "severity"))) {
                ++count;
            }
            eventType = xpp.next();
        }
        return count;
    }

    private boolean isViolation(String severity) {
        if ("error".equals(severity)) {
            return "error".equals(this.violationSeverity) || "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("warning".equals(severity)) {
            return "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("info".equals(severity)) {
            return "info".equals(this.violationSeverity);
        }
        return false;
    }
}

