/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover.internal;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.DefaultLocator;
import org.apache.maven.plugin.clover.internal.Locator;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Taskdef;

public abstract class AbstractCloverMojo
extends AbstractMojo {
    private String cloverDatabase;
    private String cloverMergeDatabase;
    private String licenseFile;
    private String licenseLocation;
    private String flushPolicy;
    private int flushInterval;
    private boolean waitForFlush;
    private String jdk;
    private MavenProject project;
    private Locator locator;

    public void execute() throws MojoExecutionException {
        if (this.locator == null) {
            this.locator = new DefaultLocator(this.getLog(), new File(this.project.getBuild().getDirectory()));
        }
        this.registerLicenseFile();
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected void registerLicenseFile() throws MojoExecutionException {
        String license;
        if (this.licenseLocation != null) {
            try {
                license = this.getLocator().resolveLocation(this.licenseLocation, "clover.license").getPath();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load license file", (Exception)e);
            }
        } else if (this.licenseFile != null) {
            this.getLog().warn((CharSequence)"Deprecation warning: please use licenseLocation instead of LicenseFile");
            license = this.licenseFile;
        } else {
            license = ((Object)((Object)this)).getClass().getResource("/clover.license").getFile();
        }
        System.setProperty("clover.license.path", license);
    }

    public static Project registerCloverAntTasks() {
        Project antProject = new Project();
        antProject.init();
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setResource("clovertasks");
        taskdef.execute();
        return antProject;
    }

    public static void waitForFlush(boolean waitForFlush, int flushInterval) {
        if (waitForFlush) {
            try {
                Thread.sleep(2 * flushInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean areCloverDatabasesAvailable() {
        boolean shouldRun = false;
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            shouldRun = true;
        }
        return shouldRun;
    }

    protected void setLicenseLocation(String licenseLocation) {
        this.licenseLocation = licenseLocation;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected boolean getWaitForFlush() {
        return this.waitForFlush;
    }

    protected String getJdk() {
        return this.jdk;
    }

    protected String getCloverDatabase() {
        return this.cloverDatabase;
    }

    protected String getCloverMergeDatabase() {
        return this.cloverMergeDatabase;
    }

    protected int getFlushInterval() {
        return this.flushInterval;
    }

    protected String getFlushPolicy() {
        return this.flushPolicy;
    }
}

